/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.operator.ModelApplier;

public abstract class TupleWiseModelApplier
extends ModelApplier {
    protected void predict() throws M4Exception, M4CompilerError {
        Long fromRowNum = null;
        Long toRowNum = null;
        String sql = this.getDatabaseQueryForRows(fromRowNum, toRowNum);
        Vector keyNameCol = this.getKeyColumnNames();
        String keyNames = ModelApplier.stringCollectionToCommaSeparatedString(keyNameCol);
        Vector predByNameCol = this.getPredictionColumnNames();
        String predByNames = ModelApplier.stringCollectionToCommaSeparatedString(predByNameCol);
        Vector<String> predTargetsCol = new Vector<String>();
        StringBuffer predictBuf = new StringBuffer();
        int loop = 0;
        while (loop < this.getNumberOfLoops()) {
            BaseAttribute curPredBa = this.getPredictedAttribute(loop);
            String predColName = curPredBa.getName();
            predTargetsCol.add(predColName);
            this.createPredictedAttributeInDb(loop);
            ++loop;
        }
        String predTargets = ModelApplier.stringCollectionToCommaSeparatedString(predTargetsCol);
        String targetTable = this.getTargetTableName();
        String sqlPre = "INSERT INTO " + targetTable + " ( " + keyNames + ", " + predTargets + " ) VALUES ( ";
        String sqlPost = " )";
        try {
            ResultSet rs = this.executeBusinessSqlRead(sql);
            while (rs.next()) {
                String[] targetTableValues = new String[keyNameCol.size() + predTargetsCol.size()];
                int i = 0;
                while (i < keyNameCol.size()) {
                    targetTableValues[i] = rs.getString((String)keyNameCol.get(i));
                    ++i;
                }
                String[] predInfo = new String[predByNameCol.size()];
                int i2 = 0;
                while (i2 < predByNameCol.size()) {
                    predInfo[i2] = rs.getString((String)predByNameCol.get(i2));
                    ++i2;
                }
                i2 = 0;
                while (i2 < predTargetsCol.size()) {
                    targetTableValues[i2 + keyNameCol.size()] = this.getPredictionFor(predInfo);
                    ++i2;
                }
                this.insertIntoDb(targetTableValues, sqlPre, sqlPost);
            }
        }
        catch (SQLException e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    protected void insertIntoDb(String[] valueArray, String sqlPrefix, String sqlSuffix) throws M4CompilerError, SQLException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < valueArray.length) {
            buf.append(String.valueOf(valueArray[i]) + ", ");
            ++i;
        }
        String sql = String.valueOf(sqlPrefix) + buf.substring(0, buf.length() - 2) + sqlSuffix;
        this.executeBusinessSqlWrite(sql);
    }

    protected abstract String getPredictionFor(String[] var1);
}

