/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import de.dbo.sm.SourceDatabase;
import de.dbo.sm.Start;
import de.dbo.sm.SubgroupMiningParams;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.OpParam;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.ExecutableOperator;

public class SubgroupMining
extends ExecutableOperator {
    private final boolean dbg;
    private static final String TABLE_NAME = "TheInputConcept";
    private static final String TARGET_COLUMN = "TheTargetAttribute";
    private static final String TARGET_VALUE = "TargetValue";
    private static final String ID_ATTRIBUTE = "TheKey";
    private static final String ATTRIBUTE_SPACE = "ThePredictingAttributes";
    private static final String SEARCH_DEPTH = "SearchDepth";
    private static final String MIN_SUPPORT = "MinSupport";
    private static final String MIN_CONFIDIENCE = "MinConfidence";
    private static final String NUM_HYPOTHESES = "NumHypotheses";
    private static final String RULE_CLUSTERS = "RuleClusters";
    private Start start = null;

    public SubgroupMining() {
        String x = System.getProperty("SUBGROUP_DBG");
        this.dbg = x != null && x.toString().equals("yes");
        if (this.dbg) {
            System.out.println("## CONSTRUCTOR in \"miningmart.compiler.operator.SubgroupMining\" finished");
        }
    }

    public void execute(boolean x) throws M4CompilerError {
        if (this.dbg) {
            System.out.println("## EXECUTE in \"miningmart.compiler.operator.SubgroupMining\" ... ");
            this.printTheStep();
            this.printInputParamNames();
            this.printInputParams();
        }
        this.runSubgroupMining();
        try {
            super.execute(x);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    public void writeResults() {
        if (this.dbg) {
            System.out.println("## RESULTS from \"miningmart.compiler.operator.SubgroupMining\": ");
        }
        System.out.println("\n\n---------------------------------------------------------");
        ArrayList result = this.start.getResult();
        if (result != null && !result.isEmpty()) {
            System.out.println("Subgroup-Mining finished and results have been generated:");
            System.out.println(this.start.getResultAsString());
        } else {
            System.err.println("Subgroup-Mining finished BUT NO results have been generated");
        }
    }

    public void compileStatement() {
        if (this.dbg) {
            System.out.println("## STATEMENT compilation in \"miningmart.compiler.operator.SubgroupMining\" ... ");
        }
    }

    public void createStatement(boolean x) {
        if (this.dbg) {
            System.out.println("## STATEMENT creation in \"miningmart.compiler.operator.SubgroupMining\" ... ");
        }
    }

    private final String getTableName() {
        try {
            String completeTableName = ((Concept)this.getSingleParameter(TABLE_NAME)).getCurrentColumnSet().getSchemaPlusName();
            int n = completeTableName.indexOf(".");
            return completeTableName.substring(n + 1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private final String getTargetColumn() {
        return this.databaseColumn((BaseAttribute)this.getSingleParameter(TARGET_COLUMN));
    }

    private final Vector getAttributeSpace() {
        Vector<String> ret = new Vector<String>();
        ParameterObject[] params = this.getParameter(ATTRIBUTE_SPACE);
        int n = params.length;
        int i = 0;
        while (i < n) {
            ret.add(this.databaseColumn((BaseAttribute)params[i]));
            ++i;
        }
        return ret;
    }

    private final String getIdAttribute() {
        return this.databaseColumn((BaseAttribute)this.getSingleParameter(ID_ATTRIBUTE));
    }

    private final String getTargetValue() {
        return ((Value)this.getSingleParameter(TARGET_VALUE)).getValue();
    }

    private final int getSearchDepth() {
        return new Integer(((Value)this.getSingleParameter(SEARCH_DEPTH)).getValue());
    }

    private final int getNumHypotheses() {
        return new Integer(((Value)this.getSingleParameter(NUM_HYPOTHESES)).getValue());
    }

    private final double getMinSupport() {
        return new Double(((Value)this.getSingleParameter(MIN_SUPPORT)).getValue());
    }

    private final double getMinConfidence() {
        return new Double(((Value)this.getSingleParameter(MIN_CONFIDIENCE)).getValue());
    }

    private final boolean getRuleClusters() {
        return ((Value)this.getSingleParameter(RULE_CLUSTERS)).getValue().equals("YES");
    }

    private final String databaseColumn(BaseAttribute ba) {
        try {
            return ba.getCurrentColumn().getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void runSubgroupMining() throws M4CompilerError {
        if (!this.dbg) {
            System.out.println("\nStarting Subgroup-mining algorithm ... ");
        }
        this.start = new Start(new SourceDatabase(this.getM4Db().getDatabaseConnectionForData()), new SubgroupMiningParams(this.getTableName(), this.getTargetColumn(), this.getTargetValue(), this.getIdAttribute(), this.getAttributeSpace(), this.getSearchDepth(), this.getMinSupport(), this.getMinConfidence(), this.getNumHypotheses(), this.getRuleClusters()), this.dbg);
        if (this.dbg) {
            System.out.println("\n##### Running Subgroup-Mining algorithm ###############################\n");
        }
        this.start.doit();
    }

    private final void printInputParams() {
        System.out.println("----------------------------------------------------");
        System.out.println("Input parameters: ");
        System.out.print("TheInputConcept= ");
        System.out.println(this.getTableName());
        System.out.print("TheTargetAttribute= ");
        System.out.println(this.getTargetColumn());
        System.out.print("TheKey= ");
        System.out.println(this.getIdAttribute());
        System.out.print("ThePredictingAttributes= ");
        SubgroupMining.printStrings(this.getAttributeSpace());
        System.out.print("TargetValue= ");
        System.out.println(this.getTargetValue());
        System.out.print("SearchDepth= ");
        System.out.println(this.getSearchDepth());
        System.out.print("NumHypotheses= ");
        System.out.println(this.getNumHypotheses());
        System.out.print("MinSupport= ");
        System.out.println(this.getMinSupport());
        System.out.print("MinSupport= ");
        System.out.println(this.getMinConfidence());
        System.out.print("RuleClusters= ");
        System.out.println(this.getRuleClusters());
    }

    private final void printInputParamNames() {
        System.out.println("----------------------------------------------------");
        System.out.println("Names of the input parameters: ");
        try {
            Iterator params = this.getOpParamsIterator();
            while (params.hasNext()) {
                System.out.println(((OpParam)params.next()).getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final void printTheStep() {
        try {
            Step step = this.getStep();
            System.out.println("----------------------------------------------------");
            System.out.println("Step infos: ");
            System.out.println("MM STEP ID   = " + step.getId());
            System.out.println("MM STEP NUMB = " + step.getNumber());
            System.out.println("MM STEP NAME = " + step.getName());
            System.out.println("MM STEP OPNA = " + step.getTheOperator().getName());
            System.out.println("MM CASE NAME = " + step.getTheCase().getName());
            System.out.println("MM CASE ID   = " + step.getTheCase().getId());
            System.out.println("MM CASE SN   = " + step.getTheCase().getNumberOfSteps());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static final void printStrings(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            System.out.print(String.valueOf(en.nextElement().toString()) + " ");
        }
        System.out.println();
    }
}

