/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.operator.FeatureConstruction;
import miningmart.compiler.wrapper.SVM_Wrapper;

public abstract class SVMforDataMining
extends FeatureConstruction {
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    protected abstract SVM_Wrapper constructWrapper(boolean var1) throws M4CompilerError;

    public String generateSQL(Column columnToFill) throws M4CompilerError {
        this.callStatement(columnToFill);
        String fctCall = String.valueOf(this.mysvm.getDecisionFunctionName()) + "(";
        try {
            int i = 0;
            while (i < this.getThePredictingAttributes().length) {
                fctCall = String.valueOf(fctCall) + this.getThePredictingAttributes()[i].getCurrentColumn().getSQLDefinition() + ", ";
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        fctCall = String.valueOf(fctCall.substring(0, fctCall.length() - 2)) + ")";
        return fctCall;
    }

    private void callStatement(Column columnToFill) throws M4CompilerError {
        this.useDatabaseSVM = this.getUseDatabaseSVM();
        this.mysvm = this.constructWrapper(this.useDatabaseSVM);
        try {
            Columnset theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
            String fctSchema = theColumnSet.getSchema();
            if (fctSchema.length() == 0) {
                fctSchema = null;
            }
            Vector<Column> theCols = new Vector<Column>();
            int i = 0;
            while (i < this.getThePredictingAttributes().length) {
                theCols.add(this.getThePredictingAttributes()[i].getCurrentColumn());
                ++i;
            }
            theCols.trimToSize();
            this.mysvm.callSVM(theColumnSet, columnToFill, this.getTheInputConcept().getId(), this.getC(), this.getKernelType(), this.getEpsilon(), theCols);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM-Wrapper: could not commit DB updates: " + sqle.getMessage());
        }
    }

    protected String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            String loopIdentification = "";
            if (this.getHighestLoopNr() > 1) {
                loopIdentification = "L" + this.getCurrentLoopNumber();
            }
            return String.valueOf(this.getTheInputConcept().getCurrentColumnSet().getName()) + loopIdentification;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getC() {
        return ((Value)this.getSingleParameter("C", this.getCurrentLoopNumber())).getValue();
    }

    public BaseAttribute getKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey", this.getCurrentLoopNumber());
    }

    public String getEpsilon() {
        return ((Value)this.getSingleParameter("Epsilon", this.getCurrentLoopNumber())).getValue();
    }

    public String getKernelType() {
        return ((Value)this.getSingleParameter("KernelType", this.getCurrentLoopNumber())).getValue();
    }

    public String getLossFunctionNeg() {
        return ((Value)this.getSingleParameter("LossFunctionNeg", this.getCurrentLoopNumber())).getValue();
    }

    public String getLossFunctionPos() {
        return ((Value)this.getSingleParameter("LossFunctionPos", this.getCurrentLoopNumber())).getValue();
    }

    public long getSampleSize() throws M4CompilerError {
        long sample;
        Value v = (Value)this.getSingleParameter("SampleSize", this.getCurrentLoopNumber());
        if (v == null) {
            return -1L;
        }
        try {
            sample = Long.parseLong(v.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SupportVectorMachineForRegression: SampleSize must be an integer! Found: " + v.getValue());
        }
        return sample;
    }

    public BaseAttribute[] getThePredictingAttributes() {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", this.getCurrentLoopNumber());
    }

    public boolean getUseDatabaseSVM() {
        Value v = (Value)this.getSingleParameter("UseDB_SVM", this.getCurrentLoopNumber());
        if (v == null) {
            return this.useDatabaseSVM;
        }
        String s = v.getValue();
        return s.equalsIgnoreCase("true");
    }
}

