/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.SingleCSOperator;

public abstract class ModelApplier
extends SingleCSOperator {
    private final Vector keyColumns = new Vector();
    private final Vector predictionColumns = new Vector();
    private final Vector tablesAttributes = new Vector();
    static /* synthetic */ Class class$0;

    public Vector getKeyColumns() {
        return this.keyColumns;
    }

    public Vector getKeyColumnNames() {
        return ModelApplier.columnsToColumnNames(this.getKeyColumns());
    }

    public Vector getPredictionColumns() {
        return this.predictionColumns;
    }

    public Vector getPredictionColumnNames() {
        return ModelApplier.columnsToColumnNames(this.getPredictionColumns());
    }

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    private static Vector columnsToColumnNames(Collection columns) {
        Iterator it = columns.iterator();
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Column col = (Column)it.next();
            if (col == null) continue;
            names.add(col.getName());
        }
        return names;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        try {
            this.initKeyColumns();
            this.initPredictionColumns();
            String targetTable = this.getTargetTableName();
            Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
            String csSql = inputCs.getSQLDefinition();
            Iterator it = inputCs.getColumns().iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                String sql = col.getSQLDefinition();
                if (sql == null || sql.equals(col.getName()) || sql.length() == 0) continue;
                csSql = inputCs.getCompleteSQLQuery();
                break;
            }
            Iterator it2 = ((AbstractList)this.getKeyColumns()).iterator();
            StringBuffer whereBuf = new StringBuffer();
            while (it2.hasNext()) {
                Column keyC = (Column)it2.next();
                String colName = keyC.getName();
                whereBuf.append("V1." + colName + " = V2." + colName + ", ");
            }
            String whereList = whereBuf.substring(0, whereBuf.length() - 2);
            this.createPredictionsTable();
            this.predict();
            String selectList = this.getViewsSelectList(inputCs, "V1", "V2");
            return "( SELECT " + selectList + " FROM " + csSql + " V1, " + targetTable + " V2 " + "WHERE " + whereList + " )";
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    private String getViewsSelectList(Columnset inputCs, String inputCsPrefix, String tablePrefix) throws M4Exception {
        StringBuffer attributes = new StringBuffer();
        HashSet<String> keys = new HashSet<String>();
        Iterator it = ((AbstractList)this.getKeyColumns()).iterator();
        while (it.hasNext()) {
            keys.add(((Column)it.next()).getName());
        }
        it = inputCs.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            String name = column.getName();
            if (keys.contains(name)) continue;
            String sql = column.getSQLDefinition();
            if (!sql.equals(name)) {
                sql = String.valueOf(sql) + " " + name;
            }
            attributes.append(String.valueOf(inputCsPrefix) + "." + sql + ", ");
        }
        it = ((AbstractList)this.tablesAttributes).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            attributes.append(String.valueOf(tablePrefix) + "." + name + ", ");
        }
        return attributes.substring(0, attributes.length() - 2);
    }

    private void createPredictionsTable() throws M4Exception, M4CompilerError {
        String tableName = this.getTargetTableName();
        CompilerDatabaseService db = this.getM4Db();
        Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
        String inCsSql = inputCs.getSQLDefinition();
        db.dropBusinessTable(tableName);
        String sql = "CREATE TABLE " + tableName + " AS ( SELECT " + this.getSelectStatementOfKeys() + " FROM " + inCsSql + " )";
        try {
            db.executeBusinessSqlWrite(sql);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException when trying to create an intermediate table '" + tableName + "'!\nSQL statement was:\n" + sql + "\nException message:\n" + e.getMessage());
        }
        db.addTableToTrash(tableName, inputCs.getSchema(), this.getStep().getId());
        Iterator it = ((AbstractList)this.getKeyColumns()).iterator();
        StringBuffer pkBuf = new StringBuffer();
        while (it.hasNext()) {
            String attribName = ((Column)it.next()).getName();
            this.tablesAttributes.add(attribName);
            pkBuf.append(String.valueOf(attribName) + ", ");
        }
        if (this.tablesAttributes.isEmpty()) {
            throw new M4CompilerError("Operator 'ModelApplier': No primary key for table '" + tableName + "'found!");
        }
        String pkString = "(" + pkBuf.substring(0, pkBuf.length() - 2) + ")";
        String pkName = String.valueOf(tableName) + "_idx";
        String sql2 = "ALTER TABLE " + tableName + " ADD ( CONSTRAINT " + pkName + " PRIMARY KEY " + pkString + " )";
        try {
            db.executeBusinessSqlWrite(sql2);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException, probably because the primary key constraint of Concept '" + this.getInputConcept().getName() + "', table/view '" + inputCs.getName() + "' is not valid!\n" + e.getMessage());
        }
        db.addIndexToTrash(tableName, inputCs.getSchema(), this.getStep().getId());
    }

    protected void createPredictedAttributeInDb(int loop) throws M4CompilerError {
        BaseAttribute predBa = this.getPredictedAttribute(loop);
        String predColName = predBa.getName();
        String dataType = this.getDatabaseDtForNewColumn(predBa);
        String tableName = this.getTargetTableName();
        String sql = "ALTER TABLE " + tableName + " ADD ( " + predColName + " " + dataType + " )";
        try {
            this.getM4Db().executeBusinessSqlWrite(sql);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException when trying to add attribute '" + predColName + "' for predicted values to table '" + tableName + "'!\n" + e.getMessage());
        }
        this.tablesAttributes.add(predColName);
    }

    protected String getSelectStatementOfKeys() throws M4CompilerError {
        Vector keys = this.getKeyColumns();
        return this.getSelectFromColumnCollection(keys);
    }

    protected String getSelectStatementOfPredAttribs() {
        Vector predAttribs = this.getPredictionColumns();
        return this.getSelectFromColumnCollection(predAttribs);
    }

    private String getSelectFromColumnCollection(Collection columns) {
        Iterator it = columns.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            String sql = column.getSQLDefinition();
            if (!sql.equals(column.getName())) {
                sql = String.valueOf(sql) + " AS " + column.getName();
            }
            buf.append(String.valueOf(sql) + ", ");
        }
        return buf.substring(0, buf.length() - 2);
    }

    private void initKeyColumns() throws M4Exception, M4CompilerError {
        Feature outKeyF = this.getTheKey();
        Collection columns = this.findInputColumnForFeature(outKeyF);
        if (columns.isEmpty()) {
            throw new M4CompilerError("Operator 'ModelApplier': Empty set of keys in initKeyColumns() !");
        }
        this.keyColumns.clear();
        this.keyColumns.addAll(columns);
    }

    private void initPredictionColumns() throws M4Exception, M4CompilerError {
        Feature[] predFeatures = this.getThePredictingAttributes();
        if (predFeatures == null || predFeatures.length == 0) {
            throw new M4CompilerError("Operator 'ModelApplier': Empty set of PredictingAttributes!");
        }
        this.predictionColumns.clear();
        int i = 0;
        while (i < predFeatures.length) {
            Collection col = this.findInputColumnForFeature(predFeatures[i]);
            this.predictionColumns.addAll(col);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection findInputColumnForFeature(Feature feature) throws M4Exception, M4CompilerError {
        Vector<Column> result = new Vector<Column>();
        Concept inputCon = this.getInputConcept();
        if (feature instanceof BaseAttribute) {
            BaseAttribute inKeyF = ModelApplier.findCorrespondingBaInConcept((BaseAttribute)feature, inputCon);
            if (inKeyF == null) throw new M4CompilerError("Operator 'ModelApplier': BaseAttribute '" + feature.getName() + "' not found in InputConcept!");
            Column keyC = inKeyF.getCurrentColumn();
            result.add(keyC);
            return result;
        } else {
            Iterator it = ((MultiColumnFeature)feature).getBaseAttributes().iterator();
            while (it.hasNext()) {
                BaseAttribute inKeyF = ModelApplier.findCorrespondingBaInConcept((BaseAttribute)it.next(), inputCon);
                if (inKeyF == null) throw new M4CompilerError("Operator 'ModelApplier': MultiColumnFeature '" + feature.getName() + "' has a BaseAttribute not found in the InputConcept!");
                Column keyC = inKeyF.getCurrentColumn();
                result.add(keyC);
            }
        }
        return result;
    }

    protected static String stringCollectionToCommaSeparatedString(Collection columnNames) {
        Iterator it = columnNames.iterator();
        StringBuffer sBuf = new StringBuffer();
        while (it.hasNext()) {
            sBuf.append(String.valueOf((String)it.next()) + ", ");
        }
        return sBuf.substring(0, sBuf.length() - 2);
    }

    public static BaseAttribute findCorrespondingBaInConcept(BaseAttribute ba, Concept concept) throws M4Exception {
        Iterator it = concept.getFeatures().iterator();
        BaseAttribute result = null;
        while (it.hasNext() && result == null) {
            Feature f = (Feature)it.next();
            if (f instanceof MultiColumnFeature) {
                result = ((MultiColumnFeature)f).getBaseAttributeByName(ba.getName());
                continue;
            }
            if (!ba.correspondsTo(f)) continue;
            result = (BaseAttribute)f;
        }
        return result;
    }

    protected String getTargetTableName() {
        return "TMP_" + this.getStep().getId() + this.getInputConcept().getCurrentSuffix();
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        Columnset cs = super.createSingleColumnSet(index);
        HashSet<String> keys = new HashSet<String>();
        Iterator it = ((AbstractList)this.getKeyColumns()).iterator();
        while (it.hasNext()) {
            keys.add(((Column)it.next()).getName());
        }
        CompilerDatabaseService db = this.getM4Db();
        it = ((AbstractList)this.tablesAttributes).iterator();
        try {
            while (it.hasNext()) {
                String attribName = (String)it.next();
                if (keys.contains(attribName)) continue;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.udo.miningmart.m4.core.Column");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Column newCol = (Column)db.createNewInstance(clazz);
                newCol.setName(attribName);
                newCol.setColumnset(cs);
                Iterator feaIt = this.getOutputConcept().getFeatures().iterator();
                BaseAttribute correspondingBa = null;
                while (feaIt.hasNext() && correspondingBa == null) {
                    BaseAttribute ba;
                    Feature f = (Feature)feaIt.next();
                    if (f instanceof BaseAttribute) {
                        ba = (BaseAttribute)f;
                        if (!attribName.equals(ba.getName())) continue;
                        correspondingBa = ba;
                        continue;
                    }
                    ba = ((MultiColumnFeature)f).getBaseAttributeByName(attribName);
                    if (ba == null) continue;
                    correspondingBa = ba;
                }
                if (correspondingBa == null) {
                    throw new M4CompilerError("Operator 'ModelApplier' created attribute '" + attribName + "' without a corresponding BaseAttribute!");
                }
                newCol.setBaseAttribute(correspondingBa);
                newCol.setColumnDataTypeName(this.getRelationalDtForNewColumn(correspondingBa));
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
        return cs;
    }

    protected String getDatabaseQueryForRows(Long fromRowNum, Long toRowNum) throws M4Exception, M4CompilerError {
        return String.valueOf(this.buildDatabaseQuery()) + this.getTupleRestriction(fromRowNum, toRowNum);
    }

    private String buildDatabaseQuery() throws M4Exception, M4CompilerError {
        Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
        String keys = this.getSelectStatementOfKeys();
        String pred = this.getSelectStatementOfPredAttribs();
        String selectPart = "SELECT " + keys + ", " + pred;
        String fromPart = " FROM " + inputCs.getSQLDefinition();
        return String.valueOf(selectPart) + fromPart;
    }

    private String getTupleRestriction(Long fromRowNum, Long toRowNum) {
        if (fromRowNum == null && toRowNum == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" WHERE ");
        if (fromRowNum != null) {
            buf.append("ROWNUM > " + (fromRowNum - 1L));
        }
        if (toRowNum != null) {
            buf.append(String.valueOf(fromRowNum != null ? " AND" : "") + " ROWNUM < " + toRowNum + 1);
        }
        return buf.toString();
    }

    public Concept getInputConcept() {
        return super.getInputConcept();
    }

    public Concept getOutputConcept() {
        return super.getOutputConcept();
    }

    public Feature[] getThePredictingAttributes() {
        return (Feature[])this.getParameter("PredictingAttributes");
    }

    public BaseAttribute getPredictedAttribute(int loop) {
        return (BaseAttribute)this.getSingleParameter("PredictedAttribute", loop);
    }

    public Feature getTheKey() throws M4CompilerError {
        Feature f = (Feature)this.getSingleParameter("PrimaryKey");
        if (f == null || f.isDeselected()) {
            throw new M4CompilerError("Operator 'ModelApplier': Parameter 'PrimaryKey' not properly set!");
        }
        return f;
    }

    protected abstract String getRelationalDtForNewColumn(BaseAttribute var1);

    protected abstract String getDatabaseDtForNewColumn(BaseAttribute var1);

    protected abstract void predict() throws M4Exception, M4CompilerError;
}

