/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.SingleCSOperator;

public class Materialize
extends SingleCSOperator {
    /*
     * WARNING - void declaration
     */
    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        Concept concept = this.getInputConcept();
        try {
            void var3_3;
            Columnset cs;
            if (concept == null || (cs = concept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'Materialize': Found no input Concept/Columnset!");
            }
            String tableName = this.getNewCSName();
            this.getM4Db().dropBusinessTable(tableName);
            String sql = "CREATE TABLE " + tableName + " AS " + var3_3.getCompleteSQLQuery();
            this.executeBusinessSqlWrite(sql);
            this.getM4Db().addTableToTrash(tableName, var3_3.getSchema(), this.getStep().getId());
            return tableName;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'Materialize': M4Exception caught during createStatement:\n" + e.getMessage());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'Materialize': SQLException caught during createStatement:\n" + e.getMessage());
        }
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    public String getNewCSName(int index) {
        String tableName = this.getTableName();
        if (tableName == null) {
            return super.getNewCSName(index);
        }
        return String.valueOf(tableName) + this.getInputConcept().getCurrentSuffix();
    }

    public String getTableName() {
        String s;
        Value value = (Value)this.getSingleParameter("TableName");
        if (value != null && (s = value.getValue()) != null && s.trim().length() > 0) {
            return s.trim();
        }
        return null;
    }
}

