/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.SingleCSOperator;

public class CreatePrimaryKey
extends SingleCSOperator {
    static /* synthetic */ Class class$0;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String selectPart = super.generateColumns(csForOutputConcept);
        String columnName = this.getNewKeysColumnName();
        String sqlDef = this.getNewKeysSqlDefinition();
        try {
            CompilerDatabaseService compilerDatabaseService = this.getM4Db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Column newKey = (Column)compilerDatabaseService.createNewInstance(clazz);
            newKey.setName(columnName);
            newKey.setColumnDataTypeName("KEY");
            newKey.setColumnset(csForOutputConcept);
            newKey.setSQLDefinition(sqlDef);
            this.getPrimaryKey().addColumn(newKey);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("CreatePrimaryKey.generateColumns: M4Exception when trying to create the PrimaryKey column!\n" + e.getMessage());
        }
        return selectPart;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        if (this.getM4Dbms() != 1) {
            throw new M4CompilerError("Sorry, operator 'CreatePrimaryKey' has not yet been implemented for any other DBMS than Oracle!");
        }
        Concept concept = this.getInputConcept();
        try {
            Columnset cs;
            if (concept == null || (cs = concept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'CreatePrimaryKey': Found no input Concept/Columnset!");
            }
            String tableName = this.getNewCSName();
            this.getM4Db().dropBusinessTable(tableName);
            String sql = "(SELECT " + (this.getAllowDuplicates() ? "" : "DISTINCT ") + selectPart + " FROM " + cs.getSQLDefinition() + ")";
            return sql;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'CreatePrimaryKey': M4Exception caught during createStatement:\n" + e.getMessage());
        }
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    private String getNewKeysColumnName() {
        return this.getPrimaryKey().getName();
    }

    private String getNewKeysSqlDefinition() throws M4CompilerError {
        if (this.getM4Dbms() != 1) {
            throw new M4CompilerError("Sorry, operator 'CreatePrimaryKey' has not yet been implemented for any other DBMS than Oracle!");
        }
        return "ROWNUM";
    }

    public boolean getAllowDuplicates() {
        String s;
        Value value = (Value)this.getSingleParameter("AllowDuplicates");
        return value != null && (s = value.getValue()) != null && s.equalsIgnoreCase("true");
    }

    public BaseAttribute getPrimaryKey() {
        return (BaseAttribute)this.getSingleParameter("PrimaryKey");
    }
}

