/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.ColumnStatistics2;
import edu.udo.miningmart.m4.core.Columnset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.operator.MissingValues;

public class AssignStochasticValue
extends MissingValues {
    public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError {
        if (this.getM4Dbms() != 1) {
            throw new M4CompilerError("Sorry, 'AssignStochasticValue' currently only available for ORACLE!");
        }
        try {
            Columnset cs = columnWithMissingValues.getColumnset();
            BaseAttribute ba = columnWithMissingValues.getTheBaseAttribute();
            if (cs == null || ba == null) {
                throw new M4CompilerError("'AssignStochasticGValue': TargetAttribute not properly connected!");
            }
            Collection theValues = columnWithMissingValues.getDistributionStatistics();
            if (theValues == null || theValues.size() == 0) {
                columnWithMissingValues.updateStatistics(ba.getConceptualDataType());
                theValues = columnWithMissingValues.getDistributionStatistics();
            }
            if (theValues == null || theValues.size() == 0) {
                throw new M4CompilerError("Operator AssignStochasticValue: TheTargetAttribute (" + this.getTheTargetAttribute().getName() + ") has no values!");
            }
            long noOfRows = Long.parseLong(cs.readOrComputeCount());
            String missingValueFunction = "CREATE OR REPLACE FUNCTION " + this.getFunctionName() + " (cROWNUM IN NUMBER) " + " RETURN " + columnWithMissingValues.getColumnDataTypeName() + " AS \n" + "  returnVal " + columnWithMissingValues.getColumnDataTypeName() + ";\n" + "  r NUMBER(38,10);\n" + "begin\n" + " --- Generate a Random Number between 1 and nr of rows\n" + "  r := m4randomnr(" + 0 + ", cROWNUM, " + noOfRows + ");\n";
            long covered = 0L;
            Iterator it = theValues.iterator();
            ColumnStatistics2 stat2 = null;
            while (it.hasNext()) {
                stat2 = (ColumnStatistics2)it.next();
                if (!it.hasNext()) continue;
                missingValueFunction = String.valueOf(missingValueFunction) + "IF r < " + (covered += (long)stat2.getDistributionCount()) + " THEN returnVal := " + stat2.getDistributionValue() + ";\n" + " ELS";
            }
            covered += (long)stat2.getDistributionCount();
            missingValueFunction = String.valueOf(missingValueFunction) + "E returnVal := " + stat2.getDistributionValue() + ";\n" + "END IF; " + " return(returnVal);\n" + "end;\n";
            this.doPrint(12, "Installing Stochastic Missing Value Function:");
            try {
                this.getM4Db().executeBusinessSqlWrite(missingValueFunction);
                this.getM4Db().addFunctionToTrash(this.getFunctionName(), cs.getSchema(), this.getStep().getId());
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("AssignStochasticValue: could not create the following sql function: " + missingValueFunction + "; got SQL error: " + sqle.getMessage());
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
        return String.valueOf(this.getFunctionName()) + "(ROWNUM)";
    }

    private String getFunctionName() {
        return "mv_" + this.getTheOutputAttribute().getId() + "_" + this.getCurrentLoopNumber();
    }
}

