/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.hciImpl.ColumnsetImpl;
import edu.udo.miningmart.m4.hciImpl.ConceptImpl;
import edu.udo.miningmart.m4.hciImpl.ForeignKeyImpl;
import edu.udo.miningmart.m4.hciImpl.ParameterImpl;
import edu.udo.miningmart.m4.hciImpl.PrimaryKeyImpl;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.NameExistsException;
import miningmart.m4.Parameter;
import miningmart.m4.Relationship;
import miningmart.m4.Step;
import miningmart.m4.StorageException;

public class RelationshipImpl
extends Relation
implements Relationship {
    public RelationshipImpl(DB m4Db) {
        super(m4Db);
    }

    public String getSubRelationshipRestriction() {
        return null;
    }

    public void setSubRelationshipRestriction(String subRelationshipRestriction) throws StorageException {
    }

    public boolean isFunctionallyValid() {
        return false;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
    }

    public boolean isRelationallyValid() {
        if (this.getTheFromConcept() == null || this.getTheToConcept() == null) {
            return false;
        }
        if (!this.getTheFromConcept().getType().equals("DB") || !this.getTheToConcept().getType().equals("DB")) {
            return false;
        }
        return this.getFromKey() != null;
    }

    public void setPoint(Point point, Concept context, String endPoint) {
        String name = String.valueOf(this.getName()) + "_" + endPoint;
        try {
            super.setPointForContextUsingName((ConceptImpl)context, name, point);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Point getPoint(Concept context, String endPoint) {
        String name = String.valueOf(this.getName()) + "_" + endPoint;
        try {
            return super.getPointForContextAndName((ConceptImpl)context, name);
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Point getPoint(Map points, Concept context, String endPoint) {
        String name = String.valueOf(this.getName()) + "_" + endPoint;
        try {
            return super.getPointForContextAndNameFromMap(points, (ConceptImpl)context, name);
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void removePoint(Concept context, String endPoint) {
        String name = String.valueOf(this.getName()) + "_" + endPoint;
        try {
            super.removePointsForContextAndName((ConceptImpl)context, name);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void removeAllPoints() {
        try {
            super.removeAllPoints();
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Relationship getSuperRelationship() {
        return null;
    }

    public void setSuperRelationship(Relationship superRelationship) throws StorageException {
    }

    public void removeSuperRelationship() throws StorageException {
    }

    public void addSubRelationship(Relationship relationship) throws StorageException {
    }

    public Relationship getSubRelationship(String name) {
        return null;
    }

    public Collection getAllSubRelationships() {
        return new Vector();
    }

    public void removeSubRelationship(String name) throws StorageException {
    }

    public void removeAllSubRelationships() throws StorageException {
    }

    public ColumnSet createColumnSet(String name, String schema, String type) throws CreateException, NameExistsException {
        if (name == null || schema == null || type == null) {
            throw new CreateException("ConceptImpl.createColumnSet: got <null> as a parameter!");
        }
        ColumnsetImpl newCS = new ColumnsetImpl(this.getM4Db());
        try {
            newCS.setColumnSetType(type);
            newCS.setName(name);
            newCS.setSchema(schema);
            this.setColumnSet(newCS);
        }
        catch (StorageException se) {
            throw new CreateException("Could not create/connect new Columnset '" + name + " to Concept " + this.getId() + ": " + se.getMessage());
        }
        return newCS;
    }

    public ColumnSet getColumnSet() {
        return (ColumnsetImpl)super.getCrossLinkColumnSet();
    }

    public void setColumnSet(ColumnSet columnSet) throws StorageException {
        try {
            super.setCrossLinkColumnSet((ColumnsetImpl)columnSet);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public void removeColumnSet() throws StorageException {
        this.setColumnSet(null);
    }

    public void setForeignKey(ForeignKey key) throws StorageException {
        ColumnsetImpl toCS = (ColumnsetImpl)key.getIsConnectionTo();
        if (toCS == null) {
            throw new StorageException("No connected CS found for ForeignKey " + ((ForeignKeyImpl)key).getId() + " when trying to connect it to Relationship " + this.getId() + "!");
        }
        PrimaryKeyImpl toPK = (PrimaryKeyImpl)toCS.getPrimaryKey();
        if (toPK == null) {
            throw new StorageException("No Primary Key found in Columnset " + toCS.getId() + " when trying to connect it to Relationship " + this.getId() + "!");
        }
        try {
            super.setFromKey((ForeignKeyImpl)key);
            super.setToKey(toPK);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public void removeForeignKey() throws StorageException {
        try {
            super.setFromKey(null);
            super.setToKey(null);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public ForeignKey getForeignKey() {
        return (ForeignKeyImpl)super.getFromKey();
    }

    public void setM2mKeys(ForeignKey fromFK, ForeignKey toFK) throws StorageException {
        if (fromFK == null || toFK == null) {
            return;
        }
        try {
            super.setFromKey((ForeignKeyImpl)fromFK);
            super.setToKey((ForeignKeyImpl)toFK);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public void setToConcept(Concept toConcept) throws StorageException {
        try {
            super.setTheToConcept((ConceptImpl)toConcept);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public void setFromConcept(Concept fromConcept) throws StorageException {
        try {
            super.setTheFromConcept((ConceptImpl)fromConcept);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public Concept getToConcept() {
        return (ConceptImpl)super.getTheToConcept();
    }

    public Concept getFromConcept() {
        return (ConceptImpl)super.getTheFromConcept();
    }

    public void addParameter(Parameter parameter) throws StorageException {
        try {
            super.addParameterReference((ParameterImpl)parameter);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public Parameter getParameter(String stepName, String parameterName) {
        Collection col;
        try {
            col = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        if (col == null || stepName == null || parameterName == null) {
            return null;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Parameter par = (Parameter)it.next();
            if (par == null) continue;
            String parName = par.getParameterName();
            Step step = par.getStep();
            if (step == null || !stepName.equals(step.getName()) || !parameterName.equals(parName)) continue;
            return par;
        }
        return null;
    }

    public Collection getAllParameters() {
        try {
            return super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void removeParameter(String stepName, String parameterName) throws StorageException {
        Parameter par = this.getParameter(stepName, parameterName);
        this.removeParameter((ParameterImpl)par);
    }

    public void removeAllParameters() throws StorageException {
        Collection col = this.getAllParameters();
        if (col == null) {
            return;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            ParameterImpl par = (ParameterImpl)it.next();
            this.removeParameter(par);
        }
    }

    private void removeParameter(ParameterImpl par) throws StorageException {
        try {
            super.removeParameterReference(par);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public Relationship copy(Concept fromConcept, Concept toConcept) throws CreateException, NameExistsException {
        RelationshipImpl theCopy = (RelationshipImpl)fromConcept.createFromConceptRelationship(this.getName(), toConcept);
        try {
            theCopy.setColumnSet(this.getColumnSet());
            theCopy.setForeignKey(this.getForeignKey());
            theCopy.setFromKey(this.getFromKey());
            theCopy.setSubRelationshipRestriction(this.getSubRelationshipRestriction());
            theCopy.setSuperRelationship(this.getSuperRelationship());
            theCopy.setToKey(this.getToKey());
        }
        catch (StorageException se) {
            throw new CreateException("Could not create copy of Relationship " + this.getId() + ": " + se.getMessage());
        }
        catch (M4Exception m4e) {
            throw new CreateException("Could not create copy of Relationship " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

