/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.hciImpl.OperatorImpl;
import edu.udo.miningmart.m4.hciImpl.StepImpl;
import miningmart.m4.CreateException;
import miningmart.m4.M4Object;
import miningmart.m4.NameExistsException;
import miningmart.m4.Operator;
import miningmart.m4.Step;
import miningmart.m4.StorageException;
import miningmart.m4.Value;

public class ParameterImpl
extends Parameter
implements miningmart.m4.Parameter {
    public ParameterImpl(DB db) {
        super(db);
    }

    public String getParameterName() {
        return super.getName();
    }

    public void setParameterName(String parameterName) throws NameExistsException {
        super.setName(parameterName);
    }

    public String getParameterType() {
        return super.isInputParam() ? "IN" : "OUT";
    }

    public void setParameterType(String parameterType) {
        if (parameterType.equals("IN")) {
            super.setIsInputParam(true);
        } else if (parameterType.equals("OUT")) {
            super.setIsInputParam(false);
        } else {
            super.doPrint(20, "ParameterImpl.setParameterType: Expected IN or OUT, but got " + parameterType + "!");
        }
    }

    public int getParameterNr() {
        return (int)super.getParamNr();
    }

    public void setParameterNr(int parameterNr) {
        super.setParamNr(parameterNr);
    }

    public Step getStep() {
        try {
            return (Step)((Object)super.getTheStep());
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void setStep(Step step) throws StorageException {
        try {
            super.setTheStep((StepImpl)step);
            if (step == null) {
                super.deleteSoon();
            }
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public Operator getOperator() {
        try {
            return (Operator)((Object)super.getTheOperator());
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void setOperator(Operator operator) throws StorageException {
        super.setTheOperator((OperatorImpl)operator);
    }

    public M4Object getParameterObject() {
        try {
            return (M4Object)((Object)super.getTheParameterObject());
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void setParameterObject(M4Object parameterObject) throws StorageException {
        ParameterObject parObj = (ParameterObject)((Object)parameterObject);
        try {
            super.setTheParameterObject(parObj);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeParameterObject() {
        try {
            this.setParameterObject(null);
        }
        catch (StorageException e) {
            super.doPrint(e);
        }
    }

    public miningmart.m4.Parameter copy(Step newStep) throws CreateException, NameExistsException, StorageException {
        ParameterImpl theCopy = new ParameterImpl(this.getM4Db());
        theCopy.setStep(newStep);
        theCopy.setParameterName(this.getParameterName());
        theCopy.setParameterNr(this.getParameterNr());
        theCopy.setParameterObject(this.getParameterObject());
        theCopy.setParameterType(this.getParameterType());
        theCopy.setDocumentation(this.getDocumentation());
        if (newStep != null) {
            theCopy.setOperator(newStep.getOperator());
        } else {
            theCopy.setOperator(null);
        }
        return theCopy;
    }

    public Value getValue() {
        M4Object parObj = this.getParameterObject();
        if (parObj == null) {
            return null;
        }
        if (!(parObj instanceof Value)) {
            super.doPrint(20, "Warning: ParameterImpl.getValue() called on non-value class " + parObj.getClass().getName() + "!");
            return null;
        }
        return (Value)parObj;
    }

    public void removeValue() throws StorageException {
        this.removeParameterObject();
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

