/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.hciImpl.BaseAttributeImpl;
import edu.udo.miningmart.m4.hciImpl.ConceptImpl;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.MultipleResultException;
import miningmart.m4.NameExistsException;
import miningmart.m4.Step;
import miningmart.m4.StorageException;

public class MultiColumnFeatureImpl
extends MultiColumnFeature
implements miningmart.m4.MultiColumnFeature {
    public MultiColumnFeatureImpl(DB db) {
        super(db);
    }

    public Concept getConcept() {
        return (Concept)((Object)super.getTheConcept());
    }

    public void setConcept(Concept concept) throws StorageException {
        try {
            super.setTheConcept((ConceptImpl)concept);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void addBaseAttribute(BaseAttribute baseAttribute) throws StorageException {
        try {
            super.addBaseAttribute((BaseAttributeImpl)baseAttribute);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public BaseAttribute getBaseAttribute(String name) {
        try {
            Iterator it = super.getBaseAttributes().iterator();
            while (it.hasNext()) {
                BaseAttribute cur = (BaseAttribute)it.next();
                if (cur == null || !cur.equals(name)) continue;
                return cur;
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public Collection getAllBaseAttributes() {
        try {
            return super.getBaseAttributes();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void removeBaseAttribute(String name) throws StorageException {
        BaseAttribute ba = this.getBaseAttribute(name);
        try {
            super.removeBaseAttribute((BaseAttributeImpl)ba);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeAllBaseAttributes() throws StorageException {
        try {
            super.setBaseAttributes(null);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public miningmart.m4.MultiColumnFeature copy(Concept newConcept) throws NameExistsException {
        MultiColumnFeatureImpl theCopy = new MultiColumnFeatureImpl(this.getM4Db());
        try {
            theCopy.setTheConcept((ConceptImpl)newConcept);
            theCopy.setBaseAttributes(this.getBaseAttributes());
            theCopy.setFunctionallyValid(this.isFunctionallyValid());
            theCopy.setName(this.getName());
        }
        catch (M4Exception m4e) {
            throw new NameExistsException("Could not create copy of Column " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public boolean isRelationallyValid() {
        if (this.getTheConcept() == null) {
            return false;
        }
        Collection bas = this.getAllBaseAttributes();
        if (bas == null || bas.size() < 2) {
            return false;
        }
        Iterator it = bas.iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            if (ba.isRelationallyValid()) continue;
            return false;
        }
        return true;
    }

    public void addParameter(miningmart.m4.Parameter parameter) throws StorageException {
        try {
            super.addParameterReference((Parameter)((Object)parameter));
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
    }

    public boolean isFunctionallyValid() {
        return false;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
    }

    public miningmart.m4.Parameter getParameter(String stepName, String parameterName) {
        Collection collection = null;
        try {
            collection = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                String parStepName;
                miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
                if (par == null) continue;
                String parName = par.getParameterName();
                Step parStep = par.getStep();
                String string = parStepName = par == null ? null : parStep.getName();
                if (parStepName == null || !parName.equals(parameterName) || !parStepName.equals(stepName)) continue;
                return par;
            }
        }
        return null;
    }

    public Collection getAllParameters() {
        try {
            return super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public Collection getAllInputParameters() {
        Collection c;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        Iterator it = c.iterator();
        Vector<miningmart.m4.Parameter> ret = new Vector<miningmart.m4.Parameter>();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            if (!par.getParameterType().equals("IN")) continue;
            ret.add(par);
        }
        return ret;
    }

    public miningmart.m4.Parameter getOutputParameter() throws MultipleResultException {
        Collection c;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        Iterator it = c.iterator();
        Vector<miningmart.m4.Parameter> ret = new Vector<miningmart.m4.Parameter>();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            if (!par.getParameterType().equals("OUT")) continue;
            ret.add(par);
        }
        if (ret.size() == 0) {
            return null;
        }
        if (ret.size() > 1) {
            throw new MultipleResultException();
        }
        return (miningmart.m4.Parameter)ret.firstElement();
    }

    public void removeParameter(String stepName, String parameterName) throws StorageException {
        miningmart.m4.Parameter removeMe = this.getParameter(stepName, parameterName);
        if (removeMe != null) {
            try {
                super.removeParameterReference((Parameter)((Object)removeMe));
            }
            catch (M4Exception e) {
                throw new StorageException(e.getMessage());
            }
        }
    }

    public void removeAllParameters() throws StorageException {
        Collection c;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return;
        }
        Iterator it = ((AbstractList)new Vector(c)).iterator();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            try {
                super.removeParameterReference((Parameter)((Object)par));
            }
            catch (M4Exception e) {
                throw new StorageException(e.getMessage());
            }
        }
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

