/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.ConfigReader;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.MiningMartException;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import edu.udo.miningmart.m4.core.OperatorGroup;
import edu.udo.miningmart.m4.hciImpl.CaseImpl;
import edu.udo.miningmart.m4.hciImpl.HciDb;
import edu.udo.miningmart.m4.hciImpl.OperatorImpl;
import edu.udo.miningmart.m4.utils.Print;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import miningmart.m4.Case;
import miningmart.m4.CreateException;
import miningmart.m4.M4Interface;
import miningmart.m4.NameExistsException;
import miningmart.m4.Operator;
import miningmart.m4.StorageException;

public class M4InterfaceImpl
extends M4Interface
implements M4InterfaceContext,
Serializable {
    public static final String SYSTEM_PROP_PRINT_VERBOSITY = "PRINT_VERBOSITY";
    public static final String SYSTEM_PROP_DB_CONFIG_PATH = "DB_CONFIG_PATH";
    public static final String MM_COOLUMN_NAMES = "mmColumnNames";
    private HciDb db;
    private final Print print;
    private static final String TABLE_NAME = "M4_ACCESS_T";
    private static final String ATTR_ID = "OBJECT_ID";
    private static final String ATTR_TYPE = "OBJECT_TYPE";
    private static final String ATTR_CLIENT = "CLIENT_NAME";
    private static final String ATTR_ACCESS = "ACCESS_TYPE";
    private static final String ACCESS_STRING_WRITE = "WRITE";
    private static final String ACCESS_STRING_READ = "READ";
    private OperatorGroup opGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public M4InterfaceImpl() {
        int printVerb = 2;
        String printVerbS = System.getProperty(SYSTEM_PROP_PRINT_VERBOSITY);
        if (printVerbS != null) {
            try {
                printVerb = Integer.parseInt(printVerbS);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.print = new Print(printVerb);
        this.getNewDbConnection();
    }

    public void getNewDbConnection() {
        String dbConfigPath;
        if (this.db != null) {
            try {
                this.db.updateDatabase();
            }
            catch (M4Exception e) {
                System.err.println("Warning: Could not update Database!\n" + e.getMessage());
            }
            this.db.clearM4Cache();
            M4Interface.setCurrentCompilerAccess(null);
        }
        if ((dbConfigPath = System.getProperty(SYSTEM_PROP_DB_CONFIG_PATH)) == null || dbConfigPath.length() == 0) {
            this.getPrintObject().doPrint(20, "Fatal error: Could not read System property DB_CONFIG_PATH to set up database connections!!");
            this.db = null;
        } else {
            HciDb d = null;
            try {
                ConfigReader cr = new ConfigReader(dbConfigPath);
                String m4dbname = cr.getLine();
                String m4user = cr.getLine();
                String m4password = cr.getLine();
                String m4driver = cr.getLine();
                String m4dbLocation = cr.getLine();
                cr.getLine();
                String dataDbname = cr.getLine();
                String dataUser = cr.getLine();
                String dataPassword = cr.getLine();
                String dataDriver = cr.getLine();
                String dataDbLocation = cr.getLine();
                d = new HciDb(String.valueOf(m4driver) + m4dbLocation, m4dbname, m4user, m4password, String.valueOf(dataDriver) + dataDbLocation, dataDbname, dataUser, dataPassword, true, this);
            }
            catch (IOException e) {
                this.getPrintObject().doPrint(e);
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(e);
            }
            this.db = d;
        }
    }

    public boolean getStopRequest() {
        return false;
    }

    public edu.udo.miningmart.m4.core.Case getCase() {
        return null;
    }

    public DB getM4db() {
        return this.db;
    }

    public Print getPrintObject() {
        return this.print;
    }

    public Case createCase(String name) throws CreateException, NameExistsException {
        CaseImpl m4case = new CaseImpl(this.getM4db());
        m4case.setName(name);
        M4Interface.setCurrentCase(m4case);
        return m4case;
    }

    public Operator createOperator(String name) throws CreateException, NameExistsException {
        OperatorImpl op = new OperatorImpl(this.getM4db());
        op.setName(name);
        return op;
    }

    public Collection getAllCaseNames() {
        String query = "SELECT ca_name FROM case_t";
        Vector<String> result = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.getM4db().executeM4SqlRead(query);
                result = new Vector<String>();
                while (rs.next()) {
                    String caseName = rs.getString(1);
                    if (caseName == null) continue;
                    result.add(caseName);
                }
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(e);
            }
            catch (DbConnectionClosed e) {
                this.getPrintObject().doPrint(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeResultSet(rs);
            throw throwable;
        }
        Object var6_9 = null;
        this.closeResultSet(rs);
        return result;
    }

    private void closeResultSet(ResultSet rs) {
        Print print;
        String msg = DB.closeResultSet(rs);
        if (msg != null && (print = this.getPrintObject()) != null) {
            print.doPrint(20, msg);
        }
    }

    public Operator findOperator(String name) {
        block7: {
            if (name != null) {
                String query = "SELECT op_id FROM operator_t WHERE OP_NAME = '" + name + "'";
                try {
                    Long opId = this.getM4db().executeM4SingleValueSqlReadL(query);
                    if (opId == null) break block7;
                    DB db = this.getM4db();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Operator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> targetClass = clazz;
                    return (Operator)((Object)db.getM4Object(opId, targetClass));
                }
                catch (MiningMartException e) {
                    this.getPrintObject().doPrint(e);
                }
                catch (SQLException e) {
                    this.getPrintObject().doPrint(e);
                }
            }
        }
        return null;
    }

    public Case findCase(String name) {
        block7: {
            if (name != null) {
                String query = "SELECT ca_id FROM case_t WHERE ca_name = '" + name + "'";
                try {
                    Long caId = this.getM4db().executeM4SingleValueSqlReadL(query);
                    if (caId == null) break block7;
                    DB db = this.getM4db();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Case");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> targetClass = clazz;
                    Case m4case = (Case)((Object)db.getM4Object(caId, targetClass));
                    M4Interface.setCurrentCase(m4case);
                    return m4case;
                }
                catch (MiningMartException e) {
                    this.getPrintObject().doPrint(e);
                }
                catch (SQLException e) {
                    this.getPrintObject().doPrint(e);
                }
            }
        }
        return null;
    }

    public Collection getAllOperatorNames() {
        String query = "SELECT OP_NAME FROM operator_t";
        Vector<String> result = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.getM4db().executeM4SqlRead(query);
                result = new Vector<String>();
                while (rs.next()) {
                    String opName = rs.getString(1);
                    if (opName == null) continue;
                    result.add(opName);
                }
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(e);
            }
            catch (DbConnectionClosed e) {
                this.getPrintObject().doPrint(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeResultSet(rs);
            throw throwable;
        }
        Object var6_9 = null;
        this.closeResultSet(rs);
        return result;
    }

    public List executeSQLQC1(String sqlString, int maxRows) throws SQLException {
        Map tableData = this.executeSQLQ(sqlString, maxRows);
        List columnNames = (List)tableData.get(MM_COOLUMN_NAMES);
        String firstColumnName = columnNames.get(0).toString();
        List firstColumnData = (List)tableData.get(firstColumnName);
        return firstColumnData;
    }

    public Map executeSQLQ(String sqlString, int maxRows) throws SQLException {
        HashMap aMap = new HashMap();
        ResultSet rs = null;
        try {
            try {
                rs = this.getM4db().executeM4SqlRead(sqlString);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numColumns = rsmd.getColumnCount();
                int rowNum = 0;
                while (rs.next() && rowNum < maxRows) {
                    int i = 1;
                    while (i <= numColumns) {
                        String columnName = rsmd.getColumnName(i);
                        ArrayList<Object> aList = (ArrayList<Object>)aMap.get(columnName);
                        if (aList == null) {
                            aList = new ArrayList<Object>();
                            aMap.put(columnName, aList);
                        }
                        aList.add(rs.getObject(i));
                        ++i;
                    }
                    ++rowNum;
                }
                ArrayList<String> cList = new ArrayList<String>();
                int i = 1;
                while (i <= numColumns) {
                    String columnName = rsmd.getColumnName(i);
                    cList.add(columnName);
                    ++i;
                }
                aMap.put(MM_COOLUMN_NAMES, cList);
            }
            catch (DbConnectionClosed e) {
                throw new SQLException("DbConnection closed when calling M4InterfaceImpl.executeSQLQ(String, int)");
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var12_16 = null;
        DB.closeResultSet(rs);
        return aMap;
    }

    public void executeSQLU(String sqlString) throws SQLException {
        if (sqlString != null) {
            try {
                this.getM4db().executeM4SqlWrite(sqlString);
            }
            catch (DbConnectionClosed e) {
                throw new SQLException("DbConnection closed in M4InterfaceImpl.executeSQLU(String):\n" + e.getMessage());
            }
        }
    }

    private Collection readAccessClients(String caseName) throws SQLException {
        String query = "SELECT CLIENT_NAME FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_ACCESS + " = '" + ACCESS_STRING_READ + "'";
        return this.resultCollection(query);
    }

    private Collection writeAccessClients(String caseName) throws SQLException {
        String query = "SELECT CLIENT_NAME FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_ACCESS + " = '" + ACCESS_STRING_WRITE + "'";
        return this.resultCollection(query);
    }

    private Collection resultCollection(String query) throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet rs = null;
        try {
            try {
                String name;
                rs = this.getM4db().executeM4SqlRead(query);
                while (rs.next() && (name = rs.getString(1)) != null) {
                    result.add(name);
                }
            }
            catch (DbConnectionClosed e) {
                throw new SQLException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeResultSet(rs);
            throw throwable;
        }
        Object var6_8 = null;
        this.closeResultSet(rs);
        return result;
    }

    private void addM4AccessTuple(String caseName, String client, boolean forWriting) {
        String query = "INSERT INTO M4_ACCESS_T ( OBJECT_ID, OBJECT_TYPE, CLIENT_NAME, ACCESS_TYPE ) VALUES ( '" + caseName + "', 'CASE', '" + client + "', '" + (forWriting ? ACCESS_STRING_WRITE : ACCESS_STRING_READ) + "' )";
        try {
            this.getM4db().executeM4SqlWrite(query);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(e);
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(e);
        }
    }

    private void removeM4AccessTuple(String caseName, String client) {
        String query = "DELETE FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_CLIENT + " = '" + client + "'";
        try {
            this.getM4db().executeM4SqlWrite(query);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(e);
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(e);
        }
    }

    public boolean isCaseLockedForReading(String caseName) {
        try {
            Collection c = this.writeAccessClients(caseName);
            return c != null && c.size() > 0;
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(e);
            return true;
        }
    }

    public boolean isCaseLockedForWriting(String caseName) {
        try {
            if (this.isCaseLockedForReading(caseName)) {
                return true;
            }
            Collection c = this.readAccessClients(caseName);
            return c != null && c.size() > 0;
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(e);
            return true;
        }
    }

    public Case findCaseForReadOnlyAccess(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        if (!this.isCaseLockedForReading(name)) {
            this.addM4AccessTuple(name, this.getUserName(), false);
            return this.findCase(name);
        }
        throw new M4Interface.CaseLockedException(this);
    }

    public Case findCaseForUpdate(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        if (!this.isCaseLockedForWriting(name)) {
            this.addM4AccessTuple(name, this.getUserName(), true);
            return this.findCase(name);
        }
        throw new M4Interface.CaseLockedException(this);
    }

    public void releaseCase(String name) {
        try {
            this.removeM4AccessTuple(name, this.getUserName());
            Case m4case = this.findCase(name);
            if (m4case == null) {
                m4case = M4Interface.getCurrentCase();
            }
            if (m4case != null) {
                m4case.store();
            }
            this.getM4db().clearM4Cache();
        }
        catch (StorageException e) {
            this.getPrintObject().doPrint(e);
        }
    }

    private String getUserName() {
        return System.getProperty("user.name");
    }

    public OperatorGroup getOperatorGroup() {
        if (this.opGroup != null) {
            return this.opGroup;
        }
        DB db = this.getM4db();
        if (db != null) {
            try {
                this.opGroup = new OperatorGroup(db);
            }
            catch (Exception e) {
                if (M4Interface.getCurrentCase() != null) {
                    ((CaseImpl)M4Interface.getCurrentCase()).doPrint(e);
                }
                System.err.println("M4InterfaceImpl.getOperatorGroup():\n");
                e.printStackTrace();
            }
        }
        return this.opGroup;
    }
}

