/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.KeyMember;
import edu.udo.miningmart.m4.hciImpl.ColumnImpl;
import edu.udo.miningmart.m4.hciImpl.ColumnsetImpl;
import edu.udo.miningmart.m4.hciImpl.KeyImpl;
import edu.udo.miningmart.m4.hciImpl.RelationshipImpl;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.NameExistsException;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;

public class ForeignKeyImpl
extends KeyImpl
implements ForeignKey {
    static /* synthetic */ Class class$0;

    public ForeignKeyImpl(DB m4Db) {
        super(m4Db);
    }

    protected Column getColumn(KeyMember km) {
        return (ColumnImpl)km.getForeignKeyColumn();
    }

    public ColumnSet getColumnSet() {
        return (ColumnsetImpl)super.getForeignKeyColumnSet();
    }

    public void setColumnSet(ColumnSet columnSet) throws StorageException {
        ColumnsetImpl oldCS = (ColumnsetImpl)super.getForeignKeyColumnSet();
        if (oldCS != null) {
            oldCS.removeForeignKey(this.getName());
        }
        ColumnsetImpl newCS = (ColumnsetImpl)columnSet;
        try {
            if (newCS != null) {
                newCS.addForeignKey(this);
            }
            super.setForeignKeyColumnSet((ColumnsetImpl)columnSet);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeColumn(String name) {
        try {
            super.removeMemberByForeignColumnName(name);
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
        }
    }

    public Relationship getRelationship() {
        return (RelationshipImpl)super.getRelation();
    }

    public void setRelationship(Relationship relationship) throws StorageException {
        boolean thisIsAFromKey = true;
        try {
            super.setRelation((RelationshipImpl)relationship, thisIsAFromKey);
        }
        catch (M4Exception m4e) {
            throw new StorageException(m4e.getMessage());
        }
    }

    public void addColumn(Column fkColumn, Column pkColumn) throws StorageException {
        try {
            DB dB = this.getM4Db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.KeyMember");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            KeyMember km = (KeyMember)dB.createNewInstance(clazz);
            km.setForeignKeyColumn(null);
            km.setPrimaryKeyColumn((ColumnImpl)pkColumn);
            km.setForeignKeyColumn((ColumnImpl)fkColumn);
            this.addMember(km);
        }
        catch (M4Exception m4e) {
            throw new StorageException("ForeignKeyImpl.addColumn: Error adding Columns " + ((ColumnImpl)fkColumn).getId() + " (foreign key column) and " + ((ColumnImpl)pkColumn).getId() + " (primary key column) to Foreign Key " + this.getId() + ": " + m4e.getMessage());
        }
    }

    public ColumnSet getIsConnectionTo() {
        return (ColumnsetImpl)super.getPrimaryKeyColumnSet();
    }

    public void setIsConnectionTo(ColumnSet columnSet) throws StorageException {
        try {
            super.setPrimaryKeyColumnSet((ColumnsetImpl)columnSet);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeIsConnectionTo() throws StorageException {
        try {
            super.setPrimaryKeyColumnSet(null);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public ForeignKey copy(ColumnSet newColumnSet) throws CreateException, NameExistsException {
        ForeignKeyImpl theCopy = new ForeignKeyImpl(this.getM4Db());
        try {
            theCopy.setColumnSet(newColumnSet);
            theCopy.setName(this.getName());
            theCopy.setMembers(this.getMembers());
            theCopy.setIsConnectionTo(this.getIsConnectionTo());
            theCopy.setRelationship(this.getRelationship());
        }
        catch (StorageException se) {
            throw new CreateException("Could not copy ForeignKey " + this.getId() + " to Columnset '" + newColumnSet.getName() + "': " + se.getMessage());
        }
        catch (M4Exception m4e) {
            throw new CreateException("Could not copy ForeignKey " + this.getId() + " to Columnset '" + newColumnSet.getName() + "': " + m4e.getMessage());
        }
        return theCopy;
    }
}

