/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.ColumnStatistics2;
import edu.udo.miningmart.m4.hciImpl.BaseAttributeImpl;
import edu.udo.miningmart.m4.hciImpl.ColumnBasicStatisticsImpl;
import edu.udo.miningmart.m4.hciImpl.ColumnDistributionStatisticsImpl;
import edu.udo.miningmart.m4.hciImpl.ColumnsetImpl;
import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Column;
import miningmart.m4.ColumnBasicStatistics;
import miningmart.m4.ColumnDistributionStatistics;
import miningmart.m4.ColumnSet;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;

public class ColumnImpl
extends edu.udo.miningmart.m4.core.Column
implements Column {
    public ColumnImpl(DB db) {
        super(db);
    }

    public String getColumnDatatype() {
        try {
            return super.getColumnDataTypeName();
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        catch (DbConnectionClosed e) {
            super.doPrint(e);
        }
        return null;
    }

    public void setColumnDatatype(String columnDatatype) {
        try {
            super.setColumnDataTypeName(columnDatatype);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        catch (DbConnectionClosed e) {
            super.doPrint(e);
        }
    }

    public String getSqlString() {
        return super.getSQLDefinition();
    }

    public void setSqlString(String sqlString) {
        super.setSQLDefinition(sqlString);
    }

    public ColumnSet getColumnSet() {
        return (ColumnsetImpl)super.getColumnset();
    }

    public void setColumnSet(ColumnSet columnSet) throws StorageException {
        try {
            super.setColumnset((ColumnsetImpl)columnSet);
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public ColumnBasicStatistics createColumnBasicStatistics() throws CreateException {
        ColumnBasicStatisticsImpl theCBS = new ColumnBasicStatisticsImpl(this.getM4Db());
        try {
            theCBS.setColumn(this);
        }
        catch (StorageException se) {
            throw new CreateException("Could not create Basic Statistics object for Column " + this.getId() + ": " + se.getMessage());
        }
        try {
            String s = super.getAverageValue();
            if (s != null) {
                theCBS.setAverage(Long.parseLong(s));
            }
            if ((s = super.getStandardDeviation()) != null) {
                theCBS.setStandardDeviation(Long.parseLong(s));
            }
            if ((s = super.getVariance()) != null) {
                theCBS.setVariance(Long.parseLong(s));
            }
            theCBS.setMaximum(super.getMaxValue());
            theCBS.setMedian(super.getMedianValue());
            theCBS.setMinimum(super.getMinValue());
            theCBS.setModal(super.getModalValue());
            theCBS.setNrOfMissingValues(super.getNumberOfMissingValues());
            theCBS.setNrOfUniqueValues(super.getNumberOfUniqueValues());
        }
        catch (M4Exception e) {
            throw new CreateException(e.getMessage());
        }
        return theCBS;
    }

    public ColumnBasicStatistics getColumnBasicStatistics() {
        ColumnBasicStatistics theCBS = null;
        try {
            theCBS = this.createColumnBasicStatistics();
        }
        catch (CreateException ce) {
            super.doPrint(ce);
        }
        return theCBS;
    }

    public void setColumnBasicStatistics(ColumnBasicStatistics ColumnBasicStatistics2) throws StorageException {
        try {
            super.setAverageValue("" + ColumnBasicStatistics2.getAverage());
            super.setStandardDeviation("" + ColumnBasicStatistics2.getStandardDeviation());
            super.setVariance("" + ColumnBasicStatistics2.getVariance());
            super.setMaxValue(ColumnBasicStatistics2.getMaximum());
            super.setMedianValue(ColumnBasicStatistics2.getMedian());
            super.setMinValue(ColumnBasicStatistics2.getMinimum());
            super.setModalValue(ColumnBasicStatistics2.getModal());
            super.setNumberOfMissingValues(ColumnBasicStatistics2.getNrOfMissingValues());
            super.setNumberOfUniqueValues(ColumnBasicStatistics2.getNrOfUniqueValues());
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void removeColumnBasicStatistics() throws StorageException {
    }

    public ColumnDistributionStatistics createColumnDistributionStatistics(String distributionValue) throws CreateException {
        Collection theCounts;
        try {
            theCounts = super.getDistributionStatistics();
        }
        catch (M4Exception e) {
            throw new CreateException(e.getMessage());
        }
        ColumnDistributionStatisticsImpl theCDS = null;
        Iterator it = theCounts.iterator();
        while (it.hasNext()) {
            ColumnStatistics2 cstat = (ColumnStatistics2)it.next();
            if (!cstat.getDistributionValue().equals(distributionValue)) continue;
            theCDS = new ColumnDistributionStatisticsImpl(this.getM4Db(), distributionValue);
            try {
                theCDS.setTheColumn(this);
            }
            catch (M4Exception e) {
                throw new CreateException("Could not create Distribution Statistics object for Column " + this.getId() + ": " + e.getMessage());
            }
            theCDS.setDistributionCount(cstat.getDistributionCount());
            theCDS.setDistributionMax(cstat.getDistributionMax());
            theCDS.setDistributionMin(cstat.getDistributionMin());
            break;
        }
        return theCDS;
    }

    public ColumnDistributionStatistics getColumnDistributionStatistics(String distributionValue) {
        try {
            return this.createColumnDistributionStatistics(distributionValue);
        }
        catch (CreateException ce) {
            super.doPrint(ce);
            return null;
        }
    }

    public void removeColumnDistributionStatistics(String distributionValue) throws StorageException {
    }

    public void removeAllColumnDistributionStatisticss() throws StorageException {
    }

    public void setBaseAttribute(BaseAttribute ba) {
        try {
            super.setBaseAttribute((BaseAttributeImpl)ba);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public BaseAttribute getBaseAttribute() {
        try {
            return (BaseAttribute)((Object)super.getTheBaseAttribute());
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void removeBaseAttribute() {
        try {
            super.setBaseAttribute(null);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Column copy(ColumnSet newColumnSet) throws CreateException, NameExistsException {
        ColumnImpl theCopy = new ColumnImpl(this.getM4Db());
        try {
            theCopy.setColumnset((ColumnsetImpl)newColumnSet);
            theCopy.setAverageValue(this.getAverageValue());
            theCopy.setBaseAttribute(this.getTheBaseAttribute());
            theCopy.setColumnBasicStatistics(this.getColumnBasicStatistics());
            theCopy.setColumnDatatype(this.getColumnDatatype());
            theCopy.setMaxValue(this.getMaxValue());
            theCopy.setMinValue(this.getMinValue());
            theCopy.setMedianValue(this.getMedianValue());
            theCopy.setModalValue(this.getModalValue());
            theCopy.setName(this.getName());
            theCopy.setNumberOfMissingValues(this.getNumberOfMissingValues());
            theCopy.setNumberOfUniqueValues(this.getNumberOfUniqueValues());
            theCopy.setSQLDefinition(this.getSQLDefinition());
            theCopy.setSqlString(this.getSqlString());
            theCopy.setStandardDeviation(this.getStandardDeviation());
            theCopy.setDistributionStatistics(this.getDistributionStatistics());
        }
        catch (M4Exception m4e) {
            throw new CreateException("Could not create copy of Column " + this.getId() + ": " + m4e.getMessage());
        }
        catch (StorageException se) {
            throw new CreateException("Could not create copy of Column " + this.getId() + ": " + se.getMessage());
        }
        return theCopy;
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }

    public Collection getAllColumnDistributionStatisticss() {
        try {
            return this.getDistributionStatistics();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }
}

