/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Assertion;
import edu.udo.miningmart.m4.core.Condition;
import edu.udo.miningmart.m4.core.Constraint;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.OpParam;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.InterM4OperatorAssertion;
import edu.udo.miningmart.m4.utils.InterM4OperatorCondition;
import edu.udo.miningmart.m4.utils.InterM4OperatorConstraint;
import edu.udo.miningmart.m4.utils.InterM4OperatorOpParam;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Operator
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "operator_t";
    public static final String ATTRIB_OPERATOR_ID = "op_id";
    public static final String ATTRIB_OPERATOR_NAME = "OP_NAME";
    public static final String ATTRIB_OPERATOR_IS_MANUAL = "OP_MANUAL";
    public static final String ATTRIB_OPERATOR_IS_LOOPABLE = "OP_LOOP";
    public static final String ATTRIB_OPERATOR_IS_MULTISTEPABLE = "OP_MULTI";
    public static final String ATTRIB_OPERATOR_REALIZED = "OP_REALIZE";
    static final InterM4Communicator op2oppar = new InterM4OperatorOpParam();
    static final InterM4Communicator op2assert = new InterM4OperatorAssertion();
    static final InterM4Communicator op2cond = new InterM4OperatorCondition();
    static final InterM4Communicator op2constr = new InterM4OperatorConstraint();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    protected boolean loopable;
    protected boolean stepable;
    protected boolean manual;
    protected String realize;
    private final Vector myOpParams = new Vector();
    private final Vector myAssertions = new Vector();
    private final Vector myConditions = new Vector();
    private final Vector myConstraints = new Vector();
    private boolean allOpParamsLoaded = false;
    private boolean allAssertionsLoaded = false;
    private boolean allConditionsLoaded = false;
    private boolean allConstraintsLoaded = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_OPERATOR_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[6];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_OPERATOR_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_OPERATOR_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_OPERATOR_REALIZED, "getRealize", "setRealize", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_OPERATOR_IS_MANUAL, "getManual", "setManual", clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_OPERATOR_IS_LOOPABLE, "getLoopable", "setLoopable", clazz4);
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_OPERATOR_IS_MULTISTEPABLE, "getStepable", "setStepable", clazz5);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[5];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("isManual", "getManual", "setManual", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("isLoopable", "getLoopable", "setLoopable", clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("isMultiStepable", "getStepable", "setStepable", clazz4);
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz5);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Operator(DB db) {
        super(db);
    }

    public Iterator getOpParamsIterator() throws M4Exception {
        Collection col = this.getOpParams();
        Iterator it = col == null ? null : col.iterator();
        return it;
    }

    public void setRealize(String r) {
        this.setDirty();
        this.realize = r;
    }

    public String getRealize() {
        return this.realize;
    }

    public void setLoopable(boolean l) {
        this.setDirty();
        this.loopable = l;
    }

    public void setLoopable(String loopable) {
        this.setLoopable("YES".equals(loopable));
    }

    public boolean isLoopable() {
        return this.loopable;
    }

    public String getLoopable() {
        return this.isLoopable() ? "YES" : "NO";
    }

    public void setManual(boolean m) {
        this.setDirty();
        this.manual = m;
    }

    public void setManual(String manual) {
        this.setManual("YES".equals(manual));
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getManual() {
        return this.isManual() ? "YES" : "NO";
    }

    public void setStepable(boolean s) {
        this.setDirty();
        this.stepable = s;
    }

    public void setStepable(String stepable) {
        this.setStepable("YES".equals(stepable));
    }

    public boolean isStepable() {
        return this.stepable;
    }

    public String getStepable() {
        return this.isStepable() ? "YES" : "NO";
    }

    public Collection getOpParams() throws M4Exception {
        if (!this.allOpParamsLoaded && !this.isNew()) {
            this.allOpParamsLoaded = true;
            this.readOpParamsForOp();
        }
        return this.myOpParams;
    }

    public void addOpParam(OpParam opParam) throws M4Exception {
        op2oppar.checkNameExists(opParam, this);
        op2oppar.add(this, opParam);
    }

    public boolean removeOpParam(OpParam opParam) throws M4Exception {
        return op2oppar.remove(this, opParam);
    }

    public Collection getAssertions() throws M4Exception {
        if (!this.allAssertionsLoaded && !this.isNew()) {
            this.allAssertionsLoaded = true;
            this.readAssertionsFromDB();
        }
        return this.myAssertions;
    }

    public Collection getConditions() throws M4Exception {
        if (!this.allConditionsLoaded && !this.isNew()) {
            this.allConditionsLoaded = true;
            this.readConditionsFromDB();
        }
        return this.myConditions;
    }

    public Collection getConstraints() throws M4Exception {
        if (!this.allConstraintsLoaded && !this.isNew()) {
            this.allConstraintsLoaded = true;
            this.readConstraintsFromDB();
        }
        return this.myConstraints;
    }

    public void addAssertion(Assertion assertion) throws M4Exception {
        op2assert.add(this, assertion);
    }

    public void addCondition(Condition condition) throws M4Exception {
        op2cond.add(this, condition);
    }

    public void addConstraint(Constraint constraint) throws M4Exception {
        op2constr.add(this, constraint);
    }

    public boolean removeAssertion(Assertion assertion) throws M4Exception {
        return op2assert.remove(this, assertion);
    }

    public boolean removeCondition(Condition condition) throws M4Exception {
        return op2cond.remove(this, condition);
    }

    public boolean removeConstraint(Constraint constraint) throws M4Exception {
        return op2constr.remove(this, constraint);
    }

    private void readOpParamsForOp() throws M4Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.udo.miningmart.m4.core.OpParam");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addOpParam((OpParam)it.next());
        }
    }

    private void readAssertionsFromDB() throws M4Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Assertion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addAssertion((Assertion)it.next());
        }
    }

    private void readConditionsFromDB() throws M4Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Condition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addCondition((Condition)it.next());
        }
    }

    private void readConstraintsFromDB() throws M4Exception {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.Constraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addConstraint((Constraint)it.next());
        }
    }

    public void print() {
        this.doPrint(4, "Operator " + this.getName() + " (ID: " + this.getId() + "): {");
        this.doPrint(4, String.valueOf(this.isManual() ? "" : "not") + " manual,");
        this.doPrint(4, String.valueOf(this.isLoopable() ? "" : "not") + " loopable,");
        this.doPrint(4, String.valueOf(this.isStepable() ? "" : "not") + " multistep-able\n}");
        try {
            Iterator it = this.getOpParamsIterator();
            while (it.hasNext()) {
                OpParam op = (OpParam)it.next();
                op.print();
            }
        }
        catch (M4Exception e) {
            this.doPrint(20, "Warning: Exception when printing operator " + this.getId() + ":");
            this.doPrint(e);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector();
        op2assert.setCollectionTo(this, empty);
        op2cond.setCollectionTo(this, empty);
        op2constr.setCollectionTo(this, empty);
        op2oppar.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getOpParams());
        ret.addAll(this.getAssertions());
        ret.addAll(this.getConditions());
        ret.addAll(this.getConstraints());
        return ret;
    }
}

