/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.M4Object;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Vector;

public class Docu
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "docu_t";
    public static final String ATTRIB_DOC_ID = "doc_id";
    public static final String ATTRIB_OBJECT_ID = "doc_objid";
    public static final String ATTRIB_OBJECT_TYPE = "doc_objtype";
    public static final String ATTRIB_TEXT = "doc_text";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private M4Data myM4Object;
    private String myText;
    private String myObjectType;
    private long myM4ObjectId = -1L;
    private String[][] mapping = new String[][]{{"edu.udo.miningmart.m4.core.Assertion", "Assertion"}, {"edu.udo.miningmart.m4.core.BaseAttribute", "BaseAttribute"}, {"edu.udo.miningmart.m4.core.Case", "Case"}, {"edu.udo.miningmart.m4.core.Chain", "Chain"}, {"edu.udo.miningmart.m4.core.Column", "Column"}, {"edu.udo.miningmart.m4.core.Columnset", "Columnset"}, {"edu.udo.miningmart.m4.core.Concept", "Concept"}, {"edu.udo.miningmart.m4.core.Condition", "Condition"}, {"edu.udo.miningmart.m4.core.Constraint", "Constraint"}, {"edu.udo.miningmart.m4.core.Feature", "Feature"}, {"edu.udo.miningmart.m4.core.Key", "ForeignKey"}, {"edu.udo.miningmart.m4.core.KeyMember", "KeyMember"}, {"edu.udo.miningmart.m4.core.MultiColumnFeature", "MultiColumnFeature"}, {"edu.udo.miningmart.m4.core.OpParam", "OperatorParameter"}, {"edu.udo.miningmart.m4.core.Operator", "Operator"}, {"edu.udo.miningmart.m4.core.Parameter", "Parameter"}, {"edu.udo.miningmart.m4.core.Relation", "Relationship"}, {"edu.udo.miningmart.m4.core.Step", "Step"}, {"edu.udo.miningmart.m4.core.Value", "Value"}};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_DOC_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[4];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_DOC_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.M4Data");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_OBJECT_ID, "getM4Object", "primitiveSetM4Object", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_OBJECT_TYPE, "getObjectType", "setObjectType", clazz2, "NN");
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_TEXT, "getText", "setText", clazz3, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.M4Data");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("M4Object", "getM4Object", "setM4Object", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Text", "getText", "setText", clazz2);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Docu(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Documentation for M4 Object of type " + this.getM4Object().getClass().getName() + ", Id " + this.getId() + ": " + this.getText());
    }

    public M4Object getM4Object() {
        return this.myM4Object;
    }

    public String getText() {
        return this.myText;
    }

    public void primitiveSetM4Object(M4Data newM4Object) throws M4Exception {
        this.myM4Object = newM4Object;
        if (newM4Object != null) {
            this.myM4ObjectId = newM4Object.getId();
            this.myObjectType = this.findTypeNameForClass(newM4Object.getClass());
        }
    }

    public void setM4Object(M4Data newM4Object) throws M4Exception {
        M4Data.m4o2doc.setReciprocalReferences(newM4Object, this);
    }

    public void setText(String newText) {
        this.setDirty();
        this.myText = newText;
    }

    public long getObjectId() {
        if (this.myM4ObjectId > -1L) {
            return this.myM4ObjectId;
        }
        return 0L;
    }

    public String getObjectType() {
        return this.myObjectType;
    }

    public void setObjectId(long id) throws M4Exception {
        this.setDirty();
        this.myM4ObjectId = id;
        if (this.getObjectType() != null) {
            Class c = this.findClassForTypeName(this.getObjectType());
            this.setM4Object((M4Data)this.getM4Db().getM4Object(id, c));
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.setM4Object(null);
    }

    public Collection getDependentObjects() {
        return new Vector();
    }

    public void setObjectType(String type) throws M4Exception {
        this.setDirty();
        this.myObjectType = type;
        if (this.getObjectId() > -1L) {
            Class c = this.findClassForTypeName(type);
            this.setM4Object((M4Data)this.getM4Db().getM4Object(this.getObjectId(), c));
        }
    }

    private Class findClassForTypeName(String typeName) throws M4Exception {
        String classname = null;
        int i = 0;
        while (i < this.mapping.length) {
            if (typeName.equals(this.mapping[i][1])) {
                classname = this.mapping[i][0];
            }
            ++i;
        }
        if (classname == null) {
            throw new M4Exception("Docu.findClassForTypeName: unknown type name '" + typeName + "!");
        }
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new M4Exception("Docu.findClassForTypeName: Class not found: " + c.getName());
        }
        return c;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findTypeNameForClass(Class type) throws M4Exception {
        Class clazz;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                type = type.getSuperclass();
            }
            if ((clazz = class$3) != null) continue;
            try {
                clazz = Class.forName("miningmart.m4.M4Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(type));
        int i = 0;
        while (i < this.mapping.length) {
            if (this.mapping[i][0].equals(type.getName())) {
                return this.mapping[i][1];
            }
            ++i;
        }
        throw new M4Exception("Docu.findTypeNameForClass: unknown class " + type.getName() + "!");
    }
}

