/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.ConceptInheritance;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Projection;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.InterM4ConceptColumnset;
import edu.udo.miningmart.m4.utils.InterM4ConceptFeature;
import edu.udo.miningmart.m4.utils.InterM4FromConceptProjection;
import edu.udo.miningmart.m4.utils.InterM4FromConceptRelation;
import edu.udo.miningmart.m4.utils.InterM4SubConceptConInh;
import edu.udo.miningmart.m4.utils.InterM4SuperConceptConInh;
import edu.udo.miningmart.m4.utils.InterM4ToConceptProjection;
import edu.udo.miningmart.m4.utils.InterM4ToConceptRelation;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Concept
extends ParameterObject
implements XmlInfo {
    public static final String M4_TABLE_NAME = "concept_t";
    public static final String ATTRIB_CONCEPT_ID = "con_id";
    public static final String ATTRIB_CASE_ID = "con_caid";
    public static final String ATTRIB_CONCEPT_NAME = "con_name";
    public static final String ATTRIB_CONCEPT_TYPE = "con_type";
    static final InterM4Communicator con2cs = new InterM4ConceptColumnset();
    static final InterM4Communicator con2fea = new InterM4ConceptFeature();
    static final InterM4Communicator con2ToRel = new InterM4ToConceptRelation();
    static final InterM4Communicator con2FromRel = new InterM4FromConceptRelation();
    static final InterM4Communicator con2toPro = new InterM4ToConceptProjection();
    static final InterM4Communicator con2fromPro = new InterM4FromConceptProjection();
    static final InterM4Communicator conInheritSub = new InterM4SubConceptConInh();
    static final InterM4Communicator conInheritSuper = new InterM4SuperConceptConInh();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private final Vector myColumnSets = new Vector();
    private boolean allColumnSetsLoaded = false;
    private final Vector myFeatures = new Vector();
    private boolean allFeaturesLoaded = false;
    private final Vector myFromProjections = new Vector();
    private boolean allfromProjectionsLoaded = false;
    private final Vector myToProjections = new Vector();
    private boolean allToProjectionsLoaded = false;
    private final Vector mySubConceptsInh = new Vector();
    private boolean allSubConceptsLoaded = false;
    private final Vector mySuperConceptsInh = new Vector();
    private boolean allSuperConceptsLoaded = false;
    private final Vector myFromRelations = new Vector();
    private boolean allFromRelationsLoaded = false;
    private final Vector myToRelations = new Vector();
    private boolean allToRelationsLoaded = false;
    private String myType;
    private Case myCase;
    private Vector multiStepsColumnsets;
    private int columnsetIndex;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CONCEPT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[4];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_CONCEPT_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_CONCEPT_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Case");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", clazz2, "NN");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_CONCEPT_TYPE, "getType", "setType", clazz3, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[6];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Case");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Case", "getTheCase", "setTheCase", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("Type", "getType", "setType", clazz3);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("SuperConcept", "getTheSuperConcept", "setTheSuperConcept", clazz4);
            Class<?> clazz5 = class$3;
            if (clazz5 == null) {
                try {
                    clazz5 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("ProjectionOf", "getTheFromProjection", "setTheFromProjection", clazz5);
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz6);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Concept(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Concept " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.myType + ") ");
        try {
            Collection features;
            Collection colSets = this.getColumnSets();
            if (colSets != null) {
                Iterator it = colSets.iterator();
                while (it.hasNext()) {
                    ((Columnset)it.next()).print();
                }
            }
            if ((features = this.getFeatures()) != null) {
                Iterator it = features.iterator();
                while (it.hasNext()) {
                    ((Feature)it.next()).print();
                }
            }
        }
        catch (M4Exception e) {
            this.doPrint(20, "Warning: Exception caught while printing!");
            this.doPrint(e);
        }
        super.print();
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public void setType(String t) throws M4Exception {
        this.setDirty();
        if (!(t.equalsIgnoreCase("DB") || t.equalsIgnoreCase("Base") || t.equalsIgnoreCase("Mining"))) {
            throw new M4Exception("Tried to set unknown type into Concept '" + this.getName() + "': " + t);
        }
        this.myType = t.toUpperCase();
    }

    public String getType() {
        return this.myType;
    }

    public void addColumnSet(Columnset cs) throws M4Exception {
        con2cs.checkNameExists(cs, this);
        con2cs.add(this, cs);
    }

    public boolean removeColumnset(Columnset cs) throws M4Exception {
        return con2cs.remove(this, cs);
    }

    public boolean hasColumnset(Columnset cs) throws M4Exception {
        Collection csets = this.getFeatures();
        if (cs == null || csets == null) {
            return false;
        }
        return csets.contains(cs);
    }

    public void setColumnSets(Collection theColumnsets) throws M4Exception {
        con2cs.setCollectionTo(this, theColumnsets);
    }

    public Collection getColumnSets() throws M4Exception {
        if (!this.allColumnSetsLoaded && !this.isNew()) {
            this.allColumnSetsLoaded = true;
            this.readColumnSetsForConceptFromDB();
        }
        return this.myColumnSets;
    }

    public String getCurrentSuffix() {
        if (this.multiStepsColumnsets != null) {
            return "_" + this.columnsetIndex;
        }
        return "";
    }

    private void readColumnSetsForConceptFromDB() throws M4Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addColumnSet((Columnset)it.next());
        }
    }

    public void initMultiStepSupport(Collection columnsets) {
        this.multiStepsColumnsets = new Vector(columnsets);
        this.resetColumnSets();
    }

    public Columnset getCurrentColumnSet() throws M4Exception {
        if (this.multiStepsColumnsets != null) {
            return (Columnset)this.multiStepsColumnsets.get(this.columnsetIndex);
        }
        Collection csets = this.getColumnSets();
        if (csets != null && !csets.isEmpty()) {
            return (Columnset)csets.iterator().next();
        }
        return null;
    }

    public void resetColumnSets() {
        this.columnsetIndex = 0;
    }

    public boolean hasNextColumnSet() throws M4Exception {
        if (this.multiStepsColumnsets != null) {
            return this.columnsetIndex + 1 < this.multiStepsColumnsets.size();
        }
        Collection c = this.getColumnSets();
        if (c == null) {
            throw new M4Exception("Concept '" + this.getName() + "', id: " + this.getId() + "\nError during call of method Concept.hasNextColumnSet(): " + "\"InputConcept\".getColumnSets() returned null.");
        }
        return false;
    }

    public Columnset getNextColumnSet() throws M4Exception {
        if (this.hasNextColumnSet()) {
            return (Columnset)this.multiStepsColumnsets.get(++this.columnsetIndex);
        }
        throw new M4Exception("Concept '" + this.getName() + "', id: " + this.getId() + "\nTried to call method getNextColumnSet() with no Columnset left!");
    }

    public Case getTheCase() throws M4Exception {
        return this.myCase;
    }

    public void setTheCase(Case ca) throws M4Exception {
        Case.case2con.checkNameExists(this, ca);
        Case.case2con.updateReferenceTo(this, ca);
    }

    public void primitiveSetCase(Case ca) {
        this.setDirty();
        this.myCase = ca;
    }

    public void addFeature(Feature f) throws M4Exception {
        con2fea.checkNameExists(f, this);
        con2fea.add(this, f);
    }

    public Feature getFeature(int index) throws M4Exception {
        Collection fea = this.getFeatures();
        if (fea == null || index < 0 && index >= fea.size()) {
            throw new M4Exception("Concept.getFeature(): No Featurearray exists, or wrong index!");
        }
        Vector v = fea instanceof Vector ? (Vector)fea : new Vector(fea);
        return (Feature)v.get(index);
    }

    public boolean removeFeature(Feature feature) throws M4Exception {
        return con2fea.remove(this, feature);
    }

    public void setFeatures(Collection theFeatures) throws M4Exception {
        con2fea.setCollectionTo(this, theFeatures);
    }

    public Collection getFeatures() throws M4Exception {
        if (!this.allFeaturesLoaded && !this.isNew()) {
            this.allFeaturesLoaded = true;
            this.readFeaturesForConcept();
        }
        return this.myFeatures;
    }

    public int getNumberOfFeatures() throws M4Exception {
        Collection features = this.getFeatures();
        if (features == null) {
            return 0;
        }
        return features.size();
    }

    public boolean hasFeature(Feature f) throws M4Exception {
        Collection features = this.getFeatures();
        if (f == null || features == null) {
            return false;
        }
        return features.contains(f);
    }

    private void readFeaturesForConcept() throws M4Exception {
        this.readBaseAttributesFromDb();
        this.readMCFsFromDb();
    }

    private void readBaseAttributesFromDb() throws M4Exception {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addFeature((BaseAttribute)it.next());
        }
    }

    private void readMCFsFromDb() throws M4Exception {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("edu.udo.miningmart.m4.core.MultiColumnFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addFeature((MultiColumnFeature)it.next());
        }
    }

    public Collection getTheFromRelationships() throws M4Exception {
        if (!this.allFromRelationsLoaded && !this.isNew()) {
            this.allFromRelationsLoaded = true;
            this.readRelationsFromDB(true);
        }
        return this.myFromRelations;
    }

    protected void addFromRelationship(Relation newRel) throws M4Exception {
        con2FromRel.checkNameExists(newRel, this);
        con2FromRel.add(this, newRel);
    }

    protected void addToRelationship(Relation newRel) throws M4Exception {
        con2ToRel.checkNameExists(newRel, this);
        con2ToRel.add(this, newRel);
    }

    public Collection getTheToRelationships() throws M4Exception {
        if (!this.allToRelationsLoaded && !this.isNew()) {
            this.allToRelationsLoaded = true;
            this.readRelationsFromDB(false);
        }
        return this.myToRelations;
    }

    public Collection getConceptInheritanceAsSuperConcept() throws M4Exception {
        if (!this.allSuperConceptsLoaded && !this.isNew()) {
            this.allSuperConceptsLoaded = true;
            this.readSuperConceptsFromDB();
        }
        return this.mySuperConceptsInh;
    }

    public Collection getConceptInheritanceAsSubConcept() throws M4Exception {
        if (!this.allSubConceptsLoaded && !this.isNew()) {
            this.allSubConceptsLoaded = true;
            this.readSubConceptsFromDB();
        }
        return this.mySubConceptsInh;
    }

    public Collection getSuperConcepts() throws M4Exception {
        Iterator it = this.getConceptInheritanceAsSubConcept().iterator();
        Vector<Concept> concepts = new Vector<Concept>();
        while (it.hasNext()) {
            Concept con;
            ConceptInheritance conInh = (ConceptInheritance)it.next();
            if (conInh == null || (con = conInh.getSuperConcept()) == null) continue;
            concepts.add(con);
        }
        return concepts;
    }

    public Collection getSubConcepts() throws M4Exception {
        Iterator it = this.getConceptInheritanceAsSuperConcept().iterator();
        Vector<Concept> concepts = new Vector<Concept>();
        while (it.hasNext()) {
            Concept con;
            ConceptInheritance conInh = (ConceptInheritance)it.next();
            if (conInh == null || (con = conInh.getSubConcept()) == null) continue;
            concepts.add(con);
        }
        return concepts;
    }

    public Concept getTheSuperConcept() throws M4Exception {
        Collection col = this.getSuperConcepts();
        if (col == null || col.isEmpty()) {
            return null;
        }
        return (Concept)col.iterator().next();
    }

    public void addSubConcept(Concept newSubConcept) throws M4Exception {
        if (newSubConcept != null) {
            Collection col = newSubConcept.getAllSubConcepts();
            if (col.contains(this)) {
                String thisName = this.getName();
                String subName = newSubConcept.getName();
                throw new M4Exception("Adding/setting sub-concept (ID: " + newSubConcept.getId() + ", Name: " + (subName == null ? "<null>" : subName) + ") for concept (ID: " + this.getId() + ", Name: " + (thisName == null ? "<null>" : thisName) + ") would create an inheritance cycle!");
            }
            DB dB = this.getM4Db();
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.ConceptInheritance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ConceptInheritance conInh = (ConceptInheritance)dB.createNewInstance(clazz);
            conInh.setSubConcept(newSubConcept);
            conInh.setSuperConcept(this);
        }
    }

    public void addSuperConcept(Concept newSuperConcept) throws M4Exception {
        if (newSuperConcept != null) {
            Collection col = this.getAllSubConcepts();
            if (col.contains(newSuperConcept)) {
                String thisName = this.getName();
                String supName = newSuperConcept.getName();
                throw new M4Exception("Adding/setting super concept (ID: " + newSuperConcept.getId() + ", Name: " + (supName == null ? "<null>" : supName) + ") for concept (ID: " + this.getId() + ", Name: " + (thisName == null ? "<null>" : thisName) + ") would create an inheritance cycle!");
            }
            DB dB = this.getM4Db();
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.ConceptInheritance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ConceptInheritance conInh = (ConceptInheritance)dB.createNewInstance(clazz);
            conInh.setSubConcept(this);
            conInh.setSuperConcept(newSuperConcept);
        }
    }

    private Collection getAllSubConcepts() throws M4Exception {
        Vector<Concept> open = new Vector<Concept>();
        HashSet<Concept> closed = new HashSet<Concept>();
        open.add(this);
        while (!open.isEmpty()) {
            Concept next = (Concept)open.firstElement();
            if (next == null) continue;
            Iterator it = next.getSubConcepts().iterator();
            while (it.hasNext()) {
                Concept sub = (Concept)it.next();
                if (open.contains(sub) || closed.contains(sub)) continue;
                open.add(sub);
            }
            open.remove(next);
            closed.add(next);
        }
        return closed;
    }

    public void setTheSuperConcept(Concept newSuperConcept) throws M4Exception {
        conInheritSub.setCollectionTo(this, new Vector());
        this.addSuperConcept(newSuperConcept);
    }

    private void addSubConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSuper.add(this, conInh);
    }

    private void addSuperConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSub.add(this, conInh);
    }

    private void removeSubConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSuper.remove(this, conInh);
    }

    private void removeSuperConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSub.remove(this, conInh);
    }

    public void addToProjection(Projection projection) throws M4Exception {
        Collection col;
        if (projection != null && projection.getFromConcept() != null && (col = Projection.getTransitiveToProjectionsForConcept(this)).contains(projection.getFromConcept())) {
            projection.setFromConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        con2toPro.add(this, projection);
    }

    public boolean removeToProjection(Projection projection) throws M4Exception {
        return con2fromPro.remove(this, projection);
    }

    public void addFromProjection(Projection projection) throws M4Exception {
        Collection col;
        if (projection != null && projection.getToConcept() != null && (col = Projection.getTransitiveToProjectionsForConcept(projection.getToConcept())).contains(this)) {
            projection.setToConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        con2fromPro.add(this, projection);
    }

    public boolean removeFromProjection(Projection projection) throws M4Exception {
        return con2fromPro.remove(this, projection);
    }

    public void setTheFromProjection(Concept newFromProjection) throws M4Exception {
        con2toPro.setCollectionTo(this, new Vector());
        if (newFromProjection != null) {
            DB dB = this.getM4Db();
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("edu.udo.miningmart.m4.core.Projection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Projection projection = (Projection)dB.createNewInstance(clazz);
            projection.setFromConcept(newFromProjection);
            projection.setToConcept(this);
        }
    }

    public Concept getTheFromProjection() throws M4Exception {
        Collection col = this.getProjectionsAsToConcept();
        if (col == null || col.isEmpty()) {
            return null;
        }
        return ((Projection)((Object)col.iterator())).getFromConcept();
    }

    public Collection getProjectionsAsFromConcept() throws M4Exception {
        if (!this.allfromProjectionsLoaded && !this.isNew()) {
            this.allfromProjectionsLoaded = true;
            this.readFromProjectionsFromDB();
        }
        return this.myFromProjections;
    }

    public Collection getProjectionsAsToConcept() throws M4Exception {
        if (!this.allToProjectionsLoaded && !this.isNew()) {
            this.allToProjectionsLoaded = true;
            this.readToProjectionsFromDB();
        }
        return this.myToProjections;
    }

    private void readSubConceptsFromDB() throws M4Exception {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.ConceptInheritance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection conInhs = this.getObjectsReferencingMe(clazz, "cisa_subconid");
        Iterator it = conInhs.iterator();
        while (it.hasNext()) {
            this.addSubConcept((ConceptInheritance)it.next());
        }
    }

    private void readSuperConceptsFromDB() throws M4Exception {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.ConceptInheritance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection conInhs = this.getObjectsReferencingMe(clazz, "cisa_superconid");
        Iterator it = conInhs.iterator();
        while (it.hasNext()) {
            this.addSuperConcept((ConceptInheritance)it.next());
        }
    }

    private void readFromProjectionsFromDB() throws M4Exception {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("edu.udo.miningmart.m4.core.Projection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz, "pro_fromconid").iterator();
        while (it.hasNext()) {
            this.addFromProjection((Projection)it.next());
        }
    }

    private void readToProjectionsFromDB() throws M4Exception {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("edu.udo.miningmart.m4.core.Projection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz, "pro_toconid").iterator();
        while (it.hasNext()) {
            this.addToProjection((Projection)it.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readRelationsFromDB(boolean thisConceptIsFromConcept) throws M4Exception {
        String fkAttribute = thisConceptIsFromConcept ? "rel_fromconid" : "rel_toconid";
        Class<?> clazz = class$9;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("edu.udo.miningmart.m4.core.Relation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$9 = clazz2;
        }
        Collection relations = this.getObjectsReferencingMe(clazz, fkAttribute);
        Iterator it = relations.iterator();
        if (thisConceptIsFromConcept) {
            while (true) {
                if (!it.hasNext()) {
                    return;
                }
                this.addFromRelationship((Relation)it.next());
            }
        }
        while (it.hasNext()) {
            this.addToRelationship((Relation)it.next());
        }
        return;
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setTheCase(null);
        Vector empty = new Vector(0);
        this.setFeatures(empty);
        this.setColumnSets(empty);
        con2FromRel.setCollectionTo(this, empty);
        con2ToRel.setCollectionTo(this, empty);
        con2fromPro.setCollectionTo(this, empty);
        con2toPro.setCollectionTo(this, empty);
        conInheritSub.setCollectionTo(this, empty);
        conInheritSuper.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected Collection getGraphicallyEmbeddedObjects() throws M4Exception {
        Vector ret = new Vector();
        ret.addAll(this.getSuperConcepts());
        ret.addAll(this.getSubConcepts());
        ret.addAll(this.getTheFromRelationships());
        ret.addAll(this.getTheToRelationships());
        return ret;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getColumnSets());
        ret.addAll(this.getFeatures());
        ret.addAll(this.getTheFromRelationships());
        ret.addAll(this.getTheToRelationships());
        return ret;
    }
}

