/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.utils.InterM4BaseattributeColumn;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class BaseAttribute
extends Feature
implements XmlInfo {
    public static final String M4_TABLE_NAME = "baseattrib_t";
    public static final String ATTRIB_BASEATTRIBUTE_ID = "ba_id";
    public static final String ATTRIB_BASEATTRIBUTE_NAME = "ba_name";
    public static final String ATTRIB_BASEATTRIBUTE_CONCEPTUAL_DT = "ba_condtid";
    public static final String ATTRIB_BASEATTRIBUTE_RELEVANCE = "ba_relevance";
    public static final String ATTRIB_BASEATTRIBUTE_TYPE = "ba_attribtype";
    public static final String ATTRIB_BASEATTRIBUTE_MCF_ID = "ba_mcfid";
    public static final String M4_TABLE_BA_CON = "ba_concept_t";
    public static final String ATTRIB_BA_CON_TUPLE_ID = "bc_id";
    public static final String ATTRIB_BA_CON_CONID = "bc_conid";
    public static final String ATTRIB_BA_CON_BAID = "bc_baid";
    static final InterM4BaseattributeColumn ba2col = new InterM4BaseattributeColumn();
    private static ConceptualDatatypes dataTypeMapping = null;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private long dataType;
    private String dataTypeName;
    private final Vector myColumns = new Vector();
    private Concept myConcept;
    private boolean allColumnsLoaded = false;
    private boolean relevant;
    private boolean dbAttrib;
    private MultiColumnFeature myMCFeature;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private ConceptualDatatypes getConceptualDatatypeMapping(DB db) throws DbConnectionClosed, M4Exception {
        if (dataTypeMapping == null) {
            dataTypeMapping = new ConceptualDatatypes(db);
        }
        return dataTypeMapping;
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_BASEATTRIBUTE_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[6];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_NAME, "getName", "setName", clazz, "NN");
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_CONCEPTUAL_DT, "getConceptualDataType", "setConceptualDataType", Long.TYPE, "NN");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_RELEVANCE, "getRelevantS", "setRelevantS", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_TYPE, "getDBAttribS", "setDBAttribS", clazz3, "NN");
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("edu.udo.miningmart.m4.core.MultiColumnFeature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_BASEATTRIBUTE_MCF_ID, "getMCFeature", "primitiveSetMCFeature", clazz4);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[7];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("ConDatatype", "getConceptualDataTypeName", "setConceptualDataTypeName", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("Relevant", "getRelevantS", "setRelevantS", clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("Type", "getDBAttribS", "setDBAttribS", clazz4);
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("edu.udo.miningmart.m4.core.MultiColumnFeature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("MultiColumnFeature", "getMCFeature", "setMCFeature", clazz5);
            Class<?> clazz6 = class$3;
            if (clazz6 == null) {
                try {
                    clazz6 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("Concept", "getTheConcept", "setConcept", clazz6);
            Class<?> clazz7 = class$1;
            if (clazz7 == null) {
                try {
                    clazz7 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz7);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public BaseAttribute(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        String dtName;
        try {
            dtName = this.getConceptualDataTypeName();
        }
        catch (Exception e) {
            dtName = " <Conceptual datatype Id: " + this.getConceptualDataType() + "> ";
        }
        String toPrint = "Base Attribute " + this.getName() + " (Id: " + this.myId + "): " + dtName + " of concepts: ";
        toPrint = this.myConcept != null ? String.valueOf(toPrint) + this.myConcept.getName() + ", " : String.valueOf(toPrint) + "(not loaded)";
        this.doPrint(4, toPrint);
        if (this.myColumns != null) {
            Iterator it = ((AbstractList)this.myColumns).iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                if (c == null) continue;
                c.print();
            }
        }
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public BaseAttribute copy() throws M4Exception {
        DB dB = this.getM4Db();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseAttribute ret = (BaseAttribute)dB.createNewInstance(clazz);
        ret.setId(0L);
        ret.setConcept(this.getTheConcept());
        ret.setConceptualDataType(this.getConceptualDataType());
        ret.setDBAttrib(this.isDBAttrib());
        ret.setMCFeature(this.getMCFeature());
        ret.setName(this.getName());
        ret.setRelevant(this.isRelevant());
        ret.setColumns(this.getColumns());
        return ret;
    }

    public void addColumn(Column column) throws M4Exception {
        ba2col.add(this, column);
    }

    public boolean hasColumn(Column col) throws M4Exception {
        Collection columns = this.getColumns();
        if (col == null || columns == null) {
            return false;
        }
        return columns.contains(col);
    }

    public boolean hasColumns() throws M4Exception {
        Collection columns = this.getColumns();
        return columns != null && !columns.isEmpty();
    }

    public boolean removeColumn(Column column) throws M4Exception {
        return ba2col.remove(this, column);
    }

    public void setConcept(Concept c) throws M4Exception {
        Concept.con2fea.checkNameExists(this, c);
        Concept.con2fea.updateReferenceTo(this, c);
    }

    public void setConceptualDataType(long type) {
        this.setDirty();
        this.dataType = type;
    }

    public long getConceptualDataType() {
        return this.dataType;
    }

    public void setConceptualDataTypeName(String dtname) throws DbConnectionClosed, M4Exception {
        long type = this.getConceptualDatatypeMapping(this.getM4Db()).getIdForName(dtname);
        this.setConceptualDataType(type);
    }

    public String getConceptualDataTypeName() throws DbConnectionClosed, M4Exception {
        long type = this.getConceptualDataType();
        return this.getConceptualDatatypeMapping(this.getM4Db()).getNameForId(type);
    }

    public void setColumns(Collection theColumns) throws M4Exception {
        ba2col.setCollectionTo(this, theColumns);
    }

    public Collection getColumns() throws M4Exception {
        if (!this.allColumnsLoaded && !this.isNew()) {
            this.allColumnsLoaded = true;
            this.readColumnsForBA();
        }
        return this.myColumns;
    }

    public Column getColumn(int index) throws M4Exception {
        this.getColumns();
        if (this.myColumns != null && index > -1 && index < this.myColumns.size()) {
            return (Column)this.myColumns.get(index);
        }
        throw new M4Exception("BaseAttribute.getColumn(): No Columnarray exists, or wrong index!");
    }

    private Column getColumnForColumnSet(Columnset cs) throws M4Exception {
        Collection columns = this.getColumns();
        if (columns != null) {
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Columnset myCs;
                Column col = (Column)it.next();
                if (col == null || (myCs = col.getColumnset()) == null || myCs.getId() != cs.getId()) continue;
                return col;
            }
        }
        return null;
    }

    public Column getCurrentColumn() throws M4Exception {
        Concept c = this.getTheConcept();
        if (c != null) {
            Columnset cs = c.getCurrentColumnSet();
            return this.getColumnForColumnSet(cs);
        }
        return null;
    }

    public Concept getTheConcept() throws M4Exception {
        return this.myConcept;
    }

    public void setMCFeature(MultiColumnFeature mcf) throws M4Exception {
        MultiColumnFeature.mcf2ba.checkNameExists(this, mcf);
        MultiColumnFeature.mcf2ba.updateReferenceTo(this, mcf);
    }

    public MultiColumnFeature getMCFeature() {
        return this.myMCFeature;
    }

    public boolean isRelevant() {
        return this.relevant;
    }

    public String getRelevantS() {
        return this.isRelevant() ? "YES" : "NO";
    }

    public void setRelevant(boolean r) {
        this.setDirty();
        this.relevant = r;
    }

    public void setRelevantS(String r) {
        this.setRelevant("YES".equals(r));
    }

    public boolean isDBAttrib() {
        return this.dbAttrib;
    }

    public String getDBAttribS() {
        return this.isDBAttrib() ? "DB" : "MINING";
    }

    public void setDBAttrib(boolean a) {
        this.setDirty();
        this.dbAttrib = a;
    }

    public void setDBAttribS(String attrib) {
        this.setDBAttrib("DB".equals(attrib));
    }

    public boolean isDeselected() throws M4CompilerError {
        try {
            return this.getCurrentColumn() == null;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Error getting current column for BA with Id " + this.getId() + ": " + e.getMessage());
        }
    }

    private void readColumnsForBA() throws M4Exception {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection theColumns = this.getObjectsReferencingMe(clazz);
        this.setColumns(theColumns);
    }

    private void readConceptForBA() throws M4Exception {
        String query = "SELECT bc_conid FROM ba_concept_t WHERE bc_baid = " + this.getId();
        Long conId = this.executeM4SingleValueSqlReadL(query);
        Concept c = null;
        if (conId != null) {
            DB dB = this.getM4Db();
            long l = conId;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            c = (Concept)dB.getM4Object(l, clazz);
        }
        this.primitiveSetConcept(c);
    }

    public void primitiveSetConcept(Concept c) {
        this.setDirty();
        this.myConcept = c;
    }

    public void primitiveSetMCFeature(MultiColumnFeature mcf) {
        this.setDirty();
        this.myMCFeature = mcf;
    }

    protected void readFromDbLocal() throws M4Exception {
        this.readConceptForBA();
    }

    protected void storeLocal() throws M4Exception {
        super.storeLocal();
        String sql = "DELETE FROM ba_concept_t WHERE bc_baid = " + this.getId();
        this.executeM4SqlWrite(sql);
        if (this.getTheConcept() != null) {
            String conceptId = Long.toString(this.getTheConcept().getId());
            String sql2 = "INSERT INTO ba_concept_t ( bc_id, bc_baid, bc_conid ) VALUES ( " + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + conceptId + " )";
            this.executeM4SqlWrite(sql2);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setColumns(new Vector());
        this.setConcept(null);
        this.setMCFeature(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getColumns());
        return ret;
    }
}

