/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.db.DBObject;
import com.syllogic.miningmart.concepteditor.dialogs.SimpleListDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.Chain;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.Step;

public class SelectUtility {
    public static final String TYPE_CASENAME = "CaseName";
    public static final String TYPE_CHAINM = "Chain";
    public static final String TYPE_COLUMNSET = "ColumnSet";
    public static final String TYPE_CONCEPTM = "Concept";
    public static final String TYPE_DBOBJECT = "DBObject";
    public static final String TYPE_STEPM = "Step";

    private static String getTitle(String type) {
        String title = "Select a " + type;
        if (type == TYPE_CASENAME) {
            title = "Select a Case";
        }
        if (type == TYPE_CHAINM) {
            title = "Select one or more Chains";
        }
        if (type == TYPE_CONCEPTM) {
            title = "Select one or more Concepts";
        }
        if (type == TYPE_DBOBJECT) {
            title = "Select a database object to connect this Concept to";
        }
        if (type == TYPE_STEPM) {
            title = "Select one or more Steps";
        }
        return title;
    }

    private static String getEntry(String type, Object object) {
        String entry = null;
        if (type == TYPE_CASENAME) {
            entry = (String)object;
        }
        if (type == TYPE_CHAINM) {
            entry = ((Chain)object).getName();
        }
        if (type == TYPE_COLUMNSET) {
            entry = String.valueOf(((ColumnSet)object).getName()) + " " + ((ColumnSet)object).getMultiStepBranch();
        }
        if (type == TYPE_CONCEPTM) {
            entry = ((Concept)object).getName();
        }
        if (type == TYPE_DBOBJECT) {
            entry = String.valueOf(((DBObject)object).getName()) + " (" + ((DBObject)object).getType() + ")";
        }
        if (type == TYPE_STEPM) {
            entry = ((Step)object).getName();
        }
        return entry;
    }

    public Object selectObject(Frame parentFrame, String type, Collection allObjects) {
        int numObjects = allObjects.size();
        Iterator it = allObjects.iterator();
        Object object = null;
        if (numObjects == 0) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        Object anObject = null;
        while (it.hasNext()) {
            anObject = it.next();
            entries.add(SelectUtility.getEntry(type, anObject));
        }
        String title = SelectUtility.getTitle(type);
        SimpleListDialog aDialog = new SimpleListDialog(parentFrame, true);
        aDialog.clear();
        aDialog.setTitle(title);
        aDialog.fillList(entries, true);
        ((Component)aDialog).setVisible(true);
        if (aDialog.cancelPressed()) {
            return null;
        }
        Object[] selections = aDialog.getSelectedValues().toArray();
        Object select = null;
        String selectedEntry = "";
        if (selections.length == 0) {
            return null;
        }
        select = selections[0];
        selectedEntry = (String)select;
        boolean found = false;
        if (selectedEntry != "") {
            it = allObjects.iterator();
            while (it.hasNext() && !found) {
                anObject = it.next();
                if (!SelectUtility.getEntry(type, anObject).equals(selectedEntry)) continue;
                found = true;
                object = anObject;
            }
        }
        return object;
    }

    public Collection selectObjects(Frame parentFrame, String type, Collection allObjects) {
        int numObjects = allObjects.size();
        Iterator it = allObjects.iterator();
        Object object = null;
        if (numObjects == 0) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        Object anObject = null;
        while (it.hasNext()) {
            anObject = it.next();
            entries.add(SelectUtility.getEntry(type, anObject));
        }
        String title = SelectUtility.getTitle(type);
        SimpleListDialog aDialog = new SimpleListDialog(parentFrame, true);
        aDialog.clear();
        aDialog.setTitle(title);
        aDialog.setMultipleSelection();
        aDialog.fillList(entries, true);
        ((Component)aDialog).setVisible(true);
        if (aDialog.cancelPressed()) {
            return null;
        }
        Collection selectedEntries = aDialog.getSelectedValues();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        if (selectedEntries.size() != 0) {
            it = allObjects.iterator();
            while (it.hasNext()) {
                anObject = it.next();
                if (!selectedEntries.contains(SelectUtility.getEntry(type, anObject))) continue;
                selectedObjects.add(anObject);
            }
        }
        return selectedObjects;
    }
}

