/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.dialogs.ColumnPropertiesPanel;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import miningmart.m4.Column;
import org.apache.log4j.Logger;

public class ColumnDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"ColumnDialog");
    private int numberOfProperties = 4;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private ColumnPropertiesPanel propertiesTab = new ColumnPropertiesPanel();
    private Column currentColumn;

    public ColumnDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initGUI();
    }

    public void initForDisplay(Column column) {
        if (column == null) {
            logger.error((Object)"Could not properly initialize Column dialog.");
            String message = "A initialization error occurred!\nCould properly initialize Column dialog.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        this.currentColumn = column;
        this.propertiesTab.getNameTextField().setText(this.currentColumn.getName());
        String dtt = this.currentColumn.getColumnDatatype();
        this.propertiesTab.getDatatypeTextField().setText(dtt);
        this.propertiesTab.getSQLTextArea().setText(this.currentColumn.getSqlString());
    }

    private void initGUI() {
        this.setTitle("Column properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ColumnDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        int preferredHeight = (this.numberOfProperties + 1) * 20 + 80;
        this.tabbedPane.setPreferredSize(new Dimension(500, preferredHeight));
    }

    public void close() {
        this.currentColumn = null;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOKExisting();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        }
    }

    private void doOKExisting() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OK button");
        }
        this.close();
    }

    private void doCancel() {
        this.close();
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }
}

