/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.jfc.diagram.PersistentStyleRelation;
import com.syllogic.jfc.event.DiagramRelationListener;
import com.syllogic.jfc.event.DraggebleRelationEvent;
import com.syllogic.jfc.event.DraggebleRelationListener;
import com.syllogic.miningmart.concepteditor.diagram.ConceptComponent;
import java.awt.Point;
import java.util.AbstractCollection;
import java.util.ArrayList;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class RelationshipComponent
implements DraggebleRelation,
PersistentStyleRelation {
    private static Logger logger = Logger.getLogger((String)"RelationshipComponent");
    private Relationship relationship;
    private ConceptComponent fromComponent;
    private ConceptComponent toComponent;
    private int beginX;
    private int beginY;
    private int endX;
    private int endY;
    private Point endPointFrom;
    private Point endPointTo;
    private Point ctrlPointFrom;
    private Point ctrlPointTo;
    private Boolean wantCubicLine = new Boolean(true);
    private Boolean wantArrowHalfway = new Boolean(false);
    private ArrayList listenerList = new ArrayList();

    public RelationshipComponent(Relationship relationship) {
        this.relationship = relationship;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setFromComponent(DiagramComponent fromComponent) {
        this.fromComponent = (ConceptComponent)fromComponent;
    }

    public void setToComponent(DiagramComponent toComponent) {
        this.toComponent = (ConceptComponent)toComponent;
    }

    public DiagramComponent getFromComponent() {
        return this.fromComponent;
    }

    public DiagramComponent getToComponent() {
        return this.toComponent;
    }

    public Point getEndPoint(int endPoint) {
        if (endPoint == 0) {
            return this.endPointFrom;
        }
        if (endPoint == 1) {
            return this.endPointTo;
        }
        if (endPoint == 2) {
            return this.ctrlPointFrom;
        }
        if (endPoint == 3) {
            return this.ctrlPointTo;
        }
        return null;
    }

    public void initEndPoint(int endPoint, Point point) {
        if (endPoint == 0) {
            this.endPointFrom = point;
        } else if (endPoint == 1) {
            this.endPointTo = point;
        } else if (endPoint == 2) {
            this.ctrlPointFrom = point;
        } else if (endPoint == 3) {
            this.ctrlPointTo = point;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Control point initialized. Type: " + endPoint + "\n"));
            if (point != null) {
                logger.debug((Object)("Value x: " + point.x));
                logger.debug((Object)("Value y: " + point.y));
            } else {
                logger.debug((Object)"Values are NULL! ");
            }
        }
    }

    public void setEndPoint(int endPoint, Point point) {
        if (endPoint == 0) {
            this.endPointFrom = point;
        } else if (endPoint == 1) {
            this.endPointTo = point;
        } else if (endPoint == 2) {
            this.ctrlPointFrom = point;
        } else if (endPoint == 3) {
            this.ctrlPointTo = point;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Control point updated. Type: " + endPoint + "\n"));
            if (point != null) {
                logger.debug((Object)("Value x: " + point.x));
                logger.debug((Object)("Value y: " + point.y));
            } else {
                logger.debug((Object)"Values are NULL! ");
            }
        }
        this.fireControlPointMoved(endPoint, point);
    }

    public void fireControlPointMoved(int endPoint, Point location) {
        DraggebleRelationEvent anEvent = new DraggebleRelationEvent(this, this.fromComponent, this.toComponent, endPoint, location);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DraggebleRelationListener aListener = (DraggebleRelationListener)aList.get(i);
            aListener.controlPointMoved(anEvent);
            ++i;
        }
    }

    public void addDiagramRelationListener(DiagramRelationListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
        }
    }

    public void removeDiagramRelationListener(DiagramRelationListener l) {
        if (this.listenerList.contains(l)) {
            ((AbstractCollection)this.listenerList).remove(l);
        }
    }

    public Object getStyleOption(String option) {
        if (option.equals("Cubic")) {
            return this.wantCubicLine;
        }
        if (option == "ArrowHalfway") {
            return this.wantArrowHalfway;
        }
        return null;
    }

    public void setStyleOption(String option, Object value) {
        if (option.equalsIgnoreCase("Cubic")) {
            if (value != null && value instanceof Boolean) {
                this.wantCubicLine = (Boolean)value;
            }
        } else if (option.equalsIgnoreCase("ArrowHalfway") && value != null && value instanceof Boolean) {
            this.wantArrowHalfway = (Boolean)value;
        }
    }
}

