/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DefaultDiagramModel;
import com.syllogic.jfc.diagram.DiagramModel;
import com.syllogic.jfc.diagram.MoveDragHandler;
import com.syllogic.jfc.diagram.SelectionClickHandler;
import com.syllogic.jfc.diagram.SelectionDragHandler;
import com.syllogic.miningmart.concepteditor.diagram.ConceptRenderer;
import com.syllogic.miningmart.concepteditor.diagram.DiagramComponentHandler;
import com.syllogic.miningmart.concepteditor.diagram.DiagramDisplayHandler;
import com.syllogic.miningmart.concepteditor.diagram.DiagramHandler;
import com.syllogic.miningmart.concepteditor.diagram.DraggebleRelationHandler;
import com.syllogic.miningmart.concepteditor.diagram.RelationDragHandler;
import com.syllogic.miningmart.concepteditor.diagram.RelationshipRenderer;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptDialog;
import com.syllogic.miningmart.concepteditor.dialogs.DataDialog;
import com.syllogic.miningmart.concepteditor.dialogs.DialogManager;
import com.syllogic.miningmart.concepteditor.dialogs.RelationshipDialog;
import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import com.syllogic.miningmart.concepteditor.dialogs.StatisticsDialog;
import com.syllogic.miningmart.concepteditor.event.ConceptEvent;
import com.syllogic.miningmart.concepteditor.event.ConceptListener;
import com.syllogic.miningmart.concepteditor.event.RelationshipEvent;
import com.syllogic.miningmart.concepteditor.event.RelationshipListener;
import com.syllogic.miningmart.concepteditor.tree.TreeCellRenderer;
import com.syllogic.miningmart.concepteditor.tree.TreeNodeObject;
import com.syllogic.miningmart.concepteditor.util.ConceptCopier;
import com.syllogic.miningmart.concepteditor.util.Constants;
import com.syllogic.miningmart.concepteditor.util.Resizable;
import edu.udo.miningmart.m4.hciImpl.ConceptImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.M4CompilerInterfaceError;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.M4Interface;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ConceptEditor
extends JInternalFrame
implements ActionListener,
ConceptListener,
RelationshipListener {
    private DialogManager dialogManager;
    private Frame parentFrame;
    private ArrayList conListenerList = new ArrayList();
    private ArrayList relListenerList = new ArrayList();
    private M4Interface m4Interface;
    private Case currentCase;
    private Collection allConcepts;
    private Collection allRelationships = new ArrayList();
    private static Logger logger = Logger.getLogger((String)"ConceptEditor");
    private JSplitPane splitPane = new JSplitPane();
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode;
    private DefaultMutableTreeNode currentTreeNode;
    private DefaultMutableTreeNode conceptsNode;
    private DefaultMutableTreeNode relationshipsNode;
    private DefaultMutableTreeNode projectionsNode;
    private DefaultMutableTreeNode is_a_treeNode;
    private Map is_aTreeNodes = new HashMap();
    private Map projectionTreeNodes = new HashMap();
    private Map relationshipTreeNodes = new HashMap();
    private TreeCellRenderer treeCellRenderer;
    private JScrollPane treeScrollPane = new JScrollPane();
    private JScrollPane diagramScrollPane = new JScrollPane();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem newConceptMenuItem = new JMenuItem();
    private JMenuItem copyConceptsMenuItem = new JMenuItem();
    private JMenuItem newRelationshipMenuItem = new JMenuItem();
    private JMenuItem closeMenuItem = new JMenuItem();
    private JMenu selectionMenu = new JMenu();
    private JMenuItem propertiesMenuItem = new JMenuItem();
    private JMenuItem newSubConceptMenuItem = new JMenuItem();
    private JMenuItem newSubRelationshipMenuItem = new JMenuItem();
    private JMenuItem updateStatisticsMenuItem = new JMenuItem();
    private JMenuItem showDataMenuItem = new JMenuItem();
    private JMenuItem showStatisticsMenuItem = new JMenuItem();
    private JMenuItem deleteMenuItem = new JMenuItem();
    private JMenu viewMenu = new JMenu();
    private JMenuItem refreshMenuItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuItem = new JMenuItem();
    private Diagram diagram;
    private DefaultDiagramModel defaultDiagramModel;
    private DiagramDisplayHandler diagramDisplayHandler;
    private RelationshipRenderer relationshipRenderer;
    private ConceptRenderer conceptRenderer;
    private SelectionDragHandler selectionDragHandler;
    private RelationDragHandler relationDragHandler;
    private MoveDragHandler moveDragHandler;
    private SelectionClickHandler selectionClickHandler;
    private DiagramHandler diagramHandler;
    private DiagramComponentHandler diagramComponentHandler = new DiagramComponentHandler(this);
    private DraggebleRelationHandler draggebleRelationHandler = new DraggebleRelationHandler(this);
    static final String helpsetName = "help/MiningMartHelp.hs";
    static final String helpsetLabel = "MiningMart - Help";
    static HelpSet mainHS = null;
    static HelpBroker mainHB;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConceptEditor() {
        super("Concept Editor", true, true, true, true);
        this.initLogger();
        this.initGUI();
    }

    public ConceptEditor(Frame parentFrame) {
        super("Concept Editor", true, true, true, true);
        this.initLogger();
        this.setParent(parentFrame);
        this.initGUI();
    }

    public ConceptEditor(M4Interface m4Interface) {
        super("Concept Editor", true, true, true, true);
        this.initLogger();
        this.setInterface(m4Interface);
        this.initGUI();
    }

    public ConceptEditor(Frame parentFrame, M4Interface m4Interface) {
        super("Concept Editor", true, true, true, true);
        this.initLogger();
        this.setInterface(m4Interface);
        this.setParent(parentFrame);
        this.initGUI();
    }

    public void setInterface(M4Interface m4Interface) {
        this.m4Interface = m4Interface;
    }

    public void init() {
        Relationship aRelationship;
        Concept aConcept;
        Concept aConcept2;
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Init method invoked");
        }
        if (!(this.is_a_treeNode.isLeaf() && this.projectionsNode.isLeaf() && this.relationshipsNode.isLeaf())) {
            this.clearTree();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Tree cleared");
            }
        }
        this.currentCase = M4Interface.getCurrentCase();
        if (this.currentCase == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No currentCase available");
            }
            return;
        }
        this.allConcepts = this.currentCase.getAllConcepts();
        Collections.sort((List)this.allConcepts);
        if (logger.isDebugEnabled()) {
            if (this.allConcepts.isEmpty()) {
                logger.debug((Object)"No concepts found for this case");
            } else {
                logger.debug((Object)(String.valueOf(this.allConcepts.size()) + " Concepts found for this case"));
            }
        }
        this.allRelationships.clear();
        Iterator i = this.allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept3 = (Concept)i.next();
            Collection hasRelationships = aConcept3.getAllFromConceptRelationships();
            Iterator j = hasRelationships.iterator();
            if (logger.isDebugEnabled() && hasRelationships.size() > 0) {
                logger.debug((Object)("Concept " + aConcept3.getName() + " has " + hasRelationships.size() + " relationships"));
            }
            while (j.hasNext()) {
                this.allRelationships.add(j.next());
            }
        }
        Collections.sort((List)this.allRelationships);
        if (logger.isDebugEnabled()) {
            if (this.allRelationships.isEmpty()) {
                logger.debug((Object)"No relationships found for this case");
            } else {
                logger.debug((Object)(String.valueOf(this.allRelationships.size()) + " Relationships found for this case"));
            }
        }
        Collection rootConcepts = this.getRootConcepts();
        if (logger.isDebugEnabled()) {
            if (rootConcepts.isEmpty()) {
                logger.debug((Object)"No root concepts found for this case");
            } else {
                logger.debug((Object)"Root concepts found for this case");
            }
        }
        i = rootConcepts.iterator();
        while (i.hasNext()) {
            aConcept2 = (Concept)i.next();
            DefaultMutableTreeNode aNode = this.addTreeNode(this.is_a_treeNode, new TreeNodeObject(aConcept2), true);
            this.is_aTreeNodes.put(aConcept2, aNode);
        }
        i = rootConcepts.iterator();
        while (i.hasNext()) {
            aConcept2 = (Concept)i.next();
            Collection subConcepts = aConcept2.getAllSubConcepts();
            Collections.sort((List)subConcepts);
            Iterator j = subConcepts.iterator();
            while (j.hasNext()) {
                Concept aSubConcept = (Concept)j.next();
                this.addSubConceptToTree(aConcept2, aSubConcept);
            }
        }
        Collection rootProjections = this.getRootProjections();
        if (logger.isDebugEnabled()) {
            if (rootProjections.isEmpty()) {
                logger.debug((Object)"No root projections found for this case");
            } else {
                logger.debug((Object)"Root projections found for this case");
            }
        }
        i = rootProjections.iterator();
        while (i.hasNext()) {
            aConcept = (Concept)i.next();
            DefaultMutableTreeNode aNode = this.addTreeNode(this.projectionsNode, new TreeNodeObject(aConcept), true);
            this.projectionTreeNodes.put(aConcept, aNode);
        }
        i = rootProjections.iterator();
        while (i.hasNext()) {
            aConcept = (Concept)i.next();
            Collection toProjections = aConcept.getAllToProjections();
            Iterator j = toProjections.iterator();
            while (j.hasNext()) {
                Concept aToProjection = (Concept)j.next();
                this.addToProjectionToTree(aConcept, aToProjection);
            }
        }
        Collection rootRelationships = this.getRootRelationships();
        if (logger.isDebugEnabled()) {
            if (rootRelationships.isEmpty()) {
                logger.debug((Object)"No root relationships found for this case");
            } else {
                logger.debug((Object)"Root relationships found for this case");
            }
        }
        i = rootRelationships.iterator();
        while (i.hasNext()) {
            aRelationship = (Relationship)i.next();
            DefaultMutableTreeNode aNode = this.addTreeNode(this.relationshipsNode, new TreeNodeObject(aRelationship), true);
            this.relationshipTreeNodes.put(aRelationship, aNode);
        }
        i = rootRelationships.iterator();
        while (i.hasNext()) {
            aRelationship = (Relationship)i.next();
            Collection subRelationships = aRelationship.getAllSubRelationships();
            Collections.sort((List)subRelationships);
            Iterator j = subRelationships.iterator();
            while (j.hasNext()) {
                Relationship aSubRelationship = (Relationship)j.next();
                this.addSubRelationshipToTree(aRelationship, aSubRelationship);
            }
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    public void refresh() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Refresh method invoked...");
        }
        this.init();
    }

    private void initGUI() {
        this.dialogManager = new DialogManager(this.parentFrame);
        this.initDiagram();
        this.initTree();
        this.dialogManager.setDiagramDisplayHandler(this.diagramDisplayHandler);
        this.diagram.setPreferredSize(new Dimension(3000, 3000));
        this.diagramScrollPane.getViewport().add(this.diagram);
        this.tree.setPreferredSize(new Dimension(250, 3000));
        this.treeScrollPane.getViewport().add(this.tree);
        this.treeScrollPane.setMinimumSize(new Dimension(200, 200));
        this.diagramScrollPane.setHorizontalScrollBarPolicy(32);
        this.diagramScrollPane.setVerticalScrollBarPolicy(22);
        this.splitPane.add((Component)this.treeScrollPane, "left");
        this.splitPane.add((Component)this.diagramScrollPane, "right");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.setBounds(new Rectangle(10, 10, 700, 500));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"GUI initialized");
        }
    }

    private void initDiagram() {
        this.diagram = new Diagram();
        this.diagram.setBackground(Constants.LIGHT_GREY);
        this.defaultDiagramModel = new DefaultDiagramModel();
        this.diagram.setModel(this.defaultDiagramModel);
        this.diagram.setViewport(this.diagramScrollPane.getViewport());
        this.conceptRenderer = new ConceptRenderer();
        this.relationshipRenderer = new RelationshipRenderer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.syllogic.miningmart.concepteditor.diagram.ConceptComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.diagram.setComponentRenderer(clazz, this.conceptRenderer);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.syllogic.miningmart.concepteditor.diagram.RelationshipComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.diagram.setRelationRenderer(clazz2, this.relationshipRenderer);
        this.selectionDragHandler = new SelectionDragHandler();
        this.relationDragHandler = new RelationDragHandler();
        this.moveDragHandler = new MoveDragHandler();
        this.selectionClickHandler = new SelectionClickHandler();
        this.diagramDisplayHandler = new DiagramDisplayHandler(this);
        this.diagramHandler = new DiagramHandler(this, this.diagram);
        this.diagramComponentHandler.setDiagram(this.diagram);
        this.diagramComponentHandler.setConceptRenderer(this.conceptRenderer);
        this.diagramComponentHandler.setDiagramDisplayHandler(this.diagramDisplayHandler);
        this.addConceptListener(this.diagramDisplayHandler);
        this.addRelationshipListener(this.diagramDisplayHandler);
        this.addDiagramHandlers();
        this.draggebleRelationHandler.setDiagram(this.diagram);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public DiagramModel getDiagramModel() {
        return this.defaultDiagramModel;
    }

    public DiagramDisplayHandler getDiagramDisplayHandler() {
        return this.diagramDisplayHandler;
    }

    public ConceptRenderer getConceptRenderer() {
        return this.conceptRenderer;
    }

    public DiagramComponentHandler getDiagramComponentHandler() {
        return this.diagramComponentHandler;
    }

    public DraggebleRelationHandler getDraggebleRelationHandler() {
        return this.draggebleRelationHandler;
    }

    private void addDiagramHandlers() {
        this.diagram.addDragHandler(this.relationDragHandler);
        this.diagram.addDragHandler(this.selectionDragHandler);
        this.diagram.addDragHandler(this.moveDragHandler);
        this.diagram.addClickHandler(this.selectionClickHandler);
        this.diagram.addClickHandler(this.diagramHandler);
    }

    private void removeAllDiagramHandlers() {
        this.diagram.removeDragHandler(this.selectionDragHandler);
        this.diagram.removeDragHandler(this.relationDragHandler);
        this.diagram.removeDragHandler(this.moveDragHandler);
        this.diagram.removeClickHandler(this.selectionClickHandler);
        this.diagram.removeClickHandler(this.diagramHandler);
    }

    public void setWaitCursor() {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    public void refreshView() {
        this.revalidate();
        this.repaint();
    }

    private void setDiagramComponentsDefaultSize(DefaultDiagramModel model, boolean value) {
        Iterator i = model.getComponents();
        while (i.hasNext()) {
            Resizable aComp = (Resizable)i.next();
            aComp.setUseSize(value);
        }
    }

    private void initLogger() {
        PropertyConfigurator.configure((String)"log4j.properties");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Logger initialized");
        }
    }

    private void initHelpSet() {
        System.out.println("creating mainHB...");
        try {
            URL url = HelpSet.findHelpSet(null, (String)helpsetName);
            mainHS = new HelpSet(null, url);
        }
        catch (Exception ee) {
            System.out.println("Help Set help/MiningMartHelp.hs not found");
            ee.printStackTrace();
            return;
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        HelpBroker hb = mainHS.createHelpBroker();
        ConceptEditor.setHelpBroker(hb);
        System.out.println(" done!");
    }

    public static void setHelpBroker(HelpBroker hb) {
        mainHB = hb;
    }

    public static HelpBroker getHelpBroker() {
        return mainHB;
    }

    private void initTree() {
        this.rootNode = new DefaultMutableTreeNode("Root");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.setAsksAllowsChildren(true);
        this.addTreeBaseNodes();
        this.tree = new JTree(this.treeModel);
        this.tree.addMouseListener(new MyMouseListener());
        this.treeCellRenderer = new TreeCellRenderer();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.tree.setRootVisible(false);
        this.tree.setSelectionPath(new TreePath(this.conceptsNode.getPath()));
        this.tree.setCellRenderer(this.treeCellRenderer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Tree initialized");
        }
    }

    private void addTreeBaseNodes() {
        this.conceptsNode = this.addTreeNode(null, "Concepts", false);
        this.is_a_treeNode = this.addTreeNode(this.conceptsNode, "'Is_a'-tree", false);
        this.is_a_treeNode.setAllowsChildren(true);
        this.projectionsNode = this.addTreeNode(this.conceptsNode, "Projections", false);
        this.projectionsNode.setAllowsChildren(true);
        this.relationshipsNode = this.addTreeNode(null, "Relationships", false);
        this.relationshipsNode.setAllowsChildren(true);
    }

    private void clearTree() {
        this.is_a_treeNode.removeAllChildren();
        this.projectionsNode.removeAllChildren();
        this.relationshipsNode.removeAllChildren();
        this.treeModel.reload();
    }

    private Collection getRootConcepts() {
        ArrayList<Concept> rootConcepts = new ArrayList<Concept>();
        Iterator i = this.allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept = (Concept)i.next();
            Concept superConcept = aConcept.getSuperConcept();
            if (superConcept != null) continue;
            rootConcepts.add(aConcept);
        }
        return rootConcepts;
    }

    private Collection getRootProjections() {
        ArrayList<Concept> rootProjections = new ArrayList<Concept>();
        Iterator i = this.allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept = (Concept)i.next();
            Concept isProjectedFrom = aConcept.getFromProjection();
            Collection hasProjections = aConcept.getAllToProjections();
            if (hasProjections.isEmpty() || isProjectedFrom != null) continue;
            rootProjections.add(aConcept);
        }
        return rootProjections;
    }

    private Collection getRootRelationships() {
        ArrayList<Relationship> rootRelationships = new ArrayList<Relationship>();
        Iterator i = this.allRelationships.iterator();
        while (i.hasNext()) {
            Relationship aRelationship = (Relationship)i.next();
            Relationship superRelationship = aRelationship.getSuperRelationship();
            if (superRelationship == null) {
                rootRelationships.add(aRelationship);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Super relationship is null");
                continue;
            }
            logger.debug((Object)("Super relationship is not null" + superRelationship));
        }
        return rootRelationships;
    }

    private void unfoldTreeToFirstLevel() {
        this.tree.scrollPathToVisible(new TreePath(this.is_a_treeNode.getPath()));
        this.tree.scrollPathToVisible(new TreePath(this.projectionsNode.getPath()));
        this.tree.scrollPathToVisible(new TreePath(this.relationshipsNode.getPath()));
    }

    private DefaultMutableTreeNode addTreeNode(DefaultMutableTreeNode parent, Object child, boolean setVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (setVisible) {
            this.tree.makeVisible(new TreePath(childNode.getPath()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TreeNode added: " + child));
        }
        return childNode;
    }

    private void addSubConceptToTree(Concept parent, Concept subConcept) {
        DefaultMutableTreeNode aNode = this.addTreeNode((DefaultMutableTreeNode)this.is_aTreeNodes.get(parent), new TreeNodeObject(subConcept), false);
        this.is_aTreeNodes.put(subConcept, aNode);
        Collection subCons = subConcept.getAllSubConcepts();
        Iterator i = subCons.iterator();
        while (i.hasNext()) {
            Concept aSubConcept = (Concept)i.next();
            this.addSubConceptToTree(subConcept, aSubConcept);
        }
    }

    private void addToProjectionToTree(Concept parent, Concept toProjection) {
        DefaultMutableTreeNode aNode = this.addTreeNode((DefaultMutableTreeNode)this.projectionTreeNodes.get(parent), new TreeNodeObject(toProjection), false);
        this.projectionTreeNodes.put(toProjection, aNode);
        Collection toProjs = toProjection.getAllToProjections();
        Iterator i = toProjs.iterator();
        while (i.hasNext()) {
            Concept aToProjection = (Concept)i.next();
            this.addToProjectionToTree(toProjection, aToProjection);
        }
    }

    private void addSubRelationshipToTree(Relationship parent, Relationship subRelationship) {
        DefaultMutableTreeNode aNode = this.addTreeNode((DefaultMutableTreeNode)this.relationshipTreeNodes.get(parent), new TreeNodeObject(subRelationship), false);
        this.relationshipTreeNodes.put(subRelationship, aNode);
        Collection subRels = subRelationship.getAllSubRelationships();
        Iterator i = subRels.iterator();
        while (i.hasNext()) {
            Relationship aSubRelationship = (Relationship)i.next();
            this.addSubRelationshipToTree(subRelationship, aSubRelationship);
        }
    }

    public void addPropertyChangeListenerToTree(PropertyChangeListener listener) {
        this.tree.addPropertyChangeListener(listener);
    }

    private void initMenuBar() {
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.selectionMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(this.newConceptMenuItem);
        this.fileMenu.add(this.newRelationshipMenuItem);
        this.fileMenu.add(this.copyConceptsMenuItem);
        this.fileMenu.add(this.closeMenuItem);
        this.selectionMenu.setText("Selection");
        this.selectionMenu.setMnemonic('S');
        this.selectionMenu.add(this.propertiesMenuItem);
        this.selectionMenu.add(this.newSubConceptMenuItem);
        this.selectionMenu.add(this.newSubRelationshipMenuItem);
        this.selectionMenu.add(this.updateStatisticsMenuItem);
        this.selectionMenu.add(this.showDataMenuItem);
        this.selectionMenu.add(this.showStatisticsMenuItem);
        this.selectionMenu.add(this.deleteMenuItem);
        this.viewMenu.setText("View");
        this.viewMenu.setMnemonic('V');
        this.viewMenu.add(this.refreshMenuItem);
        this.helpMenu.setText("Help");
        this.helpMenu.setMnemonic('H');
        this.helpMenu.add(this.helpMenuItem);
        this.newConceptMenuItem.setText("New Concept...");
        this.newConceptMenuItem.setMnemonic('C');
        this.newConceptMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.newConceptMenuItem.addActionListener(this);
        this.newRelationshipMenuItem.setText("New Relationship...");
        this.newRelationshipMenuItem.setMnemonic('R');
        this.newRelationshipMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.newRelationshipMenuItem.addActionListener(this);
        this.copyConceptsMenuItem.setText("Copy Concepts from Case...");
        this.copyConceptsMenuItem.setMnemonic('O');
        this.copyConceptsMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.copyConceptsMenuItem.addActionListener(this);
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setMnemonic('l');
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeMenuItem.addActionListener(this);
        this.propertiesMenuItem.setText("Properties");
        this.propertiesMenuItem.setMnemonic('P');
        this.propertiesMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.propertiesMenuItem.addActionListener(this);
        this.newSubConceptMenuItem.setText("New sub Concept...");
        this.newSubConceptMenuItem.setMnemonic('C');
        this.newSubConceptMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.newSubConceptMenuItem.addActionListener(this);
        this.newSubRelationshipMenuItem.setText("New sub Relationship...");
        this.newSubRelationshipMenuItem.setMnemonic('R');
        this.newSubRelationshipMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.newSubRelationshipMenuItem.addActionListener(this);
        this.updateStatisticsMenuItem.setEnabled(true);
        this.updateStatisticsMenuItem.setText("Update statistics...");
        this.updateStatisticsMenuItem.setMnemonic('U');
        this.updateStatisticsMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.updateStatisticsMenuItem.addActionListener(this);
        this.showDataMenuItem.setEnabled(true);
        this.showDataMenuItem.setText("Show data");
        this.showDataMenuItem.setMnemonic('d');
        this.showDataMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.showDataMenuItem.addActionListener(this);
        this.showStatisticsMenuItem.setEnabled(true);
        this.showStatisticsMenuItem.setText("Show statistics...");
        this.showStatisticsMenuItem.setMnemonic('t');
        this.showStatisticsMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.showStatisticsMenuItem.addActionListener(this);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.setMnemonic('e');
        this.deleteMenuItem.addActionListener(this);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.setMnemonic('R');
        this.refreshMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 8));
        this.refreshMenuItem.addActionListener(this);
        this.helpMenuItem.setText(helpsetLabel);
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 8));
        if (mainHB != null) {
            this.helpMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(mainHB));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MenuBar initialized");
        }
    }

    private void handleEvents(Object o) {
        if (o == this.newConceptMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New Concept accessed");
            }
            this.doNewConcept();
        } else if (o == this.copyConceptsMenuItem) {
            this.doCopyConcepts();
        } else if (o == this.newRelationshipMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New Relationship accessed");
            }
            this.doNewRelationship();
        } else if (o == this.closeMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Close accessed");
            }
            this.doClose();
        } else if (o == this.newSubConceptMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New sub Concept accessed");
            }
            this.doNewSubConcept();
        } else if (o == this.newSubRelationshipMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New sub Relationship accessed");
            }
            this.doNewSubRelationship();
        } else if (o == this.propertiesMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Properties accessed");
            }
            this.doShowProperties();
        } else if (o == this.updateStatisticsMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Update statistics accessed");
            }
            this.doUpdateStatistics();
        } else if (o == this.showDataMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show data accessed");
            }
            this.doShowData();
        } else if (o == this.showStatisticsMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show statistics accessed");
            }
            this.doShowStatistics();
        } else if (o == this.deleteMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete accessed");
            }
            this.doDelete();
        } else if (o == this.refreshMenuItem) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Refresh accessed");
            }
            this.refresh();
        }
    }

    public void doNewConcept() {
        ConceptDialog aDialog = this.dialogManager.showConceptDialog(null, this);
    }

    public void doCopyConcepts() {
        this.currentCase = M4Interface.getCurrentCase();
        if (this.currentCase == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No currentCase available");
            }
            return;
        }
        logger.info((Object)("Case to copy to: " + this.currentCase.getName()));
        Collection allCaseNames = this.m4Interface.getAllCaseNames();
        SelectUtility select = new SelectUtility();
        String aCaseName = (String)select.selectObject(this.parentFrame, "CaseName", allCaseNames);
        if (aCaseName == null) {
            return;
        }
        Case aCase = null;
        try {
            aCase = this.m4Interface.findCaseForReadOnlyAccess(aCaseName, false);
            if (aCase == null) {
                String message = "Case " + aCaseName + " not found!";
                logger.error((Object)message);
                JOptionPane.showMessageDialog(this, message, "Error...", 2);
                return;
            }
            logger.info((Object)("Case found: " + aCase.getName()));
        }
        catch (M4Interface.CaseLockedException e) {
            String message = "Case locked! Unlock case first.";
            logger.error((Object)message);
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return;
        }
        logger.info((Object)("Case to be copied: " + aCase.getName()));
        Collection allConcepts = aCase.getAllConcepts();
        Collection selectedConcepts = select.selectObjects(this.parentFrame, "Concept", allConcepts);
        if (selectedConcepts == null) {
            this.m4Interface.releaseCase(aCaseName);
            return;
        }
        ConceptCopier.copyConcepts(selectedConcepts, this.currentCase);
        this.m4Interface.releaseCase(aCaseName);
        this.refresh();
    }

    public void doNewRelationship() {
        RelationshipDialog aDialog = this.dialogManager.showRelationshipDialog(null, this);
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void doNewSubConcept() {
        Object object = this.getSelectedObject();
        if (object instanceof Concept) {
            Concept superConcept = (Concept)object;
            ConceptDialog conceptDialog = this.dialogManager.showNewSubConceptDialog(superConcept, this);
        }
    }

    public void doNewSubRelationship() {
        Object object = this.getSelectedObject();
        if (object instanceof Relationship) {
            Relationship superRelationship = (Relationship)object;
            RelationshipDialog relationshipDialog = this.dialogManager.showNewSubRelationshipDialog(superRelationship, this);
        }
    }

    public void doShowProperties() {
        Object select = this.getSelectedObject();
        this.doShowProperties(select);
    }

    public void doShowProperties(Object object) {
        if (object instanceof Concept) {
            Concept aConcept = (Concept)object;
            ConceptDialog aDialog = this.dialogManager.showConceptDialog(aConcept, this);
        } else if (object instanceof Relationship) {
            Relationship aRelationship = (Relationship)object;
            RelationshipDialog aDialog = this.dialogManager.showRelationshipDialog(aRelationship, this);
        } else if (object instanceof BaseAttribute) {
            BaseAttribute aBaseAttribute = (BaseAttribute)object;
            this.dialogManager.showBaseAttributeDialog(null, aBaseAttribute);
        } else if (object instanceof MultiColumnFeature) {
            MultiColumnFeature aMultiColumnFeature = (MultiColumnFeature)object;
            this.dialogManager.showMultiColumnFeatureDialog(null, aMultiColumnFeature);
        }
        this.refreshView();
    }

    public void doUpdateStatistics() {
        Object object = this.getSelectedObject();
        if (object instanceof Concept) {
            Concept concept = (Concept)object;
            CompilerAccess currentCompilerAccess = M4Interface.getCurrentCompilerAccess();
            if (currentCompilerAccess == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No currentCompilerAccess available!");
                }
                return;
            }
            logger.info((Object)"CompilerAccess found!");
            try {
                currentCompilerAccess.updateStatisticsForConcept(((ConceptImpl)concept).getId());
            }
            catch (M4CompilerInterfaceError e) {
                logger.warn((Object)"M4CompilerInterfaceError failure", (Throwable)e);
            }
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
            }
        }
    }

    public void doShowMasterDetailView() {
    }

    public void doShowData() {
        Object object = this.getSelectedObject();
        if (object instanceof Concept) {
            Concept concept = (Concept)object;
            Collection allColumnSets = concept.getAllColumnSets();
            if (allColumnSets.size() == 0) {
                logger.info((Object)"No columnSet found to show data from.");
                String message = "No columnSet found to show data from.";
                JOptionPane.showMessageDialog(this, message, "Error...", 2);
            } else {
                ColumnSet columnSet = null;
                if (allColumnSets.size() == 1) {
                    columnSet = (ColumnSet)allColumnSets.toArray()[0];
                } else {
                    SelectUtility select = new SelectUtility();
                    columnSet = (ColumnSet)select.selectObject(this.parentFrame, "ColumnSet", allColumnSets);
                }
                if (columnSet != null) {
                    DataDialog dataDialog = this.dialogManager.showDataDialog(columnSet);
                }
            }
        }
    }

    public void doShowStatistics() {
        Object object = this.getSelectedObject();
        if (object instanceof Concept) {
            Concept concept = (Concept)object;
            Collection allColumnSets = concept.getAllColumnSets();
            if (allColumnSets.size() == 0) {
                logger.info((Object)"No columnSet found to show statistics from.");
                String message = "No columnSet found to show statistics from.";
                JOptionPane.showMessageDialog(this, message, "Error...", 2);
            } else {
                ColumnSet columnSet = null;
                if (allColumnSets.size() == 1) {
                    columnSet = (ColumnSet)allColumnSets.toArray()[0];
                } else {
                    SelectUtility select = new SelectUtility();
                    columnSet = (ColumnSet)select.selectObject(this.parentFrame, "ColumnSet", allColumnSets);
                }
                if (columnSet != null) {
                    StatisticsDialog statisticsDialog = this.dialogManager.showStatisticsDialog(columnSet);
                }
            }
        }
    }

    public void doDelete() {
        Object select = this.getSelectedObject();
        if (select instanceof Concept) {
            Concept aConcept = (Concept)select;
            String message = "Are you sure you want to delete Concept: " + aConcept.getName() + "?";
            int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
            if (choice != 0) {
                return;
            }
            Concept aSuperConcept = aConcept.getSuperConcept();
            Collection subConcepts = aConcept.getAllSubConcepts();
            Iterator i = subConcepts.iterator();
            while (i.hasNext()) {
                Concept aSubConcept = (Concept)i.next();
                try {
                    aSubConcept.setSuperConcept(aSuperConcept);
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super Concept...", (Throwable)e);
                }
            }
            try {
                aConcept.delete();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not delete Concept record.", (Throwable)e);
                message = "A data communication error occurred!\nCould not delete the Concept.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.fireConceptDeleted(aConcept);
            this.refresh();
        } else if (select instanceof Relationship) {
            Relationship aRelationship = (Relationship)select;
            String message = "Are you sure you want to delete Relationship: " + aRelationship.getName() + "?";
            int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
            if (choice != 0) {
                return;
            }
            Relationship aSuperRelationship = aRelationship.getSuperRelationship();
            Collection subRelationships = aRelationship.getAllSubRelationships();
            Iterator i = subRelationships.iterator();
            while (i.hasNext()) {
                Relationship aSubRelationship = (Relationship)i.next();
                try {
                    aSubRelationship.setSuperRelationship(aSuperRelationship);
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super Relationship...", (Throwable)e);
                }
            }
            try {
                aRelationship.delete();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not delete Relationship record.", (Throwable)e);
                message = "A data communication error occurred!\nCould not delete the Relationship.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.fireRelationshipDeleted(aRelationship);
            this.refresh();
        }
    }

    public void fireConceptDeleted(Concept concept) {
        ConceptEvent anEvent = new ConceptEvent(this, concept);
        ArrayList aList = (ArrayList)this.conListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            ConceptListener aListener = (ConceptListener)aList.get(i);
            aListener.conceptDeleted(anEvent);
            ++i;
        }
    }

    public void fireRelationshipDeleted(Relationship relationship) {
        RelationshipEvent anEvent = new RelationshipEvent(this, relationship);
        ArrayList aList = (ArrayList)this.relListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            RelationshipListener aListener = (RelationshipListener)aList.get(i);
            aListener.relationshipDeleted(anEvent);
            ++i;
        }
    }

    public Object getSelectedObject() {
        Object nodeObject = this.currentTreeNode.getUserObject();
        if (nodeObject instanceof TreeNodeObject) {
            return ((TreeNodeObject)nodeObject).getObject();
        }
        return nodeObject;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(o);
    }

    public void conceptChanged(ConceptEvent e) {
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.is_aTreeNodes.get(e.getConcept());
        if (e.isNameChanged() || e.isTypeChanged() || e.isValidityChanged()) {
            aNode.setUserObject(new TreeNodeObject(e.getConcept()));
        }
        if (e.isSuperConceptChanged() || e.isProjectionChanged()) {
            this.refresh();
        }
    }

    public void conceptCreated(ConceptEvent e) {
        Concept aConcept = e.getConcept();
        Concept aSuperConcept = aConcept.getSuperConcept();
        Concept aFromProjection = aConcept.getFromProjection();
        if (aSuperConcept == null) {
            DefaultMutableTreeNode aNode = this.addTreeNode(this.is_a_treeNode, new TreeNodeObject(aConcept), true);
            this.is_aTreeNodes.put(aConcept, aNode);
        } else {
            this.addSubConceptToTree(aSuperConcept, aConcept);
        }
        if (aFromProjection != null) {
            this.addToProjectionToTree(aFromProjection, aConcept);
        }
    }

    public void conceptDeleted(ConceptEvent e) {
    }

    public void relationshipChanged(RelationshipEvent e) {
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.relationshipTreeNodes.get(e.getRelationship());
        if (e.isNameChanged() || e.isValidityChanged()) {
            aNode.setUserObject(new TreeNodeObject(e.getRelationship()));
        }
        if (e.isSuperRelationshipChanged()) {
            this.refresh();
        }
    }

    public void relationshipCreated(RelationshipEvent e) {
        Relationship aRelationship = e.getRelationship();
        Relationship aSuperRelationship = aRelationship.getSuperRelationship();
        if (aSuperRelationship == null) {
            DefaultMutableTreeNode aNode = this.addTreeNode(this.relationshipsNode, new TreeNodeObject(aRelationship), true);
            this.relationshipTreeNodes.put(aRelationship, aNode);
        } else {
            this.addSubRelationshipToTree(aSuperRelationship, aRelationship);
        }
    }

    public void relationshipDeleted(RelationshipEvent e) {
    }

    public void addConceptListener(ConceptListener l) {
        if (!this.conListenerList.contains(l)) {
            this.conListenerList.add(l);
        }
    }

    public void removeConceptListener(ConceptListener l) {
        if (this.conListenerList.contains(l)) {
            ((AbstractCollection)this.conListenerList).remove(l);
        }
    }

    public void addRelationshipListener(RelationshipListener l) {
        if (!this.relListenerList.contains(l)) {
            this.relListenerList.add(l);
        }
    }

    public void removeRelationshipListener(RelationshipListener l) {
        if (this.relListenerList.contains(l)) {
            ((AbstractCollection)this.relListenerList).remove(l);
        }
    }

    private void updateMenuItems() {
        Object select = this.getSelectedObject();
        if (select instanceof Concept) {
            this.selectionMenu.setEnabled(true);
            this.enableConceptMenus(true);
            this.enableRelationshipMenus(false);
        } else if (select instanceof Relationship) {
            this.selectionMenu.setEnabled(true);
            this.enableConceptMenus(false);
            this.enableRelationshipMenus(true);
        } else {
            this.selectionMenu.setEnabled(false);
        }
    }

    private void enableConceptMenus(boolean enable) {
        this.newSubConceptMenuItem.setEnabled(enable);
        this.showDataMenuItem.setEnabled(enable);
        this.showStatisticsMenuItem.setEnabled(enable);
    }

    private void enableRelationshipMenus(boolean enable) {
        this.newSubRelationshipMenuItem.setEnabled(enable);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    private class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.handleMouseClick(e);
        }

        public void mouseReleased(MouseEvent e) {
        }

        private void handleMouseClick(MouseEvent e) {
            int nrOfClicks = e.getClickCount();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Mouse clicked");
                logger.debug((Object)("Nr of clicks:  " + nrOfClicks));
            }
            if (nrOfClicks > 1) {
                ConceptEditor.this.doShowProperties();
            }
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ConceptEditor.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            ConceptEditor.this.currentTreeNode = node;
            Object nodeObject = node.getUserObject();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected nodeObject: " + nodeObject));
            }
            ConceptEditor.this.tree.firePropertyChange("SelectedNode", 0, 0);
            ConceptEditor.this.updateMenuItems();
            ConceptEditor.this.diagramDisplayHandler.updateDiagramView();
        }
    }
}

