/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DragHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DrawRelationDragHandler
implements DragHandler {
    private int MOD_MASK;
    private static final int ALLOWED_MASKS = 47;
    private boolean itsIsDragging = false;
    private Point itsStartPoint;
    private Point itsDragPoint;
    private DiagramComponent itsFromComponent;
    private DiagramComponent itsToComponent;

    public DrawRelationDragHandler() {
        this.MOD_MASK = 2;
    }

    public DrawRelationDragHandler(int theMask) {
        this.MOD_MASK = this.allowedMask(theMask) ? theMask : 2;
    }

    private boolean allowedMask(int theMask) {
        return theMask == 32 || theMask == 8 || theMask == 2 || theMask == 4 || theMask == 1;
    }

    public boolean isDragPoint(Diagram theDiagram, MouseEvent theEvent) {
        return (theEvent.getModifiers() & this.MOD_MASK) != 0 && theDiagram.findComponent(theEvent.getPoint()) != null;
    }

    public boolean isDragging(Diagram theDiagram) {
        return this.itsIsDragging;
    }

    private void cleanup() {
        this.itsIsDragging = false;
        this.itsStartPoint = null;
        this.itsDragPoint = null;
        this.itsFromComponent = null;
        this.itsToComponent = null;
    }

    private void paintRelation(Diagram theDiagram, Graphics2D g2, Point theCurrentPoint) {
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        g2.drawLine(this.itsStartPoint.x, this.itsStartPoint.y, theCurrentPoint.x, theCurrentPoint.y);
    }

    public void dragStart(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        this.itsStartPoint = evt.getPoint();
        this.itsDragPoint = null;
        this.itsIsDragging = true;
        this.itsFromComponent = theDiagram.findComponent(evt.getPoint());
    }

    public void drag(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        if (this.itsDragPoint != null) {
            this.paintRelation(theDiagram, g2, this.itsDragPoint);
        }
        this.itsDragPoint = evt.getPoint();
        this.paintRelation(theDiagram, g2, this.itsDragPoint);
    }

    public void dragEnd(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        if (this.itsDragPoint != null) {
            this.paintRelation(theDiagram, g2, this.itsDragPoint);
        }
        this.itsToComponent = theDiagram.findComponent(evt.getPoint());
        if (this.itsFromComponent != null && this.itsToComponent != null) {
            theDiagram.fireRelationRequested(this.itsFromComponent, this.itsToComponent);
        }
        this.cleanup();
        theDiagram.repaintLater();
    }

    public void dragAbort(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (this.itsDragPoint != null) {
            this.paintRelation(theDiagram, g2, this.itsDragPoint);
        }
        this.cleanup();
    }
}

