/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DiagramModel;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.event.DiagramModelEvent;
import com.syllogic.jfc.event.DiagramModelListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultDiagramModel
implements DiagramModel {
    private ArrayList itsComponents = new ArrayList();
    private ArrayList itsRelations = new ArrayList();
    private ArrayList listenerList = new ArrayList();

    public void addComponent(DiagramComponent theComponent) {
        if (!this.itsComponents.contains(theComponent)) {
            this.itsComponents.add(theComponent);
            this.fireComponentsAdded(theComponent);
        }
    }

    public void removeComponent(DiagramComponent theComponent) {
        if (!this.itsComponents.contains(theComponent)) {
            return;
        }
        Iterator i = ((AbstractList)this.itsRelations).iterator();
        while (i.hasNext()) {
            DiagramRelation aRelation = (DiagramRelation)i.next();
            if (!aRelation.getFromComponent().equals(theComponent) && !aRelation.getToComponent().equals(theComponent)) continue;
            i.remove();
            this.fireRelationsRemoved(aRelation);
        }
        this.itsComponents.remove(this.itsComponents.indexOf(theComponent));
        this.fireComponentsRemoved(theComponent);
    }

    public void clear() {
        if (this.itsComponents.isEmpty()) {
            return;
        }
        int numberOfComponents = this.itsComponents.size();
        DiagramComponent[] aList = new DiagramComponent[numberOfComponents];
        Iterator i = ((AbstractList)this.itsComponents).iterator();
        int index = 0;
        while (i.hasNext()) {
            DiagramComponent aComp;
            aList[index] = aComp = (DiagramComponent)i.next();
            ++index;
        }
        this.itsComponents.clear();
        this.itsRelations.clear();
        this.fireComponentsRemoved(aList);
    }

    public void addRelation(DiagramRelation theRelation) throws IllegalArgumentException {
        DiagramComponent aFromComponent = theRelation.getFromComponent();
        DiagramComponent aToComponent = theRelation.getToComponent();
        if (aFromComponent == null || aToComponent == null || !this.itsComponents.contains(aFromComponent) || !this.itsComponents.contains(aToComponent)) {
            throw new IllegalArgumentException("The To- or From-Component does not exist or is not part of this model");
        }
        if (!this.itsRelations.contains(theRelation)) {
            this.itsRelations.add(theRelation);
            this.fireRelationsAdded(theRelation);
        }
    }

    public void removeRelation(DiagramRelation theRelation) {
        if (!this.itsRelations.contains(theRelation)) {
            return;
        }
        this.itsRelations.remove(this.itsRelations.indexOf(theRelation));
        this.fireRelationsRemoved(theRelation);
    }

    public void clearRelations() {
        if (this.itsRelations.isEmpty()) {
            return;
        }
        int numberOfRelations = this.itsRelations.size();
        DiagramRelation[] aList = new DiagramRelation[numberOfRelations];
        Iterator i = ((AbstractList)this.itsRelations).iterator();
        int index = 0;
        while (i.hasNext()) {
            DiagramRelation aRel;
            aList[index] = aRel = (DiagramRelation)i.next();
            ++index;
        }
        this.itsRelations.clear();
        this.fireRelationsRemoved(aList);
    }

    public Iterator getComponents() {
        return ((AbstractList)this.itsComponents).iterator();
    }

    public Iterator getRelations() {
        return ((AbstractList)this.itsRelations).iterator();
    }

    public int getNumberOfComponents() {
        return this.itsComponents.size();
    }

    public int getNumberOfRelations() {
        return this.itsRelations.size();
    }

    public void addDiagramModelListener(DiagramModelListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
        }
    }

    public void removeDiagramModelListener(DiagramModelListener l) {
        if (this.listenerList.contains(l)) {
            ((AbstractCollection)this.listenerList).remove(l);
        }
    }

    protected void fireComponentsAdded(DiagramComponent[] theComps) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 0, theComps);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsAdded(anEvent);
            ++i;
        }
    }

    protected void fireComponentsAdded(DiagramComponent theComp) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 0, theComp);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsAdded(anEvent);
            ++i;
        }
    }

    protected void fireComponentsRemoved(DiagramComponent[] theComps) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 1, theComps);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsRemoved(anEvent);
            ++i;
        }
    }

    protected void fireComponentsRemoved(DiagramComponent theComp) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 1, theComp);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsRemoved(anEvent);
            ++i;
        }
    }

    protected void fireComponentsChanged(DiagramComponent[] theComps) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 2, theComps);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsChanged(anEvent);
            ++i;
        }
    }

    protected void fireComponentsChanged(DiagramComponent theComp) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 2, theComp);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.componentsChanged(anEvent);
            ++i;
        }
    }

    protected void fireRelationsAdded(DiagramRelation[] theRels) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 3, theRels);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsAdded(anEvent);
            ++i;
        }
    }

    protected void fireRelationsAdded(DiagramRelation theRel) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 3, theRel);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsAdded(anEvent);
            ++i;
        }
    }

    protected void fireRelationsRemoved(DiagramRelation[] theRels) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 4, theRels);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsRemoved(anEvent);
            ++i;
        }
    }

    protected void fireRelationsRemoved(DiagramRelation theRel) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 4, theRel);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsRemoved(anEvent);
            ++i;
        }
    }

    protected void fireRelationsChanged(DiagramRelation[] theRels) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 5, theRels);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsChanged(anEvent);
            ++i;
        }
    }

    protected void fireRelationsChanged(DiagramRelation theRel) {
        DiagramModelEvent anEvent = new DiagramModelEvent((Object)this, 5, theRel);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramModelListener aListener = (DiagramModelListener)aList.get(i);
            aListener.relationsChanged(anEvent);
            ++i;
        }
    }
}

