/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CiCoconInfo;
import cocon.CiConnectable;
import cocon.CiConnectionChangeListener;
import cocon.CiObjectProperties;
import cocon.CoChildConnection;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoConnectionDescriptor;
import cocon.CoObjectDepthFirstEnumeration;
import cocon.util.Position;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.server.UID;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CoObject
implements Cloneable,
Serializable,
CiObjectProperties,
CiConnectable,
CiCoconInfo,
CiConnectionChangeListener,
MutableTreeNode,
PropertyChangeListener {
    long id;
    String name;
    String description;
    String url;
    Date created;
    Date modified;
    UID uid;
    Position position = new Position();
    transient Color backgroundColor;
    transient Color foregroundColor;
    Vector icons;
    Vector pictures;
    protected Object userObject;
    transient Vector inConnections = new Vector();
    transient Vector outConnections = new Vector();
    private transient PropertyChangeSupport changeListeners = new PropertyChangeSupport(this);
    private transient EventListenerList listenerList = new EventListenerList();
    static Class class$cocon$CoConnection;
    static Class class$cocon$CiConnectionChangeListener;
    static Class class$cocon$CoChildConnection;
    static Class class$cocon$CiConnectable;
    static Class class$cocon$CoObject;

    public CoObject() {
        this.initCoObjectProperties();
        this.initCoObject();
    }

    public CoObject(CoObject node) {
        this.setUid();
        this.setCreated();
        this.setModified();
        if (node == null) {
            return;
        }
        this.name = node.name != null ? new String(node.name) : null;
        this.description = node.description != null ? new String(node.description) : null;
        this.url = node.url != null ? new String(node.url) : null;
        this.backgroundColor = node.backgroundColor != null ? new Color(node.backgroundColor.getRGB()) : null;
        this.foregroundColor = node.foregroundColor != null ? new Color(node.foregroundColor.getRGB()) : null;
        this.icons = node.icons != null ? (Vector)node.icons.clone() : null;
        this.pictures = node.pictures != null ? (Vector)node.pictures.clone() : null;
    }

    public CoObject(String name) {
        this.initCoObjectProperties();
        this.setName(name);
        this.initCoObject();
    }

    public CoObject(Object object) {
        this.initCoObjectProperties();
        this.initCoObject();
        this.setUserObject(object);
    }

    public void initCoObject() {
        if (this.getIcons() == null) {
            this.setIcons(new Vector(1));
        }
        this.getIcons().add(0, "coObject.gif");
    }

    public int initCoObjectProperties() {
        this.setUid();
        this.setCreated();
        this.setModified();
        return 0;
    }

    public ImageIcon getImageIcon(int index) {
        URL iconUrl = null;
        if (this.getIcons() == null) {
            return null;
        }
        Object o = this.getIcons().get(index);
        if (o == null) {
            return null;
        }
        String fileName = null;
        if (o instanceof String) {
            fileName = (String)o;
        } else if (o instanceof ImageIcon) {
            return (ImageIcon)o;
        }
        for (Class<?> cl = this.getClass(); cl != null && (iconUrl = cl.getResource(fileName)) == null && (iconUrl = cl.getResource("images/".concat(String.valueOf(String.valueOf(fileName))))) == null && (iconUrl = cl.getResource("/cocon/images/".concat(String.valueOf(String.valueOf(fileName))))) == null && (iconUrl = cl.getResource("/images/".concat(String.valueOf(String.valueOf(fileName))))) == null; cl = cl.getSuperclass()) {
        }
        if (iconUrl != null) {
            return new ImageIcon(iconUrl);
        }
        return null;
    }

    public CoObject getChildAt(String name) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!name.equalsIgnoreCase(((CoObject)this.getChildAt(i)).getName())) continue;
            return (CoObject)this.getChildAt(i);
        }
        return null;
    }

    public CoObject getParent(int depth) {
        TreeNode node;
        for (node = this; depth > 0 && node != null; --depth, node = node.getParent()) {
        }
        return node;
    }

    public Vector getReachableNodes() {
        Vector<CiConnectable> reachableObjects = new Vector<CiConnectable>();
        CiConnectable root = (CiConnectable)((Object)this.getRoot());
        if (root == null) {
            return reachableObjects;
        }
        reachableObjects.add(root);
        int i = 0;
        int j = 1;
        while (j > i) {
            while (j > i) {
                CiConnectable node2;
                int k;
                CiConnectable node = (CiConnectable)reachableObjects.get(i);
                int nodeCount = node.getOutConnectionCount(null);
                for (k = 0; k < nodeCount; ++k) {
                    node2 = (CoObject)node.getOutConnection(null, k).getDestination();
                    if (node2 == null || reachableObjects.contains(node2)) continue;
                    reachableObjects.add(node2);
                }
                nodeCount = node.getInConnectionCount(null);
                for (k = 0; k < nodeCount; ++k) {
                    node2 = node.getInConnection(null, k).getSource();
                    if (node2 == null || reachableObjects.contains(node2)) continue;
                    reachableObjects.add(node2);
                }
                ++i;
            }
            j = reachableObjects.size();
        }
        return reachableObjects;
    }

    public void removeAllInConnections(Class connectionClass) {
        for (int connectionCount = this.getInConnectionCount(connectionClass); connectionCount > 0; --connectionCount) {
            CoConnection connection = this.getInConnection(connectionClass, connectionCount - 1);
            if (connection == null || connection.getSource() == null) continue;
            connection.getSource().removeConnection(connection);
        }
    }

    public void removeAllOutConnections(Class connectionClass) {
        for (int connectionCount = this.getOutConnectionCount(connectionClass); connectionCount > 0; --connectionCount) {
            CoConnection connection = this.getOutConnection(connectionClass, connectionCount - 1);
            this.removeConnection(connection);
        }
    }

    public void moveAllInConnections(Class connectionClass, CiConnectable destination) {
        int connectionCount = this.getInConnectionCount(connectionClass);
        for (int i = 0; i < connectionCount; ++i) {
            CoConnection connection = this.getInConnection(connectionClass, i);
            if (connection == null) continue;
            this.removeInConnection(connection);
            destination.addInConnection(connection);
        }
    }

    public void moveAllOutConnections(Class connectionClass, CiConnectable source) {
        int connectionCount = this.getOutConnectionCount(connectionClass);
        for (int i = 0; i < connectionCount; ++i) {
            CoConnection connection = this.getOutConnection(connectionClass, i);
            if (connection == null) continue;
            this.removeOutConnection(connection);
            source.addOutConnection(connection);
        }
    }

    public void cloneChildren(CoObject node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            CoObject new_child;
            CoObject child = (CoObject)this.getChildAt(i);
            if (child == null || (new_child = (CoObject)child.clone()) == null) continue;
            node.add(new_child);
            child.cloneChildren(new_child);
        }
    }

    public CoObject cloneTree() {
        CoObject node = (CoObject)this.clone();
        if (node == null) {
            return null;
        }
        this.cloneChildren(node);
        return node;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void add(MutableTreeNode newChild) {
        this.insert(newChild, this.getChildCount());
    }

    public TreeNode getRoot() {
        TreeNode node;
        CoObject prevNode = node = this;
        while (node != null) {
            prevNode = node;
            node = node.getParent();
        }
        return prevNode;
    }

    boolean isNodeChild(TreeNode node) {
        return this.getIndex(node) >= 0;
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        for (TreeNode node = this; node != null; node = node.getParent()) {
            if (node != anotherNode) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeDescendant(TreeNode anotherNode) {
        for (TreeNode node = anotherNode; node != null; node = node.getParent()) {
            if (node != this) continue;
            return true;
        }
        return false;
    }

    public Enumeration depthFirstEnumeration() {
        return new CoObjectDepthFirstEnumeration(this);
    }

    public int getOutConnectionCount(Class connectionClass, Class destinationClass) {
        if (destinationClass == null || destinationClass.isAssignableFrom(class$cocon$CiConnectable == null ? (class$cocon$CiConnectable = CoObject.class$("cocon.CiConnectable")) : class$cocon$CiConnectable)) {
            return this.getOutConnectionCount(connectionClass);
        }
        if (connectionClass == null) {
            connectionClass = class$cocon$CoConnection == null ? (class$cocon$CoConnection = CoObject.class$("cocon.CoConnection")) : class$cocon$CoConnection;
        }
        int connectionCount = 0;
        for (int i = 0; i < this.outConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.outConnections.get(i);
            if (!connectionClass.isAssignableFrom(connection.getClass()) || connection.destination == null || connection.destination.getInConnectionIndex(connection) < 0 || !destinationClass.isAssignableFrom(connection.destination.getClass())) continue;
            ++connectionCount;
        }
        return connectionCount;
    }

    public int getInConnectionCount(Class connectionClass, Class sourceClass) {
        if (sourceClass == null || sourceClass.isAssignableFrom(class$cocon$CiConnectable == null ? (class$cocon$CiConnectable = CoObject.class$("cocon.CiConnectable")) : class$cocon$CiConnectable)) {
            return this.getInConnectionCount(connectionClass);
        }
        if (connectionClass == null) {
            connectionClass = class$cocon$CoConnection == null ? (class$cocon$CoConnection = CoObject.class$("cocon.CoConnection")) : class$cocon$CoConnection;
        }
        int connectionCount = 0;
        for (int i = 0; i < this.inConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.inConnections.get(i);
            if (!connectionClass.isAssignableFrom(connection.getClass()) || connection.source == null || connection.source.getOutConnectionIndex(connection) < 0 || !sourceClass.isAssignableFrom(connection.source.getClass())) continue;
            ++connectionCount;
        }
        return connectionCount;
    }

    public void insert(MutableTreeNode child, int index) {
        child.removeFromParent();
        this.insertConnection(new CoChildConnection(), (CiConnectable)((Object)child), index, 0);
    }

    public void remove(int index) {
        CoConnection connection = this.getOutConnection(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection, index);
        if (connection == null) {
            return;
        }
        this.removeConnection(connection);
    }

    public void remove(MutableTreeNode node) {
        CoConnection connection = this.getOutConnection(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection, (CiConnectable)((Object)node));
        if (connection == null) {
            return;
        }
        this.removeConnection(connection);
    }

    public void removeFromParent() {
        this.removeAllInConnections(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection);
    }

    public void setParent(MutableTreeNode newParent) {
        this.removeFromParent();
        ((CiConnectable)((Object)newParent)).addConnection(new CoChildConnection(), this);
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Enumeration children() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        CoConnection connection = this.getOutConnection(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection, childIndex);
        if (connection == null) {
            return null;
        }
        return (TreeNode)((Object)connection.getDestination());
    }

    public int getChildCount() {
        return this.getOutConnectionCount(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection);
    }

    public int getIndex(TreeNode node) {
        CoConnection connection = this.getOutConnection(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection, (CiConnectable)((Object)node));
        if (connection == null) {
            return -1;
        }
        return this.getOutConnectionIndex(connection);
    }

    public TreeNode getParent() {
        CoConnection connection = this.getInConnection(class$cocon$CoChildConnection == null ? (class$cocon$CoChildConnection = CoObject.class$("cocon.CoChildConnection")) : class$cocon$CoChildConnection, 0);
        if (connection == null) {
            return null;
        }
        return (TreeNode)((Object)connection.getSource());
    }

    public boolean isLeaf() {
        return this.getChildCount() <= 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.changeListeners.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.changeListeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.changeListeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeListeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    boolean hasPropertyChangeListeners(String propertyName) {
        return this.changeListeners.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeListeners.removePropertyChangeListener(propertyName, listener);
    }

    public void fireAutoPropertyChange(String propertyName, Object oldValue, Object newValue) {
        Vector reachableObjects = this.getReachableNodes();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = 0; i < reachableObjects.size(); ++i) {
            CiConnectable node = (CiConnectable)reachableObjects.get(i);
            if (!(node instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)((Object)node)).propertyChange(propertyChangeEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void addConnectionChangeListener(CiConnectionChangeListener listener) {
        this.listenerList.add(class$cocon$CiConnectionChangeListener == null ? (class$cocon$CiConnectionChangeListener = CoObject.class$("cocon.CiConnectionChangeListener")) : class$cocon$CiConnectionChangeListener, listener);
    }

    public void removeConnectionChangeListener(CiConnectionChangeListener listener) {
        this.listenerList.remove(class$cocon$CiConnectionChangeListener == null ? (class$cocon$CiConnectionChangeListener = CoObject.class$("cocon.CiConnectionChangeListener")) : class$cocon$CiConnectionChangeListener, listener);
    }

    public void fireConnectionChange(CoConnectionChangeEvent cce) {
        if (cce == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        switch (cce.getAction()) {
            case 1: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).addedInConnection(cce);
                }
                break;
            }
            case 2: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).addedOutConnection(cce);
                }
                break;
            }
            case 3: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).addedConnection(cce);
                }
                break;
            }
            case 4: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).removedInConnection(cce);
                }
                break;
            }
            case 5: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).removedOutConnection(cce);
                }
                break;
            }
            case 6: {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$cocon$CiConnectionChangeListener == null ? CoObject.class$("cocon.CiConnectionChangeListener") : class$cocon$CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)listeners[i + 1]).removedConnection(cce);
                }
                break;
            }
        }
        this.fireAutoConnectionChange(cce);
    }

    public void fireAutoConnectionChange(CoConnectionChangeEvent cce) {
        Vector reachableObjects = this.getReachableNodes();
        switch (cce.getAction()) {
            case 1: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).addedInConnection(cce);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).addedOutConnection(cce);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).addedConnection(cce);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).removedInConnection(cce);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).removedOutConnection(cce);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < reachableObjects.size(); ++i) {
                    CiConnectable node = (CiConnectable)reachableObjects.get(i);
                    if (!(node instanceof CiConnectionChangeListener)) continue;
                    ((CiConnectionChangeListener)((Object)node)).removedConnection(cce);
                }
                break;
            }
        }
    }

    public void addedInConnection(CoConnectionChangeEvent cce) {
    }

    public void addedOutConnection(CoConnectionChangeEvent cce) {
    }

    public void addedConnection(CoConnectionChangeEvent cce) {
    }

    public void removedInConnection(CoConnectionChangeEvent cce) {
    }

    public void removedOutConnection(CoConnectionChangeEvent cce) {
    }

    public void removedConnection(CoConnectionChangeEvent cce) {
    }

    public CoConnectionDescriptor[] getConnectionDescriptors() {
        CoConnectionDescriptor[] connectionDescriptors = new CoConnectionDescriptor[]{new CoConnectionDescriptor(2, class$cocon$CoConnection == null ? (class$cocon$CoConnection = CoObject.class$("cocon.CoConnection")) : class$cocon$CoConnection, class$cocon$CoObject == null ? (class$cocon$CoObject = CoObject.class$("cocon.CoObject")) : class$cocon$CoObject, class$cocon$CoObject == null ? (class$cocon$CoObject = CoObject.class$("cocon.CoObject")) : class$cocon$CoObject, -1, -1)};
        return connectionDescriptors;
    }

    public boolean canAddConnection(CoConnectionChangeEvent cce) {
        if (cce.getSource() == this) {
            cce.setError(CoConnectionChangeEvent.ERROR);
            cce.setName("This component cannot use this type of connection.");
            return false;
        }
        cce.setError(CoConnectionChangeEvent.DONOTCARE);
        cce.setName(null);
        return true;
    }

    public boolean canRemoveConnection(CoConnectionChangeEvent cce) {
        if (cce.getSource() == this) {
            cce.setError(CoConnectionChangeEvent.ERROR);
            cce.setName(null);
            return false;
        }
        cce.setError(CoConnectionChangeEvent.DONOTCARE);
        cce.setName(null);
        return true;
    }

    public void insertOutConnection(CoConnection connection, int index) {
        int i;
        if (connection == null) {
            return;
        }
        Class<?> connectionClass = connection.getClass();
        int k = this.getOutConnectionCount(connectionClass);
        if (index < 0) {
            return;
        }
        if (index > k) {
            index = k;
        }
        if (this.outConnections.contains(connection)) {
            int oldIndex = this.getOutConnectionIndex(connection);
            if (index == oldIndex) {
                connection.source = this;
                return;
            }
            this.outConnections.remove(connection);
        }
        for (i = this.outConnections.size(); k > index && i > 0; --i) {
            if (this.outConnections.get(i - 1).getClass() != connectionClass) continue;
            --k;
        }
        this.outConnections.add(i, connection);
        connection.source = this;
        this.fireConnectionChange(new CoConnectionChangeEvent(this, null, this, connection, 2, connection.source, connection.destination));
        if (connection.destination != null) {
            this.fireConnectionChange(new CoConnectionChangeEvent(this, null, this, connection, 3, connection.source, connection.destination));
        }
    }

    public void insertInConnection(CoConnection connection, int index) {
        int i;
        if (connection == null) {
            return;
        }
        Class<?> connectionClass = connection.getClass();
        int k = this.getInConnectionCount(connectionClass);
        if (index < 0) {
            return;
        }
        if (index > k) {
            index = k;
        }
        if (this.inConnections.contains(connection)) {
            int oldIndex = this.getInConnectionIndex(connection);
            if (index == oldIndex) {
                connection.destination = this;
                return;
            }
            this.inConnections.remove(connection);
        }
        for (i = this.inConnections.size(); k > index && i > 0; --i) {
            if (this.inConnections.get(i - 1).getClass() != connectionClass) continue;
            --k;
        }
        this.inConnections.add(i, connection);
        connection.destination = this;
        this.fireConnectionChange(new CoConnectionChangeEvent(this, null, this, connection, 1, connection.source, connection.destination));
        if (connection.source != null) {
            this.fireConnectionChange(new CoConnectionChangeEvent(this, null, this, connection, 3, connection.source, connection.destination));
        }
    }

    public void addOutConnection(CoConnection connection) {
        if (connection == null) {
            return;
        }
        this.insertOutConnection(connection, this.getOutConnectionCount(connection.getClass()));
    }

    public void addInConnection(CoConnection connection) {
        if (connection == null) {
            return;
        }
        this.insertInConnection(connection, this.getInConnectionCount(connection.getClass()));
    }

    public void insertConnection(CoConnection connection, CiConnectable destination, int sourceIndex, int destinationIndex) {
        if (connection == null) {
            return;
        }
        CiConnectable src = connection.getSource();
        CiConnectable dst = connection.getDestination();
        if (dst != null) {
            dst.removeInConnection(connection);
        }
        if (src != null && src != this) {
            src.removeOutConnection(connection);
        }
        if (src != this) {
            this.insertOutConnection(connection, sourceIndex);
        }
        if (destination != null) {
            destination.insertInConnection(connection, destinationIndex);
        }
    }

    public void addConnection(CoConnection connection, CiConnectable destination) {
        if (connection == null) {
            return;
        }
        CiConnectable src = connection.getSource();
        CiConnectable dst = connection.getDestination();
        if (dst != null) {
            dst.removeInConnection(connection);
        }
        if (src != null && src != this) {
            src.removeOutConnection(connection);
        }
        if (src != this) {
            this.addOutConnection(connection);
        }
        if (destination != null) {
            destination.addInConnection(connection);
        }
    }

    public void removeOutConnection(CoConnection connection) {
        if (connection == null) {
            return;
        }
        if (this.outConnections.contains(connection)) {
            this.outConnections.remove(connection);
        }
        CiConnectable src = connection.source;
        CiConnectable dst = connection.destination;
        connection.source = null;
        if (connection.destination != null) {
            this.fireConnectionChange(new CoConnectionChangeEvent(this, this, null, connection, 6, src, dst));
        }
        this.fireConnectionChange(new CoConnectionChangeEvent(this, this, null, connection, 5, src, dst));
    }

    public void removeInConnection(CoConnection connection) {
        if (connection == null) {
            return;
        }
        if (this.inConnections.contains(connection)) {
            this.inConnections.remove(connection);
        }
        CiConnectable src = connection.source;
        CiConnectable dst = connection.destination;
        connection.destination = null;
        if (connection.source != null) {
            this.fireConnectionChange(new CoConnectionChangeEvent(this, this, null, connection, 6, src, dst));
        }
        this.fireConnectionChange(new CoConnectionChangeEvent(this, this, null, connection, 4, src, dst));
    }

    public void removeConnection(CoConnection connection) {
        if (connection == null) {
            return;
        }
        CiConnectable src = connection.source;
        CiConnectable dst = connection.destination;
        if (src != null) {
            src.removeOutConnection(connection);
        }
        if (dst != null) {
            dst.removeInConnection(connection);
        }
    }

    public int getOutConnectionCount(Class connectionClass) {
        if (connectionClass == null) {
            return this.outConnections.size();
        }
        int connectionCount = 0;
        for (int i = 0; i < this.outConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.outConnections.get(i);
            if (connection.getClass() != connectionClass || connection.destination == null || connection.destination.getInConnectionIndex(connection) < 0) continue;
            ++connectionCount;
        }
        return connectionCount;
    }

    public int getInConnectionCount(Class connectionClass) {
        if (connectionClass == null) {
            return this.inConnections.size();
        }
        int connectionCount = 0;
        for (int i = 0; i < this.inConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.inConnections.get(i);
            if (connection.getClass() != connectionClass || connection.source == null || connection.source.getOutConnectionIndex(connection) < 0) continue;
            ++connectionCount;
        }
        return connectionCount;
    }

    public CoConnection getOutConnection(Class connectionClass, int index) {
        if (index < 0 || index >= this.outConnections.size()) {
            return null;
        }
        if (connectionClass == null) {
            return (CoConnection)this.outConnections.get(index);
        }
        for (int i = 0; i < this.outConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.outConnections.get(i);
            if (connection.getClass() != connectionClass || connection.destination == null || connection.destination.getInConnectionIndex(connection) < 0) continue;
            if (index == 0) {
                return (CoConnection)this.outConnections.get(i);
            }
            --index;
        }
        return null;
    }

    public CoConnection getInConnection(Class connectionClass, int index) {
        if (index < 0 || index >= this.inConnections.size()) {
            return null;
        }
        if (connectionClass == null) {
            return (CoConnection)this.inConnections.get(index);
        }
        for (int i = 0; i < this.inConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.inConnections.get(i);
            if (connection.getClass() != connectionClass || connection.source == null || connection.source.getOutConnectionIndex(connection) < 0) continue;
            if (index == 0) {
                return (CoConnection)this.inConnections.get(i);
            }
            --index;
        }
        return null;
    }

    public CoConnection getOutConnection(Class connectionClass, CiConnectable destination) {
        for (int i = 0; i < this.outConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.outConnections.get(i);
            if (connection.getClass() != connectionClass || connection.destination != destination || destination.getInConnectionIndex(connection) < 0) continue;
            return connection;
        }
        return null;
    }

    public CoConnection getInConnection(Class connectionClass, CiConnectable source) {
        for (int i = 0; i < this.inConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.inConnections.get(i);
            if (connection.getClass() != connectionClass || connection.source != source || source.getOutConnectionIndex(connection) < 0) continue;
            return connection;
        }
        return null;
    }

    public int getOutConnectionIndex(CoConnection destination) {
        int connectionIndex = 0;
        for (int i = 0; i < this.outConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.outConnections.get(i);
            if (connection.getClass() != destination.getClass() || connection.destination == null) continue;
            if (connection == destination) {
                return connectionIndex;
            }
            ++connectionIndex;
        }
        return -1;
    }

    public int getInConnectionIndex(CoConnection source) {
        int connectionIndex = 0;
        for (int i = 0; i < this.inConnections.size(); ++i) {
            CoConnection connection = (CoConnection)this.inConnections.get(i);
            if (this.inConnections.get(i).getClass() != source.getClass() || connection.source == null) continue;
            if ((CoConnection)this.inConnections.get(i) == source) {
                return connectionIndex;
            }
            ++connectionIndex;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == name) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, name);
        this.fireAutoPropertyChange("name", oldName, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.description == description) {
            return;
        }
        String oldDescription = this.description;
        this.description = description;
        this.firePropertyChange("description", oldDescription, description);
        this.fireAutoPropertyChange("description", oldDescription, description);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (this.url == url) {
            return;
        }
        String oldUrl = this.url;
        this.url = url;
        this.firePropertyChange("url", oldUrl, url);
        this.fireAutoPropertyChange("url", oldUrl, url);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated() {
        Date oldCreated = this.created;
        this.created = new Date();
        this.firePropertyChange("created", oldCreated, this.created);
        this.fireAutoPropertyChange("created", oldCreated, this.created);
    }

    public void setCreated(Date created) {
        if (this.created == created) {
            return;
        }
        Date oldCreated = this.created;
        this.created = created;
        this.firePropertyChange("created", oldCreated, created);
        this.fireAutoPropertyChange("created", oldCreated, created);
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified() {
        Date oldModified = this.modified;
        this.modified = new Date();
        this.firePropertyChange("modified", oldModified, this.modified);
        this.fireAutoPropertyChange("modified", oldModified, this.modified);
    }

    public void setModified(Date modified) {
        if (this.modified == modified) {
            return;
        }
        Date oldModified = this.modified;
        this.modified = modified;
        this.firePropertyChange("modified", oldModified, modified);
        this.fireAutoPropertyChange("modified", oldModified, modified);
    }

    public UID getUid() {
        return this.uid;
    }

    public void setUid() {
        UID oldUid = this.uid;
        this.uid = new UID();
        this.firePropertyChange("uid", oldUid, this.uid);
        this.fireAutoPropertyChange("uid", oldUid, this.uid);
    }

    public void setUid(UID uid) {
        if (this.uid == uid) {
            return;
        }
        UID oldUid = this.uid;
        this.uid = uid;
        this.firePropertyChange("uid", oldUid, uid);
        this.fireAutoPropertyChange("uid", oldUid, uid);
    }

    public Position getPosition() {
        return this.position;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (this.backgroundColor == color) {
            return;
        }
        Color oldColor = this.backgroundColor;
        this.backgroundColor = color;
        this.firePropertyChange("backgroundColor", oldColor, color);
        this.fireAutoPropertyChange("backgroundColor", oldColor, color);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        if (this.foregroundColor == color) {
            return;
        }
        Color oldColor = this.foregroundColor;
        this.foregroundColor = color;
        this.firePropertyChange("foregroundColor", oldColor, color);
        this.fireAutoPropertyChange("foregroundColor", oldColor, color);
    }

    public Vector getIcons() {
        return this.icons;
    }

    public void setIcons(Vector icons) {
        Vector oldIcons = this.icons;
        this.icons = icons;
        this.firePropertyChange("icons", oldIcons, icons);
        this.fireAutoPropertyChange("icons", oldIcons, icons);
    }

    public Vector getPictures() {
        return this.pictures;
    }

    public void setPictures(Vector pictures) {
        Vector oldPictures = this.pictures;
        this.pictures = pictures;
        this.firePropertyChange("pictures", oldPictures, pictures);
        this.fireAutoPropertyChange("pictures", oldPictures, pictures);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.inConnections = new Vector();
        this.outConnections = new Vector();
        this.changeListeners = new PropertyChangeSupport(this);
        this.listenerList = new EventListenerList();
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        return new CoObject(this);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

