/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.storedProcedures;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * 
 * @author Martin Scholz
 * @version $Id: DbConnector.java,v 1.5 2006/09/27 15:00:02 euler Exp $
 */
public class DbConnector {

    // If you need debug-messages via System.out.println(..), set to "true":
    private static final boolean debugMessages = false;

    private final Connection con;
    private BusinessDbConnectionSource myDbc = null;

	/**
	 * @param dbc is <code>null</code>, if these classes are used as stored procedures.
	 * Otherwise <code>dbc</code> is the thread's <code>edu.udo.cs.miningmart.m4.core.utils.Db</code>
	 * object, which is used to request a JDBC connection to the business data schema.
	 * @throws SQLException if the connection cannot be established
	 */
    public DbConnector(BusinessDbConnectionSource dbc) throws SQLException {
		try {
			if (dbc == null) {
			    this.con = DriverManager.getConnection("jdbc:default:connection:");
			}
			else {
				this.con = dbc.getDatabaseConnectionForData();
				this.myDbc = dbc;
			}
		}
		catch (Exception e) {
		    throw new SQLException(
		    	"Exception in class miningmart.storedProcedures.DbConnector when trying to connect to DB: "
			   	+ e.getMessage());
		}
		if (this.con == null) {
		    throw new SQLException("Database connection failed!");
		}
    }

    public Connection getConnection() {
		return this.con;
    }

    public void close() {
		final Connection c = this.getConnection();
		try {
		    if (c != null && !c.isClosed()) {
				c.commit();
				c.close();
		    }
		}
		catch (SQLException e) {
	    	infoOutput("Closing Connection in class DbConnector failed:\n" + e);
		}
    }

    public static void infoOutput(String out) {
		if (debugMessages == true) {
		    System.out.println(out);
		}
    }

	public String getSelectStringColumnDataType(String tableName, String owner, String columnName) {
		if (this.myDbc != null) {
			return this.myDbc.getSelectStringForColumnDataType(owner, tableName, columnName);
		}
		else return null;
	}
}
