/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.storedProcedures;
import java.sql.*;

/**
 * 
 * @author Martin Scholz
 * @version $Id: DataType.java,v 1.5 2006/09/27 15:00:02 euler Exp $
 */
class DataType {

    /**
     * @param tableName the name of a table int the database
     * @param columnName the name of a column of the given table
     * @param dbc a <code>DbConnector</code> to access the database
     * @return the datatype of the specified column
     */
    public static String getColumnDataType(String tableName, String columnName, DbConnector dbc)
    {
		if (tableName == null || columnName == null) {
		    DbConnector.infoOutput(
		    	"Warning: Trying to call DataType.getColumnDataType("
			    + tableName + ", " + columnName +") with null values!"
			);
		    // return DataType.UNKNOWN;
		    return "UNKNOWN";
		}

		String query;
		int lastDotIndex = tableName.lastIndexOf('.');
		if (lastDotIndex == -1) {
		    query = dbc.getSelectStringColumnDataType(tableName, null, columnName);
		}
		else {
		    final String justTableName = tableName.substring(lastDotIndex + 1);
	    	final String owner =  tableName.substring(0, lastDotIndex);
		    query = dbc.getSelectStringColumnDataType(justTableName, owner, columnName);
		}

		String dtString = null;
		try {
			/*
	    	if (dbc == null) {
				DbConnector.infoOutput(
					"Warning: Trying to call DataType.getColumnDataType("
				    + tableName + ", " + columnName +") without valid DB connection!"
				);
				dbc = new DbConnector();
		    }
		    */

		    Statement stmt = null;
		    ResultSet rset = null;
		    DbConnector.infoOutput("DB Query: " + query);
		    try {
		    	stmt = dbc.getConnection().createStatement();
		    	rset = stmt.executeQuery(query);
			    if (rset.next()) {
					dtString = rset.getString(1);
			    }
		    }
		    finally {
		    	if (rset != null) {
		    		try {
					    rset.close();
		    		} catch (SQLException e) {}
		    	}
		    		
		    	if (stmt != null) {
		    		try {
				    	stmt.close();
		    		} catch (SQLException e) {}
		    	}
		    }
		}
		catch (SQLException e) {
			DbConnector.infoOutput(e.getMessage());
		}
		//return (DataType.getTypeFor(dtString));
		return dtString;
    }


    public static void wrongDataType(String table, Attribute column) throws SQLException
    {
		throw new SQLException(
				"Column '" + column.getName() + "' of table '" + table
				+ "' has unsupported relational datatype: '"
				+ column.getDataTypeName() + "'!");
    }

}
/*
 *$Log: DataType.java,v $
 *Revision 1.5  2006/09/27 15:00:02  euler
 *New version 1.1
 *
 *Revision 1.4  2006/04/11 14:10:16  euler
 *Updated license text.
 *
 *Revision 1.3  2006/04/06 16:31:15  euler
 *Prepended license remark.
 *
 *Revision 1.2  2006/03/30 16:07:15  scholz
 *fixed author tags for release
 *
 *Revision 1.1  2006/01/03 09:54:23  hakenjos
 *Initial version!
 * 
 */
