/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.schemamatching;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.Soundex;

/**
 *
 * A simple matcher based on the soundex representation of strings.
 * 
 * @author Timm Euler
 * @version $Id: SoundexMatcher.java,v 1.6 2006/09/27 15:00:03 euler Exp $
 */
public class SoundexMatcher extends NameAndTypeBasedSchemaMatcher {

	private Soundex mySoundexComputer = new Soundex();
	
	/**
	 * @see edu.udo.cs.miningmart.schemamatching.NameAndTypeBasedSchemaMatcher#getNameSimilarity(String, String)
	 */
	public double getNameSimilarity(String str1, String str2) throws SchemaMatchException {
		try {
			return (this.mySoundexComputer.difference(str1, str2) / 4d);
		}
		catch (EncoderException ee) {
			throw new SchemaMatchException("EncoderException caught when computing Soundex-Similarity between Strings '" +
					str1 + "' and '" + str2 + "': " + ee.getMessage());
		}
	}	
}
/*
 * $Log: SoundexMatcher.java,v $
 * Revision 1.6  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/01/03 14:47:52  euler
 * New NgramMatcher, additional comments.
 *
 * Revision 1.2  2006/01/03 13:57:28  euler
 * Changed hierarchy of matchers, added Editdistance matcher.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
