/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Value;

/**
 * Objects of this class are result matrices of 
 * schema matchers that implement the interface
 * <code>MmSchemaMatcher</code>.
 * 
 * @author Timm Euler
 * @version $Id: MatchingResult.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class MatchingResult <T extends ParameterObject> {
	
	private T obj1, obj2;
	private double similarity;
	
	/**
	 * @return Returns the element of the first schema.
	 */
	public T getObjectOfFirstSchema() {
		return this.obj1;
	}
	
	/**
	 * @param obj The element to set.
	 */
	public void setObjectOfFirstSchema(T obj) 
	throws SchemaMatchException {
		this.typeCheck(obj);
		this.obj1 = obj;
	}
	
	/**
	 * @return Returns the element of the second schema.
	 */
	public T getObjectOfSecondSchema() {
		return this.obj2;
	}
	/**
	 * @param obj The element to set.
	 */
	public void setObjectOfSecondSchema(T obj) 
	throws SchemaMatchException {
		this.typeCheck(obj);
		this.obj2 = obj;
	}
	/**
	 * @return Returns the similarity.
	 */
	public double getSimilarity() {
		return similarity;
	}
	
	/**
	 * @param similarity The similarity to set.
	 */
	public void setSimilarity(double similarity) {
		this.similarity = similarity;
	}
	
	private void typeCheck(ParameterObject obj) 
	throws SchemaMatchException {
		if (obj instanceof Concept) return;
		if (obj instanceof BaseAttribute) return;
		if (obj instanceof Relation) return;
		if (obj instanceof Value) return;
		throw new SchemaMatchException("Attempt to create MatchingResult for unknown object type!");
	}
}
/*
 * $Log: MatchingResult.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */

