/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.schemamatching;

import java.util.Collection;

import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Step;

/**
 * @author euler
 *
 * Objects of this class bundle schema matching results 
 * between two data models (concept collections): the matchings,
 * the individual and global similarity, and the point in the Case
 * where the conceptual data model can be found. 
 */
public class DataModelConnection {

	private Collection<MatchingResult<Concept>> theConceptMappings;
	private double similarity;
	private Step dataModelProducingStep;
	private boolean isInitialDataModel;
	
	/**
	 * @return Returns the dataModelProducingStep.
	 */
	public Step getDataModelProducingStep() {
		return dataModelProducingStep;
	}
	/**
	 * @param dataModelProducingStep The dataModelProducingStep to set.
	 */
	public void setDataModelProducingStep(Step dataModelProducingStep) {
		this.dataModelProducingStep = dataModelProducingStep;
	}
	/**
	 * @return Returns the isInitialDataModel.
	 */
	public boolean isInitialDataModel() {
		return isInitialDataModel;
	}
	/**
	 * @param isInitialDataModel The isInitialDataModel to set.
	 */
	public void setInitialDataModel(boolean isInitialDataModel) {
		this.isInitialDataModel = isInitialDataModel;
	}
	/**
	 * @return Returns the similarity.
	 */
	public double getSimilarity() {
		return similarity;
	}
	/**
	 * @param similarity The similarity to set.
	 */
	public void setSimilarity(double similarity) {
		this.similarity = similarity;
	}
	/**
	 * @return Returns the ConceptMappings
	 */
	public Collection<MatchingResult<Concept>> getTheConceptMappings() {
		return theConceptMappings;
	}
	/**
	 * @param theConceptMappings The ConceptMappings to set.
	 */
	public void setTheConceptMappings(Collection<MatchingResult<Concept>> theConceptMappings) {
		this.theConceptMappings = theConceptMappings;
	}
}