/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: EquidistantDiscretizationGivenWidth.java,v 1.6 2006/09/27 15:00:04 euler Exp $
 */
public class EquidistantDiscretizationGivenWidth extends Discretization {

	/* Parametrs */
	public Value[] getStartPoint() throws M4CompilerError
	{
		return (Value[]) this.getParameter("StartPoint", this.getCurrentLoopNumber());
	}

	public Value[] getEndPoint() throws M4CompilerError
	{
		return (Value[]) this.getParameter("EndPoint", this.getCurrentLoopNumber());
	}

	public Value getIntervalWidth() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("IntervalWidth", this.getCurrentLoopNumber());
	}

	public Value getClosedTo() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
	}

	/* Basic methods */
	public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError
	{
		double start;
		double end;
		double width;
		int numOfIntervals;
		int i;
		double[] cutPoints;

		doPrint(Print.OPERATOR,"EquidistantDiscretizationGivenWidth:" );
		start = getStartPointOrMinum(theTargetAttributeColumn);
		width = Double.parseDouble(getIntervalWidth().getValue());
		end = getEndPointOrMaximum(theTargetAttributeColumn);

		numOfIntervals = (int) Math.ceil((end - start)/width);

		cutPoints = new double[numOfIntervals];

		for (i = 0; i < numOfIntervals; i++){
			cutPoints[i] = start + i * width;
		}
		return cutPoints;
	}

	/* Auxiliary methods */
	public double getStartPointOrMinum(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String min;
		Value[] myVal;

		myVal = getStartPoint();
		if (myVal.length == 0){
			try {
				min = theTargetAttributeColumn.readOrComputeMinimum();
				return (Double.parseDouble(min));
		    }
	    	catch (M4Exception e) {
	    		throw new M4CompilerError(e.getMessage());
		    }		
		}
		else{
			return (Double.parseDouble(myVal[0].getValue()));
		}
	}

	public double getEndPointOrMaximum(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String max;
		Value[] myVal;

		myVal = getEndPoint();
		if (myVal.length == 0) {
			try {
				max = theTargetAttributeColumn.readOrComputeMaximum();
				return (Double.parseDouble(max));
			}
		    catch (M4Exception e) {
	    		throw new M4CompilerError(e.getMessage());
		    }
		}
		else{
			return (Double.parseDouble(myVal[0].getValue()));
		}
	}
}
/*
 * $Log: EquidistantDiscretizationGivenWidth.java,v $
 * Revision 1.6  2006/09/27 15:00:04  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
