/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;

/**
 * This is the abstract super class for all Segmentation operators.
 * 
 * @author Timm Euler, Martin Scholz
 * @version $Id: Segmentation.java,v 1.6 2006/09/27 14:59:57 euler Exp $
 */
public abstract class Segmentation extends MultipleCSOperator {

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#generateSQLDefinition(String, int)
	 */
    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError
    {
    	try {
	        String viewDef = "(select " + selectPart +
		                     " from " + getInputConcept().getCurrentColumnSet().getSchemaPlusName() +
		                     " where " + generateConditionForOp(index) + ")";
	
	        return viewDef;
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
    } // end public Columnset generateColumnsetForOP

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#getTypeOfNewColumnSet(int)
	 */
    public String getTypeOfNewColumnSet(int index)
    {
        // all generated Colunsets are views
        return "V";
    }

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#mustCopyFeature(String)
	 */
    protected boolean mustCopyFeature(String nameOfFeature)
    {
        // This operator copies all BAs from input to output.
        return true;
    }

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.MultipleCSOperator#numberOfColumnSets
	 */
    public int numberOfColumnSets() throws M4CompilerError
    {   return numberOfSegments();   }

	/**
	 * Overrides the corresponding method of class <code>ConceptOperator</code>.
	 * This is done in order to extend the information on multi step branching,
	 * underlying the generation of the <code>Columnset</code>.
	 * 
	 * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#setNewCSMultiStepBranch
	 */
	protected void setNewCSMultiStepBranch(final Columnset newCS, int index)
		throws M4CompilerError
	{
		try {
			final Columnset inputCS = this.getInputConcept().getCurrentColumnSet();
	    	this.setCSSegmentInfo(inputCS.getMultiStepBranch(), newCS, index);
		}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
    }
    
    /**
     * Abstract method to be implemented by all Segmentation operators. The SQL condition
     * for segmenting the input columnset is generated by this method.
     * 
     * @param columnSetIndex The number of the columnset for which the condition is to
     *        be generated
     * @return the SQL condition as a String
     */
    public abstract String generateConditionForOp(int columnSetIndex) throws M4CompilerError;

	/**
	 * Abstract method to be implemented by all Segmentation operators. The number
	 * of segments that will be created is returned.
	 * 
	 * @return the number of segments that will be created
	 */ 
    public abstract int numberOfSegments() throws M4CompilerError;
    
	/**
	 * Abstract method to be implemented by all Segmentation operators. The 
	 * multistep information about how the segmentation was done is set
	 * into the newly created columnset.
	 * 
	 * @param inputMultiStepBranch the multistep information of the input columnset
	 * @param cs the current output columnset
	 * @param index the index of the output columnset
	 */ 
    public abstract void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError;
}
/*
 * Historie
 * --------
 *
 * $Log: Segmentation.java,v $
 * Revision 1.6  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:44  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * ------------
 *
 * Revision 1.20  2002/11/07 09:33:48  mmcoord
 * change getName() to getSchemaPlusName()
 *
 * Revision 1.19  2002/10/25 13:43:26  euler
 * Changed Sql Definitions that FeatureConstruction
 * operators create. Adapted the Join operators.
 *
 * Revision 1.18  2002/10/14 17:26:15  scholz
 * update of columnset names (based on step id)
 * for parallel execution of cases
 *
 * Revision 1.17  2002/10/08 18:07:55  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.16  2002/08/30 12:33:34  scholz
 * view definitions no longer inline in sql statements
 *
 * Revision 1.15  2002/08/29 16:23:19  scholz
 * Unsegmentation support for MRFC.
 * Bugfixes (e.g. "Unsegment" now finally in repository ;-) )
 *
 * Revision 1.14  2002/08/28 19:25:05  scholz
 * First step for automatically loading parameters and checking
 * their validity:
 * Information stored in OP_PARAM_T is represented in an own
 * class and automatically loaded by class Operator.
 *
 * Unsegment:
 * The field CS_MSBRANCH (table COLUMNSET_T) is now
 * set during operator execution.
 * Each Columnset has the information attached, by which
 * segmentations (e.g.' item=19; ' or '(KMeans)=1' ) it was
 * created. This information is used by the Unsegment operator
 * to perform a UNION on subsets of all Columnsets for a
 * Concept. Additionally the segmentation value is restored
 * when "reversing" SegmentationStratified.
 * Status of Unsegment:
 * - Sources compile
 * - CS_MSBRANCH is set correctly, except for MRFC.
 *
 * Revision 1.13  2002/08/05 10:35:48  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.12  2002/07/11 08:36:35  euler
 * Changed printing of messages.
 *
 * Revision 1.11  2002/06/13 16:30:05  euler
 * Changed naming of new Columnset;
 * uses "inputConcept.getSuffix()" now.
 *
 * Revision 1.10  2002/06/13 16:04:57  euler
 * Changed matching of features of output and input concept.
 * This now uses the method Feature.correspondsTo().
 *
 * Revision 1.9  2002/05/31 15:11:59  euler
 * Changed link from column to BA to 1:n.
 *
 * Revision 1.8  2002/05/31 12:35:01  euler
 * *** empty log message ***
 *
 * Revision 1.7  2002/05/23 11:35:00  euler
 * A few tests worked, others still to be done.
 *
 * Revision 1.6  2002/05/21 12:51:01  euler
 * First beta test ok.
 *
 * Revision 1.5  2002/05/16 10:34:04  euler
 * First version that compiles.
 *
 * Revision 1.4  2002/05/16 10:09:49  euler
 * First version that compiles.
 *
 * Revision 1.3  2002/05/15 13:05:02  euler
 * First version that compiles.
 *
 * Revision 1.2  2002/05/15 10:36:43  euler
 * First version that compiles.
 *
 * Revision 1.1  2002/04/30 13:00:30  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */








