/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import java.util.StringTokenizer;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Value;

/**
 * @author Timm Euler
 * @version $Id: RowSelectionByQuery.java,v 1.10 2006/09/27 14:59:57 euler Exp $
 */
public final class RowSelectionByQuery extends RowSelection {

	public static final String PARAMETER_LEFT_CONDITION  = "TheLeftCondition";
	public static final String PARAMETER_RIGHT_CONDITION = "TheRightCondition";
	public static final String PARAMETER_CONDITION_OP    = "TheConditionOperator";
	
    public String generateConditionForOp() throws M4CompilerError {       
    	try {
    		String sqlCondition = "";
            Value rightCond;
            String rightExpr;
	        for (int i = 0; i < this.getNumberOfLoops(); i++)
            {
                rightCond = this.getTheRightCondition(i);
                rightExpr = this.ensureQuotation(rightCond, this.getTheConditionOperator(i).trim());

                sqlCondition = sqlCondition + "(" +
		                         this.getTheLeftCondition(i).getCurrentColumn().getSQLDefinition() + " " +
		                         this.getTheConditionOperator(i) + " " + rightExpr + ") AND ";
            }
	        // Delete the last "AND "
	        sqlCondition = sqlCondition.substring(0, sqlCondition.length() - 4);
	        return sqlCondition;
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
    }
    
    protected BaseAttribute getTheLeftCondition(int loopNr) throws M4CompilerError {
    	return (BaseAttribute) this.getSingleParameter(PARAMETER_LEFT_CONDITION, loopNr);
    }
    
    protected String getTheConditionOperator(int loopNr) throws M4CompilerError {
    	return ((Value) this.getSingleParameter(PARAMETER_CONDITION_OP, loopNr)).getValue();
    }
    
    protected Value getTheRightCondition(int loopNr) throws M4CompilerError {
    	return (Value) this.getSingleParameter(PARAMETER_RIGHT_CONDITION, loopNr);
    }    
    
    private String ensureQuotation(Value rightCond, String operator) {
    	if (operator.equalsIgnoreCase("in")) {
        	String expr = rightCond.getValue().trim();
        	if (expr.startsWith("("))
        		expr = expr.substring(1);
        	if (expr.endsWith(")"))
        		expr = expr.substring(0, expr.length() - 1);
        	StringTokenizer st = new StringTokenizer(expr, ", ");
        	String ret = "";
        	while (st.hasMoreTokens()) {
        		String token = st.nextToken();
        		if (this.isNumeric(token) || this.isQuoted(token))
        			ret += token + ", ";
        		else
        			ret += DB.quote(token) + ", ";
        	}
        	ret = "(" + ret.substring(0, ret.length() - 2) + ")";
        	return ret;
        }
    	else 
    		if (rightCond.isDouble() || rightCond.isLong()) {
    			return rightCond.getValue().trim();
    		}
            return DB.quote(rightCond.getValue().trim());
    }
    
    private boolean isNumeric(String s) {
    	if (s == null)
    		return false;
    	try {
    		Double.parseDouble(s);
    		return true;
    	}
    	catch (NumberFormatException n) {
    		return false;
    	}
    }
    
    private boolean isQuoted(String s) {
    	s = s.trim();
    	if (s.startsWith("'") && s.endsWith("'"))
    		return true;
    	return false;
    }
}
/*
 * Historie
 * --------
 * 
 * $Log: RowSelectionByQuery.java,v $
 * Revision 1.10  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.9  2006/09/12 14:26:05  euler
 * bugfix
 *
 * Revision 1.8  2006/09/06 16:05:52  euler
 * *** empty log message ***
 *
 * Revision 1.7  2006/08/31 14:47:50  euler
 * *** empty log message ***
 *
 * Revision 1.6  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.3  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/01/18 16:58:58  euler
 * Added some basic estimations of statistics.
 * Will need improvements.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * ------------
 *
 * Revision 1.11  2003/06/05 09:52:02  euler
 * Organised imports.
 *
 * Revision 1.10  2002/10/08 18:07:56  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.9  2002/08/05 10:35:48  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.8  2002/07/11 08:36:35  euler
 * Changed printing of messages.
 *
 * Revision 1.7  2002/06/13 12:56:38  euler
 * Fixed a bug.
 *
 * Revision 1.6  2002/06/06 09:59:59  euler
 * Made operator loopable. Not tested yet.
 *
 * Revision 1.5  2002/05/31 12:35:01  euler
 * *** empty log message ***
 *
 * Revision 1.4  2002/05/21 12:51:01  euler
 * First beta test ok.
 *
 * Revision 1.3  2002/05/15 10:36:43  euler
 * First version that compiles.
 *
 * Revision 1.2  2002/05/07 13:06:56  wiese
 * get+set methods
 *
 * Revision 1.1  2002/04/30 13:00:29  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */


