/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;

/**
 * 
 * @author Timm Euler
 * @version $Id: RowSelection.java,v 1.4 2006/09/27 14:59:55 euler Exp $
 */
public abstract class RowSelection extends SingleCSOperator {

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.SingleCSOperator#generateSQLDefinition(String)
	 */
    public String generateSQLDefinition(String selectPart) throws M4CompilerError
    {
    	try {
	        String viewDef = "(select " + selectPart +
		                     " from " + getInputConcept().getCurrentColumnSet().getSchemaPlusName() +
		                     " where " + generateConditionForOp() + ")";
	
	        return viewDef;
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
    } // end public Columnset generateSQLDefinition

	/**
	 * Abstract method to be implemented by all subclasses. Must return the
	 * String for the WHERE part of the SQL definition of the output columnset.
	 * 
	 * @return the WHERE condition
	 */
    public abstract String generateConditionForOp() throws M4CompilerError;

    /**
     * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#getTypeOfNewColumnSet(int)
     */
    public String getTypeOfNewColumnSet()
    {  return Columnset.CS_TYPE_VIEW;  }

    /**
     * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#mustCopyFeature(String)
     */
    protected boolean mustCopyFeature(String nameOfFeature)
    {
        // This operator copies all BAs from input to output.
        return true;
    }
    
}
/*
 * Historie
 * --------
 * 
 * $Log: RowSelection.java,v $
 * Revision 1.4  2006/09/27 14:59:55  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * ------------
 *
 * Revision 1.18  2002/11/26 14:20:38  euler
 * Updates for random sampling.
 *
 * Revision 1.17  2002/10/08 18:07:56  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.16  2002/08/30 12:33:34  scholz
 * view definitions no longer inline in sql statements
 *
 * Revision 1.15  2002/08/05 10:35:48  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.14  2002/06/13 16:30:05  euler
 * Changed naming of new Columnset;
 * uses "inputConcept.getSuffix()" now.
 *
 * Revision 1.13  2002/06/13 16:04:57  euler
 * Changed matching of features of output and input concept.
 * This now uses the method Feature.correspondsTo().
 *
 * Revision 1.12  2002/06/12 13:59:02  euler
 * Added MultiRelationalFeatureConstruction.
 *
 * Revision 1.11  2002/06/11 12:58:54  euler
 * *** empty log message ***
 *
 * Revision 1.10  2002/06/11 11:32:36  euler
 * Added operator DeleteRecordsWithMissingValues.
 *
 * Revision 1.9  2002/06/11 08:32:36  euler
 * Added trash index, first tests ok.
 *
 * Revision 1.8  2002/06/03 12:02:37  euler
 * Restructured FeatureConstruction.
 *
 * Revision 1.7  2002/05/31 15:11:59  euler
 * Changed link from column to BA to 1:n.
 *
 * Revision 1.6  2002/05/31 12:35:01  euler
 * *** empty log message ***
 *
 * Revision 1.5  2002/05/23 11:34:59  euler
 * A few tests worked, others still to be done.
 *
 * Revision 1.4  2002/05/21 12:51:01  euler
 * First beta test ok.
 *
 * Revision 1.3  2002/05/15 13:05:02  euler
 * First version that compiles.
 *
 * Revision 1.2  2002/05/15 10:36:43  euler
 * First version that compiles.
 *
 * Revision 1.1  2002/04/30 13:00:29  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */

