/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;

/**
 * @author Martin Scholz
 * @version $Id: Repeat.java,v 1.4 2006/09/27 14:59:56 euler Exp $
 */
public class Repeat extends Segmentation {

	private static final String MULTISTEPBRANCH_ATTRIBUTE = "(Repeat)";
	
	/**
	 * Not needed because method <code>generateSQLDefinition</code> is overridden.
	 * @see Segmentation#generateConditionForOp(int)
	 */
	public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
		return null;
	}

	/**
	 * Overrides the method from Segmentation.java because no where-clause is needed.
	 * 
	 * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#generateSQLDefinition(String, int)
	 */
    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError
    {
		try {
			edu.udo.cs.miningmart.m4.Columnset cs = this.getInputConcept().getCurrentColumnSet();
			return "(" + cs.getCompleteSQLQuery() + ")";
		}		
   		catch (M4Exception m4e)	{
   			throw new M4CompilerError(
   				"Operator 'Repeat': Error trying to read the SQL definition of Columnset of Concept '"
   				+ this.getInputConcept().getName() + "' in step '" + this.getStep().getName() + "'");
   		} 
    }

	/**
	 * Getter method for parameter &quot;HowOften&quot;.
	 * @return the parameter &quot;HowOften&quot; as an integer
 	 * @see edu.udo.cs.miningmart.m4.core.operator.Segmentation#numberOfSegments 
	 */
    public int numberOfSegments() throws M4CompilerError {
    	Value value = (Value) this.getSingleParameter("HowOften");
    	if (value == null || value.getValue() == null) {
    		throw new M4CompilerError("Operator 'Repeat': Mandatory parameter 'HowOften' not set!");
    	}
    	try {
    		return Integer.parseInt(value.getValue());
    	}
    	catch (NumberFormatException e) {
    		throw new M4CompilerError("Operator 'Repeat': Parameter 'HowOften' is no integer!");
    	}
    }
    
	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.Segmentation#setCSSegmentInfo(String, Columnset, int)
	 */
	public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index)
		throws M4CompilerError
	{
		try {
			cs.addMultiStepBranchInfo(inputMultiStepBranch, MULTISTEPBRANCH_ATTRIBUTE, Integer.toString(index));
		}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
	}

}
/*
 * Historie
 * --------
 * 
 * $Log: Repeat.java,v $
 * Revision 1.4  2006/09/27 14:59:56  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
