/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Feature;

/**
 * This operator chooses all Features that are present in TheOutputConcept.
 * 
 * @author Timm Euler
 * @version $Id: $
 */
public final class RemoveFeatures extends FeatureSelection {

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.FeatureSelection
	 */
    protected Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError
    {
    	// ignore theSuperset
    	try {
			return this.getOutputConcept().getFeatures();	
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }    		
    }
    
    /**
     * Overrides the method from the superclass because this operator
     * does not need the parameter "TheAttributes", which gives the set
     * of features to select from.
     * 
     * @return an array of features
     */
	protected Feature[] getTheAttributes() throws M4CompilerError
	{
		try {
			Collection featCol = this.getInputConcept().getFeatures();
			if (featCol != null) {
				return (Feature[]) featCol.toArray(new Feature[featCol.size()]);
			}
			else return new Feature[0];
		}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }    		
	}
}