/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;


import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;

/**
 * The class <i>NumericalIntervalManualDiscretization</i> implements method
 * generateSQL creating virtual column definition for discretization of
 * numerical intervals according to given discretization specification.
 * NOTE: Physical database table is created, containing the specification. It does
 * not correspond to any M4 ColumnSet object.
 * 
 * @author Cezary Chudzian
 * @version $Id: NumericalIntervalManualDiscretization.java,v 1.6 2006/09/27 14:59:56 euler Exp $
 */
public class NumericalIntervalManualDiscretization extends ManualDiscretization  {

	/** Generates a sql-function to describe a new column.
	 * This method generates a sql-function to describe a new
	 * column. Also creates a discretization table.
	 * @return the SQL-function call
	 */
	public String generateSQL(Column theTargetAttributeColumn)
		throws M4CompilerError {

		String inputColumn = theTargetAttributeColumn.getSQLDefinition();
		int numberOfIntervals = this.getIntervalStart().length;
		
		String sql = "(CASE ";
		
		for (int i = 0; i < numberOfIntervals; i++) {
			String oneIntervalQuery = "WHEN (";
			oneIntervalQuery += inputColumn + this.getGreater(i, true) + this.getIntervalStart()[i].getValue() +
			                    ") AND (" +
			                    inputColumn + this.getSmaller(i, false) + this.getIntervalEnd()[i].getValue() + ")" +
			                    " THEN '" + this.getMapTo()[i].getValue() + "' ";
			sql += oneIntervalQuery;
		}
		sql += "ELSE '" + this.getDefaultValue().getValue() + "' END)";
		
		return sql;
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: NumericalIntervalManualDiscretization.java,v $
 * Revision 1.6  2006/09/27 14:59:56  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
