/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;
import java.sql.SQLException;
import java.util.Vector;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;

/**
 * @author Martin Scholz
 */
public class MaterializeWithPKs extends Materialize {

	/**
	 * @see ExecutableOperator#createStatement(boolean)
	 */
	public String generateSQLDefinition(String selectPart)
		throws M4CompilerError
	{
		super.generateSQLDefinition(selectPart);

		try {
			String tableName = this.getNewCSName();

			String pkName = this.getM4Db().getBusinessDbCore().createPrimaryKeyConstraint(
					tableName, this.getPrimaryKeyNames(), null);
			String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
			this.getM4Db().addPkConstraintToTrash(tableName, pkName, schema, this.getStep().getId());
			return tableName;
		}
		catch (M4Exception e) {
			throw new M4CompilerError(
					"Operator 'MaterializeWithPKs': SQLException caught during createStatement:\n"
					+ e.getMessage());
		}
		catch (SQLException e) {
			throw new M4CompilerError(
				"Operator 'MaterializeWithPKs': SQLException caught during createStatement:\n"
				+ e.getMessage());
		}
	}

	/**
	 * @return A <code>Vector</code> of <code>String</code>s containing the
	 *         primary key column names.
	 */
	public Vector getPrimaryKeyNames() throws M4CompilerError, M4Exception {
		BaseAttribute[] pkValues = (BaseAttribute[]) this.getParameter("PrimaryKey");
		Vector pkNames = new Vector(); 
		if (pkValues != null) {
			for (int i=0; i<pkValues.length; i++) {
				BaseAttribute ba = pkValues[i];
				if (ba.hasColumns()) {
					pkNames.add(ba.getCurrentColumn().getName());
				}
			}
		}
		return pkNames;
	}   
}
