/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;

/**
 * The class <i>MappingWithDefaultValue</i> maps values
 * for which no mapping has been specified into a constant value
 * It implements abstract method getDefault declared in Mapping.
 *
 * @see Mapping
 * @see PartialMapping
 * 
 * @author Cezary Chudzian
 * @version $Id: MappingWithDefaultValue.java,v 1.5 2006/09/27 14:59:56 euler Exp $
 */
public class MappingWithDefaultValue extends Mapping {

    /** Method overriding getDefault from Mapping class
     * Argument Column is ignored here!
     */
    public String getDefault(Column theTargetAttributeColumn) throws M4CompilerError {
    	return this.getDefaultMapping().getValue();
    }

    public Value getDefaultMapping() throws M4CompilerError {
    	return (Value) this.getSingleParameter("DefaultMapping", this.getCurrentLoopNumber());
    }

}
/*
 * Historie
 * --------
 * 
 * $Log: MappingWithDefaultValue.java,v $
 * Revision 1.5  2006/09/27 14:59:56  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */



