/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;

/**
 * 
 * @author Timm Euler, Martin Scholz
 * @version $Id: DeleteRecordsWithMissingValues.java,v 1.6 2006/09/27 14:59:56 euler Exp $
 */
public class DeleteRecordsWithMissingValues extends RowSelection
{
	/**
	 * @see miningmart.compiler.operator.RowSelection#generateConditionForOp()
	 */
    public String generateConditionForOp() throws M4CompilerError
    {
    	try {
    		edu.udo.cs.miningmart.m4.Column missingValuesColumn = this.getAttrWithMissingValues().getCurrentColumn();
	        return (missingValuesColumn.getSQLDefinition() + " IS NOT NULL");
    	}
    	catch (M4Exception m4e)
    	{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }
    }

	/**
	 * Gets the attrWithMissingValues.
	 * @return Returns a BaseAttribute
	 */
	public BaseAttribute getAttrWithMissingValues() throws M4CompilerError {
		return (BaseAttribute) this.getSingleParameter("TheTargetAttribute");
	}
}
/*
 * Historie
 * --------
 *
 * $Log: DeleteRecordsWithMissingValues.java,v $
 * Revision 1.6  2006/09/27 14:59:56  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */
