/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * This operator replaces the missing values with a default value which is 
 * specified with the parameter DefaultValue.
 * 
 * @author Timm Euler
 * @version $Id: AssignDefault.java,v 1.6 2006/09/27 14:59:57 euler Exp $
 */
public class AssignDefault extends MissingValues {
  
    /**
     * Gives the default value that this operator will use to replace missing
     * values in the current loop.
     *
     * @return the default value for the current loop
     */
    public Value getDefaultValue() throws M4CompilerError {
        return (Value) this.getSingleParameter("DefaultValue", this.getCurrentLoopNumber());
    }

    /** 
     * @see miningmart.operator.MissingValues#generateValueForOp(Column)
     */
    public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError
    {
    	String s = this.getDefaultValue().getValue();
    	if (columnWithMissingValues.getColumnDataType() == 12)
    	{   return s;  }
    	else
    	{   return DB.quote(s);  }
    }
}
/*
 * Historie
 * --------
 * 
 * $Log: AssignDefault.java,v $
 * Revision 1.6  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * --------
 *
 * Revision 1.13  2002/11/18 15:09:58  euler
 * Respects String datatypes now.
 *
 * Revision 1.12  2002/10/21 16:17:21  scholz
 * javadoc comments: fixed some invalid tags
 *
 * Revision 1.11  2002/10/08 18:07:56  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.10  2002/10/02 17:57:47  scholz
 * beautified autoLoad().
 * getSingleParameter(..) added.
 *
 * Revision 1.9  2002/10/01 14:26:10  scholz
 * Operator.getParameter() now always outputs an M4Object[]-object.
 *
 * Revision 1.8  2002/09/05 17:06:29  scholz
 * cleaned up some more operators (wrt. autoload), e.g.
 * Scaling and sub-classes and some MissingValues operators.
 *
 * Revision 1.7  2002/08/05 10:35:46  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.6  2002/06/06 09:59:58  euler
 * Made operator loopable. Not tested yet.
 *
 * Revision 1.5  2002/06/03 12:02:36  euler
 * Restructured FeatureConstruction.
 *
 * Revision 1.4  2002/05/14 12:52:56  bauschul
 * Method generateValueForOp() removed
 *
 * Revision 1.3  2002/05/14 12:44:58  bauschul
 * Compile-able, Code reformatet
 *
 * Revision 1.2  2002/05/07 13:06:55  wiese
 * get+set methods
 *
 * Revision 1.1  2002/04/30 13:00:26  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */
