/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * This operator takes the average of the values in the column that
 * has missing values, and replaces missing values with this average.
 * If the column type does not allow the computation of an average value
 * the operator cannot be applied.
 * 
 * @author Timm Euler
 * @version $Id: AssignAverageValue.java,v 1.5 2006/09/27 14:59:56 euler Exp $
 */
public class AssignAverageValue extends MissingValues  {

  /** 
   * @see miningmart.operator.MissingValues#generateValueForOp(Column)
   */
  public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError
  {  	
  	  if (columnWithMissingValues.getColumnDataType() != 12) // if not NUMBER
  	  {  throw new M4CompilerError("AssignAverageValue: column is not of type NUMBER, cannot compute average.");  }
  	  
	  String avg;
	  try {
	  	avg = columnWithMissingValues.readOrComputeAverage();
	  }
	  catch (M4Exception e) {
	  	throw new M4CompilerError(e.getMessage());	
	  }
  	
      String meanValue = "" + avg;
      
      return meanValue; // no quotes for a number!
  }
}
/*
 * New Historie
 * --------------
 * 
 * $Log: AssignAverageValue.java,v $
 * Revision 1.5  2006/09/27 14:59:56  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:20  hakenjos
 * Initial version!
 *
 */


/*
 * Old-Historie
 * --------
 *
 * Revision 1.8  2003/06/05 09:52:02  euler
 * Organised imports.
 *
 * Revision 1.7  2002/11/18 14:08:12  euler
 * Bugfix.
 *
 * Revision 1.6  2002/10/08 18:07:56  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.5  2002/09/12 10:17:42  euler
 * Added computation of average value
 * if needed.
 *
 * Revision 1.4  2002/09/05 17:06:29  scholz
 * cleaned up some more operators (wrt. autoload), e.g.
 * Scaling and sub-classes and some MissingValues operators.
 *
 * Revision 1.3  2002/08/05 10:35:46  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.2  2002/05/10 13:23:21  euler
 * First M4 extensions, does not yet compile
 *
 * Revision 1.1  2002/04/30 13:00:26  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */
