/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.XmlException;

/**
 * This interface has to be implemented by all <code>M4Object</code>s
 * to be export-/importable to/from an XML flat file.
 * 
 * @author Martin Scholz
 * @version $Id: XmlInfo.java,v 1.4 2006/09/27 14:59:55 euler Exp $
 */
public interface XmlInfo {
	
	public static final String M4_XML_VERSION = "M4-XML V0.5";
	
	public static final String TAG_XML_ID     = "XmlId";
	public static final String TAG_COLLECTION = "Collection";
	public static final String TAG_STRING     = "String";
	public static final String TAG_LONG       = "Long";
	public static final String TAG_INTEGER    = "Integer";
	public static final String TAG_SHORT      = "Short";
	public static final String TAG_DOUBLE     = "Double";
	
	// Reserved Tag, only to import system objects directly from M4:
	public static final String TAG_M4_ID     = "M4Id";
	
	/**
	 * For compatibility reasons the version of the M4-XML is
	 * available here. The substring after the last 'V' has to
	 * be numeric.
	 */
	String getXmlVersion();
		
	/** @return the tag of <code>this</code> M4 object */
	String getObjectTag();

	/** @return the ID tag of <code>this</code> M4 object */
	String getXmlIdTag();

	/** 
	 * @return a <code>M4Info</code> object with the information
	 * of all XML fields of <code>this</code> object. 
	 */
	M4Info getXmlInfo();
	
	Collection getDependentObjects() throws M4Exception;
	
	void doPrint(Level verbosity, String message);
	
	void doPrint(Exception ex);
	
	Collection exportLocal(Writer out, Collection dependent) throws M4Exception, IOException;

	void importLocal(String tag, String embedded) throws XmlException, M4Exception;

	Object genericGetter(String nameOfGetter) throws M4Exception;
	
	void genericSetter(String nameOfSetter, Class parameterClassOfSetter, Object objectToSet) throws M4Exception;

}
/*
 * Historie
 * --------
 * 
 * $Log: XmlInfo.java,v $
 * Revision 1.4  2006/09/27 14:59:55  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */
