/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/**
 * 
 * @author Martin Scholz
 * @version $Id: M4Info.java,v 1.4 2006/09/27 14:59:55 euler Exp $
 */
public class M4Info {

	// A collection (ordered!) of all entries.
	final Collection m4Entries;

	// An (unordered) map of entries for quicker reference by db attribute name.
	final HashMap attributesByName;

	/**
	 * @param m4e an array of <code>M4InfoEntry</code> objects in an order
	 *        that allows to load the objects correctly
	 */
	public M4Info(M4InfoEntry[] m4e) {
		this.m4Entries = new Vector();
		if (m4e != null) {
			for (int i=0; i<m4e.length; i++) {
				this.m4Entries.add(m4e[i]);
			}
		}
		this.attributesByName = this.createAttributesByName(this.m4Entries);
	}

	/**
	 * @param m4e a <code>Collection</code> of <code>M4InfoEntry</code> objects in
	 *        an order that allows to load the objects correctly
	 */
	public M4Info(Collection m4e) {
		this.m4Entries = m4e;
		this.attributesByName = this.createAttributesByName(this.m4Entries);
	}

	/** Private helper method of the constructors. */
	private HashMap createAttributesByName(Collection m4Entries) {
		Iterator it = this.getInfos().iterator();
		HashMap result = new HashMap();
		while (it.hasNext()) {
			M4InfoEntry entry = (M4InfoEntry) it.next();
			String name = entry.getDbAttribute();
			result.put(name, entry);
		}	
		return result;
	}

	/**
	 * Getter method
	 * @return the ordered <code>Collection</code> of <code>M4InfoEntry</code> objects
	 */	
	public Collection getInfos() {
		return this.m4Entries;
	}

	/**
	 * Getter method for a database attribute info object
	 * @param dbAttribute the name of a database attribute
	 * @return the <code>M4InfoEntry</code> corresponding to the attribute name
	 * specified, or <code>null</code> if no such info object exitsts for that name.
	 */	
	public M4InfoEntry getInfo(String dbAttribute) {
		return (M4InfoEntry) this.attributesByName.get(dbAttribute);
	}


}
/*
 * Historie
 * --------
 * 
 * $Log: M4Info.java,v $
 * Revision 1.4  2006/09/27 14:59:55  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:03  hakenjos
 * Initial version!
 *
 */
