/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.Relation;

/**
 * Helper class for standard communication between the toConcepts and Relations
 * where the toConcepts are the containers.
 * 
 * @author Timm Euler
 * @version $Id: InterM4ToConceptRelation.java,v 1.4 2006/09/27 14:59:54 euler Exp $
 */
public class InterM4ToConceptRelation extends InterM4Communicator
{
	/**
	 * @param relation a <code>Relation</code>
	 * @return the <code>Relation</code>'s ToConcept
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#getSingleRef(M4Object)
	 */
	Object getSingleRef(M4Object relation) throws M4Exception
	{   return ((Relation) relation).getTheToConcept();   }

	/**
	 * @param toConcept a <code>Concept</code>
	 * @return the <code>Concept</code>'s <code>Collection</code> of <code>Relation</code>s
	 *         in which this concept is the ToConcept
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#getCollection(Object)
	 */
	Collection getCollection(Object toConcept) throws M4Exception
	{   return ((Concept) toConcept).getTheToRelationships();   }

	/**
	 * @param relation a <code>Relation</code>
	 * @param toConcept a <code>Concept</code>
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#setSingleRefPrimitive(M4Object, Object)
	 */
	void setSingleRefPrimitive(M4Object relation, Object toConcept)
		throws M4Exception
	{   ((Relation) relation).primitiveSetToConcept((Concept) toConcept);   }
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4ToConceptRelation.java,v $
 * Revision 1.4  2006/09/27 14:59:54  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */
