/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.core.Columnset;

/**
 * Helper class for standard communication between <code>Relation</code> 
 * and <code>Columnset</code>.
 * 
 * @author Timm Euler
 * @version $Id: InterM4RelationToColumnset.java,v 1.4 2006/09/27 14:59:55 euler Exp $
 */
public class InterM4RelationToColumnset extends InterM4ObjectToObject
{
	/**
	 * @param relation a Relation 
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#getFirstSingleRef(M4Object)
	 */
	M4Object getFirstSingleRef(M4Object relation) throws M4Exception
	{	return (Columnset) ((Relation) relation).getCrossLinkColumnSet();	}

	/**
	 * @param columnset a Columnset
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#getSecondSingleRef(M4Object)
	 */
	M4Object getSecondSingleRef(M4Object columnset) throws M4Exception
	{	return (Relation) ((Columnset) columnset).getRelation();	}

	/**
	 * @param relation a Relation 
	 * @param columnset a Columnset
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#setFirstSingleRefPrimitive(M4Object, M4Object)
	 */
	void setFirstSingleRefPrimitive(M4Object relation, M4Object columnset)
		throws M4Exception
	{   ((Relation) relation).primitiveSetColumnset((Columnset) columnset);   }

	/**
	 * @param columnset a Columnset
	 * @param relation a Relation 
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#setSecondSingleRefPrimitive(M4Object, M4Object)
	 */
	void setSecondSingleRefPrimitive(M4Object columnset, M4Object relation)
		throws M4Exception
	{   ((Columnset) columnset).setRelationPrimitive((Relation) relation);   }
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4RelationToColumnset.java,v $
 * Revision 1.4  2006/09/27 14:59:55  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:05  hakenjos
 * Initial version!
 *
 */
