/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.core.M4Object;

/**
 * Helper class for standard communication between <code>Column</code> (container)
 * and <code>ColumnStatistics2</code>.
 * 
 * @author Martin Scholz
 * @version $Id: InterM4ColumnColumnStatist2.java,v 1.4 2006/09/27 14:59:54 euler Exp $
 */
public class InterM4ColumnColumnStatist2 extends InterM4Communicator {
	
	/**
	 * @param colstat a <code>ColumnStatistics2</code>
	 * @return the <code>ColumnStatistics2</code>'s <code>Column</code>
	 * 
	 * @see InterM4Communicator#getSingleRef(M4Object)
	 */
	public Object getSingleRef(M4Object colstat) throws M4Exception {
		return ((ColumnStatistics2) colstat).getTheColumn();
	}
	
	/**
	 * @param column a <code>Column</code>
	 * @return the <code>Column</code>'s <code>Collection</code>
	 * 
	 * @see InterM4Communicator#getCollection(M4Object)
	 */
	public Collection getCollection(Object column) throws M4Exception {
		return ((Column) column).getDistributionStatistics();
	}
	
	/**
	 * @param colstat a <code>ColumnStatistics2</code>
	 * @param column a <code>Column</code>
	 * 
	 * @see InterM4Communicator#setSingleRefPrimitive(M4Object, M4Object)
	 */
	public void setSingleRefPrimitive(M4Object colstat, Object column) throws M4Exception {
		((ColumnStatistics2) colstat).primitiveSetColumn((Column) column);
	}
	
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4ColumnColumnStatist2.java,v $
 * Revision 1.4  2006/09/27 14:59:54  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */
