/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;

/** 
 * Just an abstraction of MultiColumnFeature and BaseAttribute.
 * Has no correspondance in the M4-DB and therefore no fields.
 * On construction it just passes to its superclass.
 * 
 * @see edu.udo.cs.miningmart.m4.core.MultiColumnFeature
 * @see edu.udo.cs.miningmart.m4.core.BaseAttribute
 * 
 * @author Timm Euler
 * @version $Id: Feature.java,v 1.4 2006/09/27 15:00:00 euler Exp $
 */
public abstract class Feature extends ParameterObject implements edu.udo.cs.miningmart.m4.Feature
{
    private Concept myConcept;
    
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Object#Constructor
	 */
	public Feature(DB m4Db) {
		super(m4Db);	
	}

    /**
     * This method indicates if an input feature corresponds to an
     * output feature, or if two input features correspond, e.g.
     * for UNION operations.
     * 
     * Additionally to comparing names the types (<i>BaseAttribute</i>
     * or <i>MultiColumnFeature</i>) have to be equal.
     *
     * @param  f the feature to compare this one to
     * @return <true> iff the features are corresponding.
    */
    public boolean correspondsTo (edu.udo.cs.miningmart.m4.Feature f) {

		if (f == null)
		    return (false);

	    return ( this.getClass() == f.getClass() &&
		    	 this.getName().equalsIgnoreCase(f.getName()) );
    }

 	/** <code>Feature</code>s have no coordinates. */
	protected boolean hasCoordinates() {
		return false;
	}

	/**
	 * @return The concept that belongs to this BaseAttribute.
	 */
    public edu.udo.cs.miningmart.m4.Concept getConcept() throws M4Exception
    {   return myConcept;   }
    
	/**
	 * Set the concept this Feature belongs to.
	 * @param c the <code>Concept</code>
	 */
	public void setConcept(edu.udo.cs.miningmart.m4.Concept c) throws M4Exception {
		edu.udo.cs.miningmart.m4.core.Concept.con2fea.checkNameExists(this, c);
		edu.udo.cs.miningmart.m4.core.Concept.con2fea.updateReferenceTo(this, c);
	}
	
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Data#getObjectsInNamespace(Class)
	 */
	protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
		return null;
	}

    /**
	 * Primitive setter, do not use.
	 * @param c the <code>Concept</code> to be set
	 * */
    public void primitiveSetConcept(Concept c) {
    	this.setDirty();
    	this.myConcept = c;
    }

    /**
     * Return the Parameter object that represents this
     * Feature as an output parameter (of a certain step).
     *  
     * @return a Parameter object
     */
    public edu.udo.cs.miningmart.m4.Parameter getParameterWhereThisIsOutputFeature() throws M4Exception {
    	Collection c = null;
		c = this.getParameterReferences();
		Iterator it = c.iterator();
		Vector ret = new Vector();
		while (it.hasNext()) {
			Parameter par = (Parameter) it.next();
			if (par.getParameterType().equals(Parameter.TYPE_OUTPUT)) {
				ret.add(par);
			}
		}
		if (ret.size() == 0) {
			return null;	
		}
		else if (ret.size() > 1) {
			throw new M4Exception("Feature '" + this.getName() + "' is Output Parameter of more than one Step!");	
		}
		else {
			return (Parameter) ret.firstElement();
		}
    }
    
	/**
	 * @return <code>true</code> iff this <code>Feature</code> has
	 * been &quot;deselected&quot; by a <code>FeatureSelection</code> operator
	 * or has not been connected by the user.
	 */    
    public abstract boolean isDeselected() throws M4CompilerError;    
}
/*
 * Historie
 * --------
 * 
 * $Log: Feature.java,v $
 * Revision 1.4  2006/09/27 15:00:00  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:18  hakenjos
 * Initial version!
 *
 */
