/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;

import java.util.Collection;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;

/**
 * @author Martin Scholz
 * @version $Id: ColumnStatistics1.java,v 1.4 2006/09/27 14:59:59 euler Exp $
 */
public class ColumnStatistics1 extends M4Data implements XmlInfo, edu.udo.cs.miningmart.m4.ColumnStatistics1 {

	// ***** Database constants for the Column table *****
	public static final String M4_TABLE_NAME = "colstatist1_t";
	public static final String ATTRIB_COLSTAT_ID     = "colst1_id";
	public static final String ATTRIB_COLST1_COLID   = "colst1_colid";
	public static final String ATTRIB_COLST1_UNIQUE  = "colst1_unique";
	public static final String ATTRIB_COLST1_MISSING = "colst1_missing";
	public static final String ATTRIB_COLST1_MIN     = "colst1_min";
	public static final String ATTRIB_COLST1_MAX     = "colst1_max";
	public static final String ATTRIB_COLST1_AVG     = "colst1_avg";
	public static final String ATTRIB_COLST1_STDDEV  = "colst1_stddev";
	public static final String ATTRIB_COLST1_VAR     = "colst1_variance";
	public static final String ATTRIB_COLST1_MEDIAN  = "colst1_median";
	public static final String ATTRIB_COLST1_MODAL   = "colst1_modal";

	/** Cache for getM4Info() */
	public static M4Info m4Info = null;

	/** @see M4Table.getM4TableName() */
	public String getM4TableName() {
		return M4_TABLE_NAME;	
	}

	/** @see M4Table.getIdAttributeName() */
	public String getIdAttributeName() {
		return ATTRIB_COLSTAT_ID;
	}

	/** @see M4Table.getM4Info() */
	public M4Info getM4Info() {
		if (m4Info == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry(ATTRIB_COLSTAT_ID,       "getId",                "setId",     	         long.class,   NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST1_COLID,     "getTheColumn",         "primitiveSetColumn",   edu.udo.cs.miningmart.m4.Column.class, NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST1_UNIQUE,    "getNrOfUniqueValuesI", "setNrOfUniqueValues",  Integer.class),
				new M4InfoEntry(ATTRIB_COLST1_MISSING,   "getNrOfMissingValuesI","setNrOfMissingValues", Integer.class),
				new M4InfoEntry(ATTRIB_COLST1_MIN,       "getMinimum",           "setMinimum",           String.class),
				new M4InfoEntry(ATTRIB_COLST1_MAX,       "getMaximum",           "setMaximum",           String.class),
				new M4InfoEntry(ATTRIB_COLST1_AVG,       "getAverageD",          "setAverage",           Double.class),
				new M4InfoEntry(ATTRIB_COLST1_STDDEV,    "getStandardDeviationD","setStandardDeviation", Double.class),
				new M4InfoEntry(ATTRIB_COLST1_VAR,       "getVarianceD",         "setVariance",          Double.class),
				new M4InfoEntry(ATTRIB_COLST1_MEDIAN,    "getMedian",            "setMedian",            String.class),
				new M4InfoEntry(ATTRIB_COLST1_MODAL,     "getModal",             "setModal",             String.class)
			};
			m4Info = new M4Info(m4i);
		}
		return m4Info;
	}

	// ***** Method from the XmlInfo interface *****

	/** Cache for getXmlInfo() */
	private static M4Info xmlInfo = null;

	/** @see XmlInfo.getXmlInfo() */
	public M4Info getXmlInfo() {
		if (xmlInfo == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry("Column",     "getTheColumn",         "setTheColumn",		  edu.udo.cs.miningmart.m4.Column.class),
				new M4InfoEntry("UniqueVals", "getNrOfUniqueValuesI", "setNrOfUniqueValues",  Integer.class),
				new M4InfoEntry("MissingVals","getNrOfMissingValuesI","setNrOfMissingValues", Integer.class),
				new M4InfoEntry("Minimum",    "getMinimum",           "setMinimum",           String.class),
				new M4InfoEntry("Maximum",    "getMaximum",           "setMaximum",           String.class),
				new M4InfoEntry("Average",    "getAverageD",          "setAverage",           Double.class),
				new M4InfoEntry("StdDev",     "getStandardDeviationD","setStandardDeviation", Double.class),
				new M4InfoEntry("Variance",   "getVarianceD",         "setVariance",          Double.class),
				new M4InfoEntry("Median",     "getMedian",            "setMedian",            String.class),
				new M4InfoEntry("Modal",      "getModal",             "setModal",             String.class)
			};
			xmlInfo = new M4Info(m4i);
		}
		return xmlInfo;
	}

	// *****
	
	private Column myColumn;
	
	private Integer noOfUniqueValues, noOfMissingValues;
	private String min, max, median, modal;
	private Double avg, stdev, variance;

	public ColumnStatistics1(DB db) { super(db); }
	
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Data#getObjectsInNamespace(Class)
	 */
	protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
		return null;
	}
	
	public Integer getNrOfUniqueValuesI() {
		return this.noOfUniqueValues;
	}

	public void setNrOfUniqueValues(Integer nrOfUniqueValues) {
		this.setDirty();
		this.noOfUniqueValues = nrOfUniqueValues;		
	}

	public Integer getNrOfMissingValuesI() {
		return this.noOfMissingValues;
	}

	public void setNrOfMissingValues(Integer nrOfMissingValues) {
		this.setDirty();
		this.noOfMissingValues = nrOfMissingValues;
	}

	public String getMinimum() {
		return this.min;
	}

	public void setMinimum(String minimum) {
		this.setDirty();
		this.min = minimum;
	}

	public String getMaximum() {
		return this.max;
	}

	public void setMaximum(String maximum) {
		this.setDirty();
		this.max = maximum;		
	}

	public Double getAverageD() {
		return this.avg;
	}

	public void setAverage(Double average) {
		this.setDirty();
		this.avg = average;
	}

	public Double getStandardDeviationD() {
		return this.stdev;
	}

	public void setStandardDeviation(Double standardDeviation) {
		this.setDirty();
		this.stdev = standardDeviation;
	}

	public Double getVarianceD() {
		return this.variance;
	}

	public void setVariance(Double variance) {
		this.setDirty();
		this.variance = variance;
	}

	public String getMedian() {
		return this.median;
	}

	public void setMedian(String median) {
		this.setDirty();
		this.median = median;
	}

	public String getModal() {
		return this.modal;
	}

	public void setModal(String modal) {
		this.setDirty();
		this.modal = modal;
	}

	public edu.udo.cs.miningmart.m4.Column getTheColumn() {
		return this.myColumn;
	}

	public void setTheColumn(edu.udo.cs.miningmart.m4.Column column) throws M4Exception {
		Column.colCstat1.updateReferenceTo(this, column);
	}

	public void primitiveSetColumn(edu.udo.cs.miningmart.m4.Column column) {
		this.setDirty();
		this.myColumn = (Column) column;		
	}

	/**
	 * Print the information about this column statistics.
	 */
    public void print(){
  		this.doPrint(Print.M4_OBJECT, "Column " + this.getName() + "(Id = " + this.getId() + ";" +
		      "(Unique: "    + (this.getNrOfUniqueValuesI() == null ? "<null>" : this.getNrOfUniqueValuesI().toString()) +
		      " Missing: "   + (this.getNrOfMissingValuesI() == null ? "<null>" : this.getNrOfMissingValuesI().toString()) +
		      " Min: "       + this.getMinimum() +
		      " Max: "       + this.getMaximum() +
		      " Median: "    + this.getMedian() +
		      " Modal: "     + this.getModal() +
		      " Average: "   + (this.getAverageD() == null ? "<null>" : this.getAverageD().toString())+
		      " Std. Dev.: " + (this.getStandardDeviationD() == null ? "<null>" : this.getStandardDeviationD().toString())
		      + ")");
    };
    
    /** Remove the Column reference of this statistic object. */
    public void removeAllM4References() throws M4Exception {
    	this.setTheColumn(null);
    }

}
/*
 * Historie
 * --------
 * 
 * $Log: ColumnStatistics1.java,v $
 * Revision 1.4  2006/09/27 14:59:59  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:13  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:18  hakenjos
 * Initial version!
 *
 */
