/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

/**
 * Access to the roles used in M4.
 * 
 * @author Timm Euler
 * @version $Id: $
 */
public interface Roles {
	
	/*
	 * public String constants to refer to the specific roles.
	 */	
	public static final String ROLE_NOROLE 		= "NO_ROLE";
	public static final String ROLE_KEY         = "KEY";
	public static final String ROLE_LABEL   	= "LABEL";
	public static final String ROLE_PREDICTOR 	= "PREDICTOR";
	
	public static final String[] ROLES = 
		new String[] { ROLE_NOROLE, 
		               ROLE_KEY, 
		               ROLE_LABEL, 
		               ROLE_PREDICTOR };
	
	/**
	 * @param name the name of a role (case senitive)
	 * @return the id representing this role or <code>0</code> if not found
	 */
	public long getIdForName(String name);

	/**
	 * @param id the ID of a role
	 * @return the role's name
	 */
	public String getNameForId(long id);
}