/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;


/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Parameter.java,v 1.4 2006/09/27 14:59:57 euler Exp $
 */
public interface Parameter extends M4Data {

	/**
	 * Constant to specify Parameters of type INPUT.
	 */
	public static final String TYPE_INPUT = "IN";

	/**
	 * Constant to specify Parameters of type OUTPUT.
	 */
	public static final String TYPE_OUTPUT = "OUT";

	public static final short TYPE_VALUE              = 0;

	public static final short TYPE_CONCEPT            = 1;

	public static final short TYPE_RELATION           = 2;

	public static final short TYPE_BASEATTRIBUTE      = 3;

	public static final short TYPE_MULTICOLUMNFEATURE = 4;

	public static final short TYPE_FEATURE            = 5;

	public static final short TYPE_PARAMETER_OBJECT   = 6;	

	//methods from core
	  
	// ***** Getter and setter methods *****

	/**
	 * This method is based on a <b>redundant</b> attribute in
	 * the database! The operator of this parameter is defined
	 * by its <code>Step</code>. Thus the getter method for the
	 * <code>Operator</code> and its ID will return the result
	 * based on the <code>Operator</code> of the associated
	 * <code>Step</code> object.
	 * 
	 * As a result of being redundant this method does not do
	 * anything!
	 * 
	 * @param op The new operator.
	 */
	public void setTheOperator(Operator op);

	/**
	 * Getter method for this <code>Parameter</code>'s <code>Operator</code>
	 * 
	 * @return the <code>Operator</code> this parameter belongs to.
	 * If no embedding <code>Step</code> can be found or the <code>Step</code>
	 * does not return its <code>Operator</code> then <code>null</code> is
	 * returned.
	 */
	public Operator getTheOperator() throws M4Exception;

	/**
	 * @param step The new <code>Step</code> for this <code>Parameter</code>
	 */
	public void setTheStep(Step step) throws M4Exception;

	/**
	 * @return The step this parameter belongs to.
	 */
	public Step getTheStep() throws M4Exception;

	/**
	 * @return TRUE if this parameter is an Input Parameter, FALSE otherwise.
	 */
	public boolean isInputParam();

	/**
	 * Same as <code>isInputParam</code>, but returns the database <code>String</code>
	 * representation for the flag.
	 * 
	 * @return the value of the input parameter flag as a <code>String</code>
	 * @see DB.c_yes
	 */
	public String getInputParam();

	/**
	 * @param is Set to TRUE if this parameter is an Input parameter, FALSE otherwise.
	 */
	public void setIsInputParam(boolean is);

	/**
	 * Each parameter is an input or an output parameter.
	 * This method expects the database <code>String</code> representation of
	 * this flag.
	 * 
	 * @param The value of the flag in database representation.
	 * @see DB.c_yes
	 */
	public void setInputParam(String inputString);

	/**
	 * @param nr the number of the loop for which this parameter is to be used
	 */
	public void setLoopNr(int nr);

	/**
	 * @return the number of the loop for which this parameter is to be used.
	 */
	public int getLoopNr();

	/**
	 * @return the type of this parameter object ("CON", "BA" etc),
	 * or <code>null</code> if the <code>ParameterObject</code> is
	 * not set.
	 */
	public String getParObjectType() throws ParameterError, M4Exception;

	/**
	 * @return the Id of the <code>ParameterObject</code> as a <code>Long</code>
	 * object, or <code>null</code> if there is no <code>ParameterObject</code>
	 * stored.
	 */
	public Long getParObjectId() throws M4Exception;

	/**
	 * @return the parameterObject, the <code>M4Data</code> object
	 * constituting the parameter. A value of <code>null</code>
	 * indicates an error.
	 */
	public ParameterObject getTheParameterObject() throws M4Exception;

	/**
	 * Sets the parameterObject.
	 * @param parameterObject The parameterObject to set
	 */
	public void setTheParameterObject(ParameterObject parameterObject)
		throws M4Exception;

	/**
	 * Returns the parameter number.
	 * @return long
	 */
	public long getParamNr();

	/**
	 * Sets the number of this parameter within its embedding parameter array
	 * @param paramNr The parameter number to set
	 */
	public void setParamNr(long paramNr);

	/*
	 * Gets the paramArray this <code>Parameter</code> belongs to or <code>null</code>.
	 * @return Returns a ParameterArray
	 *
	public ParameterArray getParamArray();
    */
	/*
	 * Sets the paramArray this <code>Parameter</code> belongs to.
	 * @param paramArray The paramArray to set. <code>null</code> indicates,
	 * that there is no corresponding <code>OpParam</code> object, so this
	 * parameter would not be loaded by the compiler.
	 *
	public void setParamArray(ParameterArray paramArray) throws M4Exception;
    */
	
	//methods from old interface

	/* Attribute methods */

	String getParameterName();

	void setParameterName(String parameterName) throws M4Exception;

	String getParameterType();

	void setParameterType(String parameterType) throws M4Exception;

	/* Association methods */

	void removeParameterObject() throws M4Exception;

	Parameter copy(Step newStep) throws M4Exception;

	/**
	 * Returns the corresponding Value object for this Parameter or null if it
	 * does not exist.
	 */
	Value getValue() throws M4Exception;

	/**
	 * Removes the Value from this Parameter and deletes it.
	 */
	void removeValue() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: Parameter.java,v $
 * Revision 1.4  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
